/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Data;
import ghidra.util.data.DataTypeParser;
import javax.swing.KeyStroke;

public class ChooseDataTypeAction
extends ListingContextAction {
    private DataPlugin plugin;
    private static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(84, 0);
    private static final String ACTION_NAME = "Choose Data Type";

    public ChooseDataTypeAction(DataPlugin plugin) {
        super(ACTION_NAME, plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.initKeyStroke(KEY_BINDING);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        DataType dataType = this.getDataType(context);
        if (dataType != null) {
            this.plugin.createData(dataType, context, false, true);
        }
    }

    private DataType getDataType(ListingActionContext context) {
        PluginTool tool = this.plugin.getTool();
        Data data = this.plugin.getDataUnit(context);
        int noSizeRestriction = -1;
        DataTypeSelectionDialog selectionDialog = new DataTypeSelectionDialog((ServiceProvider)tool, (DataTypeManager)data.getProgram().getDataTypeManager(), noSizeRestriction, DataTypeParser.AllowedDataTypes.ALL);
        DataType dt = data.getDataType();
        selectionDialog.setInitialDataType(dt);
        tool.showDialog((DialogComponentProvider)selectionDialog);
        return selectionDialog.getUserChosenDataType();
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        return this.plugin.isCreateDataAllowed(context);
    }
}

