/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class CloneCodeViewerAction
extends DockingAction {
    private final CodeViewerProvider provider;

    public CloneCodeViewerAction(String owner, CodeViewerProvider provider) {
        super("Code Viewer Clone", owner);
        this.provider = provider;
        GIcon image = new GIcon("icon.provider.clone");
        this.setToolBarData(new ToolBarData((Icon)image, "zzzz"));
        this.setDescription("Create a snapshot (disconnected) copy of this Listing window ");
        this.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
        this.setKeyBindingData(new KeyBindingData(84, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof ProgramActionContext) {
            ProgramActionContext programContext = (ProgramActionContext)context;
            return programContext.getProgram() != null;
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        this.provider.cloneWindow();
    }
}

