/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.objc;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.objc.AbstractObjcTypeMetadata;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1TypeMetadata;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2TypeMetadata;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class ObjcTypeMetadataAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Objective-C Type Metadata Analyzer";
    private static final String DESCRIPTION = "Discovers Objective-C type metadata records.";
    private AbstractObjcTypeMetadata typeMetadata;

    public ObjcTypeMetadataAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return Objc1Constants.isObjectiveC(program) || Objc2Constants.isObjectiveC2(program);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (this.typeMetadata != null) {
            return true;
        }
        try {
            if (Objc1Constants.isObjectiveC(program)) {
                this.typeMetadata = new Objc1TypeMetadata(program, monitor, log);
            } else if (Objc2Constants.isObjectiveC2(program)) {
                this.typeMetadata = new Objc2TypeMetadata(program, monitor, log);
            }
            if (this.typeMetadata != null) {
                this.typeMetadata.applyTo();
            }
            return true;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void analysisEnded(Program program) {
        if (this.typeMetadata != null) {
            this.typeMetadata.close();
            this.typeMetadata = null;
        }
    }
}

