/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.merge.util.MergeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class EquateMerger
extends AbstractListingMerger {
    static final String EQUATES_PHASE = "Equates";
    EquateConflict currentConflict;
    EquateTable latestEquateTab;
    EquateTable myEquateTab;
    EquateTable originalEquateTab;
    AddressSetView latestDetailSet;
    AddressSetView myDetailSet;
    AddressSet conflictSet;
    Hashtable<Address, ArrayList<EquateConflict>> conflicts;
    private VerticalChoicesPanel conflictPanel;
    private int equateChoice = 0;

    EquateMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.latestEquateTab = this.latestPgm.getEquateTable();
        this.myEquateTab = this.myPgm.getEquateTable();
        this.originalEquateTab = this.originalPgm.getEquateTable();
        this.conflictSet = new AddressSet();
        this.conflicts = new Hashtable();
    }

    @Override
    public String getConflictType() {
        return "Equate";
    }

    @Override
    public boolean apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.equateChoice = this.conflictOption;
        }
        return super.apply();
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws CancelledException {
        this.initializeAutoMerge("Auto-merging Equates and determining conflicts.", progressMin, progressMax, monitor);
        ProgramDiffFilter filter = new ProgramDiffFilter(512);
        this.latestDetailSet = this.listingMergeMgr.diffOriginalLatest.getDifferences(filter, monitor);
        this.myDetailSet = this.listingMergeMgr.diffOriginalMy.getDifferences(filter, monitor);
        AddressSet tmpAutoSet = new AddressSet();
        AddressSet possibleConflicts = new AddressSet();
        MergeUtilities.adjustSets(this.latestDetailSet, this.myDetailSet, tmpAutoSet, possibleConflicts);
        AddressSet mergedCodeUnits = this.listingMergeMgr.getMergedCodeUnits();
        tmpAutoSet.delete((AddressSetView)mergedCodeUnits);
        this.mergeAllEquates(tmpAutoSet, 4, monitor);
        possibleConflicts.delete((AddressSetView)mergedCodeUnits);
        this.mergeManager.updateProgress(progressMin + (progressMax - progressMin) / 3);
        CodeUnitIterator iter = this.resultPgm.getListing().getCodeUnits((AddressSetView)possibleConflicts, true);
        while (iter.hasNext()) {
            CodeUnit resultCU = iter.next();
            Address addr = resultCU.getMinAddress();
            int numOps = resultCU.getNumOperands();
            for (int opIndex = 0; opIndex < numOps; ++opIndex) {
                Scalar[] scalars;
                for (Scalar scalar : scalars = this.getScalars(resultCU, opIndex)) {
                    monitor.checkCancelled();
                    this.getOperandScalarConflicts(addr, opIndex, scalar);
                }
            }
        }
        this.updateProgress(100, "Done auto-merging Equates and determining conflicts.");
    }

    private void getOperandScalarConflicts(Address addr, int opIndex, Scalar scalar) {
        long scalarValue = scalar.getValue();
        Equate latestEquate = this.latestEquateTab.getEquate(addr, opIndex, scalarValue);
        Equate myEquate = this.myEquateTab.getEquate(addr, opIndex, scalarValue);
        Equate originalEquate = this.originalEquateTab.getEquate(addr, opIndex, scalarValue);
        boolean sameOriginalLatest = this.sameEquates(originalEquate, latestEquate);
        boolean sameOriginalMy = this.sameEquates(originalEquate, myEquate);
        boolean sameLatestMy = this.sameEquates(latestEquate, myEquate);
        if (sameLatestMy) {
            return;
        }
        if (!sameOriginalMy) {
            if (sameOriginalLatest) {
                this.merge(addr, opIndex, scalar, 4);
            } else {
                this.saveConflict(addr, opIndex, scalar);
            }
        }
    }

    private boolean sameEquates(Equate equate1, Equate equate2) {
        if (equate1 == null) {
            return equate2 == null;
        }
        return equate1.equals((Object)equate2);
    }

    private Scalar[] getScalars(CodeUnit codeUnit, int opIndex) {
        Scalar cuScalar = codeUnit.getScalar(opIndex);
        if (cuScalar != null) {
            return new Scalar[]{cuScalar};
        }
        ArrayList<Scalar> list = new ArrayList<Scalar>();
        if (codeUnit instanceof Instruction) {
            Object[] objs = ((Instruction)codeUnit).getOpObjects(opIndex);
            for (int index = 0; index < objs.length; ++index) {
                Scalar scalar;
                if (index < 0 || index >= objs.length || !(objs[index] instanceof Scalar) || list.contains(scalar = (Scalar)objs[index])) continue;
                list.add(scalar);
            }
        }
        return list.toArray(new Scalar[list.size()]);
    }

    private void saveConflict(Address address, int opIndex, Scalar scalar) {
        ArrayList<EquateConflict> list = this.conflicts.get(address);
        if (list == null) {
            list = new ArrayList(1);
            this.conflicts.put(address, list);
        }
        list.add(new EquateConflict(this, address, opIndex, scalar));
        this.conflictSet.addRange(address, address);
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictSet.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        ArrayList<EquateConflict> list = this.conflicts.get(addr);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private void merge(Address address, int opIndex, Scalar scalar, int chosenConflictOption) {
        if ((chosenConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.mergeEquate(address, opIndex, scalar.getValue());
        } else if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.mergeEquate(address, opIndex, scalar.getValue());
        } else if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.mergeEquate(address, opIndex, scalar.getValue());
        }
    }

    private void mergeAllEquates(AddressSet addressSet, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        if ((chosenConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.mergeEquates((AddressSetView)addressSet, monitor);
        } else if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.mergeEquates((AddressSetView)addressSet, monitor);
        } else if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.mergeEquates((AddressSetView)addressSet, monitor);
        }
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (!this.hasConflict(addr)) {
            return;
        }
        monitor.setMessage("Resolving Equate conflicts.");
        boolean askUser = chosenConflictOption == 0;
        ArrayList<EquateConflict> list = this.conflicts.get(addr);
        if (list != null) {
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                EquateConflict equateConflict = list.get(i);
                if (this.equateChoice != 0) {
                    this.merge(equateConflict.address, equateConflict.opIndex, equateConflict.scalar, this.equateChoice);
                    continue;
                }
                if (askUser && this.mergeManager != null) {
                    this.setupConflictPanel(listingPanel, equateConflict);
                    monitor.checkCancelled();
                    continue;
                }
                this.merge(equateConflict.address, equateConflict.opIndex, equateConflict.scalar, chosenConflictOption);
            }
        }
    }

    private void setupConflictPanel(final ListingMergePanel listingPanel, EquateConflict equateConflict) {
        this.currentConflict = equateConflict;
        this.currentAddress = equateConflict.address;
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EquateMerger.this.conflictOption = EquateMerger.this.conflictPanel.getSelectedOptions();
                    if (EquateMerger.this.conflictOption == 0) {
                        if (EquateMerger.this.mergeManager != null) {
                            EquateMerger.this.mergeManager.setApplyEnabled(false);
                        }
                        return;
                    }
                    if (EquateMerger.this.mergeManager != null) {
                        EquateMerger.this.mergeManager.clearStatusText();
                    }
                    EquateConflict conflictInfo = EquateMerger.this.currentConflict;
                    EquateMerger.this.merge(conflictInfo.address, conflictInfo.opIndex, conflictInfo.scalar, EquateMerger.this.conflictOption);
                    if (EquateMerger.this.mergeManager != null) {
                        EquateMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    EquateConflict conflictInfo = EquateMerger.this.currentConflict;
                    Address address = conflictInfo.address;
                    int opIndex = conflictInfo.opIndex;
                    long value = conflictInfo.scalar.getValue();
                    Equate latest = EquateMerger.this.latestEquateTab.getEquate(address, opIndex, value);
                    Equate my = EquateMerger.this.myEquateTab.getEquate(address, opIndex, value);
                    Equate original = EquateMerger.this.originalEquateTab.getEquate(address, opIndex, value);
                    if (EquateMerger.this.conflictPanel != null) {
                        EquateMerger.this.conflictPanel.clear();
                    } else {
                        EquateMerger.this.conflictPanel = new VerticalChoicesPanel();
                        EquateMerger.this.currentConflictPanel = EquateMerger.this.conflictPanel;
                    }
                    EquateMerger.this.conflictPanel.setTitle("Equate");
                    StringBuffer conflictBuf = new StringBuffer();
                    conflictBuf.append("The equate changes at address ");
                    ConflictUtility.addAddress(conflictBuf, address);
                    conflictBuf.append(" and operand ");
                    ConflictUtility.addCount(conflictBuf, opIndex);
                    conflictBuf.append(" are in conflict. Select the desired result.");
                    EquateMerger.this.conflictPanel.setHeader(conflictBuf.toString());
                    EquateMerger.this.conflictPanel.setRowHeader(EquateMerger.this.getEquateInfo(-1, null));
                    EquateMerger.this.conflictPanel.addRadioButtonRow(EquateMerger.this.getEquateInfo(1, latest), "LatestVersionRB", 2, changeListener);
                    EquateMerger.this.conflictPanel.addRadioButtonRow(EquateMerger.this.getEquateInfo(2, my), "CheckedOutVersionRB", 4, changeListener);
                    EquateMerger.this.conflictPanel.addInfoRow(EquateMerger.this.getEquateInfo(3, original));
                    boolean useForAll = EquateMerger.this.equateChoice != 0;
                    EquateMerger.this.conflictPanel.setUseForAll(useForAll);
                    EquateMerger.this.conflictPanel.setConflictType("Equate");
                    listingPanel.setBottomComponent(EquateMerger.this.conflictPanel);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EquateConflict conflictInfo = EquateMerger.this.currentConflict;
                    Address address = conflictInfo.address;
                    listingPanel.clearAllBackgrounds();
                    listingPanel.paintAllBackgrounds((AddressSetView)new AddressSet(address, address));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    private String[] getEquateInfo(int version, Equate equate) {
        String[] info = new String[]{"", "", ""};
        if (version == 1) {
            info[0] = this.getChoice("Latest", equate);
        } else if (version == 2) {
            info[0] = this.getChoice("Checked Out", equate);
        } else if (version == 3) {
            info[0] = " 'Original' version";
        } else {
            return new String[]{"Option", "Equate", "Value"};
        }
        if (equate != null) {
            info[1] = equate.getDisplayName();
            info[2] = NumericUtilities.toSignedHexString((long)equate.getValue());
        }
        return info;
    }

    private String getChoice(String version, Equate equate) {
        if (equate == null) {
            return "No equate as in '" + version + "' version";
        }
        return "Keep '" + version + "' version";
    }

    @Override
    public AddressSetView getConflicts() {
        return this.conflictSet;
    }

    private class EquateConflict {
        Address address;
        int opIndex;
        Scalar scalar;

        EquateConflict(EquateMerger equateMerger, Address address, int opIndex, Scalar scalar) {
            this.address = address;
            this.opIndex = opIndex;
            this.scalar = scalar;
        }
    }
}

