/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.facade;

import ghidra.features.bsim.query.description.DatabaseInformation;

public class DatabaseInfo {
    private final String serverURL;
    private final DatabaseInformation databaseInformation;

    public DatabaseInfo(String serverURL, DatabaseInformation databaseInformation) {
        this.serverURL = serverURL;
        this.databaseInformation = databaseInformation;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getName() {
        return this.databaseInformation.databasename;
    }

    public String getOwner() {
        return this.databaseInformation.owner;
    }

    public String getDescription() {
        return this.databaseInformation.description;
    }

    public String getVersion() {
        return Short.toString(this.databaseInformation.major) + "." + Short.toString(this.databaseInformation.minor);
    }

    public boolean isReadOnly() {
        return this.databaseInformation.readonly;
    }

    public String toString() {
        return "Database: " + this.serverURL + "\ntName: " + this.getName() + "\n\tOwner: " + this.getOwner() + "\n\tVersion: " + this.getVersion() + "\n\tDescription: " + this.getDescription();
    }
}

