/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.markuptype.FunctionEntryPointBasedAbstractMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.FunctionNameStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class FunctionNameMarkupType
extends FunctionEntryPointBasedAbstractMarkupType {
    public static final VTMarkupType INSTANCE = new FunctionNameMarkupType();

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        Namespace namespace;
        String defaultFunctionName;
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        Function srcFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (srcFunction == null || destinationFunction == null) {
            return list;
        }
        Address srcAddress = srcFunction.getEntryPoint();
        String srcFunctionName = srcFunction.getName();
        if (srcFunctionName.equals(defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)srcAddress)) && (namespace = srcFunction.getParentNamespace()) instanceof GlobalNamespace) {
            return list;
        }
        MarkupItemImpl markupItemImpl = new MarkupItemImpl(association, this, srcAddress);
        markupItemImpl.setDefaultDestinationAddress(association.getDestinationAddress(), "Function");
        list.add(markupItemImpl);
        return list;
    }

    private FunctionNameMarkupType() {
        super("Function Name");
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType applyAction) {
        return applyAction == VTMarkupItemApplyActionType.ADD || applyAction == VTMarkupItemApplyActionType.ADD_AS_PRIMARY || applyAction == VTMarkupItemApplyActionType.REPLACE_DEFAULT_ONLY || applyAction == VTMarkupItemApplyActionType.REPLACE;
    }

    @Override
    public Stringable getSourceValue(VTAssociation association, Address sourceAddress) {
        Function function = this.getSourceFunction(association);
        if (function == null) {
            return null;
        }
        Symbol symbol = function.getSymbol();
        return new FunctionNameStringable(symbol);
    }

    @Override
    public void unapplyMarkup(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        if (!markupItem.canUnapply()) {
            throw new VersionTrackingApplyException("Attempted to unapply a non-applied markup item");
        }
        FunctionNameStringable srcStringable = (FunctionNameStringable)markupItem.getSourceValue();
        Address destAddress = markupItem.getDestinationAddress();
        FunctionNameStringable destStringable = (FunctionNameStringable)markupItem.getOriginalDestinationValue();
        Program destProgram = this.getDestinationProgram(markupItem.getAssociation());
        FunctionManager fm = destProgram.getFunctionManager();
        Function destFunction = fm.getFunctionAt(destAddress);
        if (destFunction == null) {
            return;
        }
        this.restorePrimarySymbol(destAddress, destStringable, destProgram);
        this.unapplyFunctionName(srcStringable, destAddress, destStringable, destFunction);
    }

    private void restorePrimarySymbol(Address destAddress, FunctionNameStringable destStringable, Program destProgram) {
        String destinationNamespace;
        String originalSymbolName;
        SymbolTable symbolTable = destProgram.getSymbolTable();
        Symbol originalSymbol = this.getSymbol(symbolTable, originalSymbolName = destStringable.getSymbolName(), destAddress, destinationNamespace = destStringable.getSymbolNamespace());
        if (originalSymbol == null) {
            return;
        }
        if (originalSymbol.getSymbolType() != SymbolType.LABEL) {
            return;
        }
        if (originalSymbol.isPrimary()) {
            return;
        }
        Address address = originalSymbol.getAddress();
        String name = originalSymbol.getName();
        Namespace ns = originalSymbol.getParentNamespace();
        SetLabelPrimaryCmd setLabelPrimaryCmd = new SetLabelPrimaryCmd(address, name, ns);
        setLabelPrimaryCmd.applyTo(destProgram);
    }

    private Symbol getSymbol(SymbolTable symbolTable, String name, Address address, String namespacePath) {
        Symbol[] symbols;
        String expectedNamespacePath = namespacePath;
        if (expectedNamespacePath == null) {
            expectedNamespacePath = "Global";
        }
        for (Symbol s : symbols = symbolTable.getSymbols(address)) {
            Namespace namespace;
            String symbolNamespacePath;
            String symbolName = s.getName();
            if (!symbolName.equals(name) || !(symbolNamespacePath = (namespace = s.getParentNamespace()).getName(true)).equals(expectedNamespacePath)) continue;
            return s;
        }
        return null;
    }

    private void unapplyFunctionName(FunctionNameStringable sourceStringable, Address destAddress, FunctionNameStringable destStringable, Function destFunction) throws VersionTrackingApplyException {
        String originalFunctionName = destStringable.getSymbolName(true);
        String currentFunctionName = destFunction.getName(true);
        if (currentFunctionName.equals(originalFunctionName)) {
            String srcName;
            Namespace destNamespace = destFunction.getParentNamespace();
            Program destProgram = destFunction.getProgram();
            SymbolTable symbolTable = destProgram.getSymbolTable();
            Symbol srcAsLabel = symbolTable.getSymbol(srcName = sourceStringable.getSymbolName(), destAddress, destNamespace);
            if (srcAsLabel != null) {
                srcAsLabel.delete();
                return;
            }
            String srcNsString = sourceStringable.getSymbolNamespace();
            srcAsLabel = this.getSymbol(symbolTable, srcName, destAddress, srcNsString);
            if (srcAsLabel != null) {
                srcAsLabel.delete();
                return;
            }
            srcAsLabel = this.getSymbol(symbolTable, srcName, destAddress, null);
            if (srcAsLabel != null) {
                srcAsLabel.delete();
            }
            return;
        }
        try {
            destStringable.unapplyFunctionNameAndNamespace(destFunction);
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException("Unable to restore function name: " + originalFunctionName, e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException("Unable to restore function name: " + originalFunctionName, e);
        }
        catch (CircularDependencyException e) {
            throw new VersionTrackingApplyException("Unable to restore function name: " + originalFunctionName + " due to circular dependancy on namespaces", e);
        }
    }

    @Override
    public boolean applyMarkup(VTMarkupItem markupItem, ToolOptions markupOptions) throws VersionTrackingApplyException {
        boolean replaceNamespace;
        VTMatchApplyChoices.FunctionNameChoices nameChoice = (VTMatchApplyChoices.FunctionNameChoices)markupOptions.getEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME);
        if (nameChoice == VTMatchApplyChoices.FunctionNameChoices.EXCLUDE) {
            throw new IllegalArgumentException("Can't apply " + markupItem.getMarkupType().getDisplayName() + " since it is excluded.");
        }
        Address destAddress = markupItem.getDestinationAddress();
        if (destAddress == null) {
            throw new VersionTrackingApplyException("The destination address cannot be null!");
        }
        if (destAddress == Address.NO_ADDRESS) {
            throw new VersionTrackingApplyException("The destination address cannot be No Address!");
        }
        Program destProgram = this.getDestinationProgram(markupItem.getAssociation());
        FunctionManager fm = destProgram.getFunctionManager();
        Function destFunction = fm.getFunctionAt(destAddress);
        if (destFunction == null) {
            throw new VersionTrackingApplyException("Couldn't find destination function to apply a name.");
        }
        Symbol destSymbol = destFunction.getSymbol();
        SourceType destSource = destSymbol.getSource();
        if (nameChoice == VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY && destSource != SourceType.DEFAULT) {
            return false;
        }
        FunctionNameStringable srcStringable = (FunctionNameStringable)markupItem.getSourceValue();
        if (srcStringable == null) {
            throw new VersionTrackingApplyException("Cannot apply function name.  The function from the source program no longer exists. Markup Item: " + String.valueOf(markupItem));
        }
        Function srcFunction = this.getSourceFunction(markupItem.getAssociation());
        if (!this.hasAnythingToApply(srcStringable, srcFunction, replaceNamespace = markupOptions.getBoolean("Apply Markup Options.Replace Namespace", VTOptionDefines.DEFAULT_OPTION_FOR_NAMESPACE_FUNCTIONS))) {
            return false;
        }
        if (this.cannotAddDefaultSymbol(nameChoice, srcStringable)) {
            return false;
        }
        this.applyFunctionName(nameChoice, srcFunction, destFunction, srcStringable, replaceNamespace);
        return true;
    }

    private boolean cannotAddDefaultSymbol(VTMatchApplyChoices.FunctionNameChoices nameChoice, FunctionNameStringable sourceStringable) {
        SourceType srcSourceType;
        return (nameChoice == VTMatchApplyChoices.FunctionNameChoices.ADD || nameChoice == VTMatchApplyChoices.FunctionNameChoices.ADD_AS_PRIMARY) && (srcSourceType = sourceStringable.getSymbolSourceType()) == SourceType.DEFAULT;
    }

    private boolean hasAnythingToApply(FunctionNameStringable srcStringable, Function srcFunction, boolean replaceNamespace) {
        if (srcStringable.getSymbolSourceType() != SourceType.DEFAULT) {
            return true;
        }
        Namespace srcNamespace = srcFunction.getParentNamespace();
        if (srcNamespace instanceof GlobalNamespace) {
            return false;
        }
        return replaceNamespace;
    }

    private void applyFunctionName(VTMatchApplyChoices.FunctionNameChoices nameChoice, Function srcFunction, Function destFunction, FunctionNameStringable srcStringable, boolean replaceNamespace) throws VersionTrackingApplyException {
        String name = srcStringable.getSymbolName();
        try {
            this.doApplyFunctionName(nameChoice, srcFunction, destFunction, srcStringable, replaceNamespace);
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException("Unable to apply function name: " + name + " due to a duplicate name", e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException("Unable to apply function name: " + name + " due to invalid input", e);
        }
        catch (CircularDependencyException e) {
            throw new VersionTrackingApplyException("Unable to apply function name: " + name + " due to circular dependancy on namespaces", e);
        }
    }

    private void doApplyFunctionName(VTMatchApplyChoices.FunctionNameChoices nameChoice, Function srcFunction, Function destFunction, FunctionNameStringable srcStringable, boolean replaceNamespace) throws VersionTrackingApplyException, DuplicateNameException, InvalidInputException, CircularDependencyException {
        boolean isPrimary;
        if (nameChoice == VTMatchApplyChoices.FunctionNameChoices.REPLACE_ALWAYS || nameChoice == VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY) {
            if (replaceNamespace) {
                srcStringable.applyFunctionNameAndNamespace(destFunction);
            } else {
                srcStringable.applyFunctionName(destFunction);
            }
            return;
        }
        if (destFunction.isExternal()) {
            String srcName = srcStringable.getSymbolName();
            String destName = destFunction.getName();
            String msg = "Can't add function name '%s' to external function '%s'. External function names can only be replaced.";
            String formatted = msg.formatted(srcName, destName);
            throw new VersionTrackingApplyException(formatted);
        }
        boolean bl = isPrimary = nameChoice == VTMatchApplyChoices.FunctionNameChoices.ADD_AS_PRIMARY;
        if (replaceNamespace) {
            srcStringable.addFunctionNameAndNamespace(srcFunction, destFunction, isPrimary);
        } else {
            srcStringable.addFunctionName(destFunction, isPrimary);
        }
    }

    @Override
    public ProgramLocation getDestinationLocation(VTAssociation association, Address destAddress) {
        Address defaultDestAddress = association.getDestinationAddress();
        FunctionNameFieldLocation functionNameLocation = this.getFunctionNameLocation(association, defaultDestAddress, false);
        if (functionNameLocation != null) {
            return functionNameLocation;
        }
        LabelFieldLocation labelLocation = this.getPrimaryLabelLocation(association, defaultDestAddress, false);
        if (labelLocation != null) {
            return labelLocation;
        }
        Program program = this.getDestinationProgram(association);
        return new AddressFieldLocation(program, defaultDestAddress);
    }

    @Override
    public ProgramLocation getSourceLocation(VTAssociation association, Address sourceAddress) {
        Address defaultSourceAddress = association.getSourceAddress();
        FunctionNameFieldLocation functionNameLocation = this.getFunctionNameLocation(association, defaultSourceAddress, true);
        if (functionNameLocation != null) {
            return functionNameLocation;
        }
        LabelFieldLocation labelLocation = this.getPrimaryLabelLocation(association, defaultSourceAddress, true);
        if (labelLocation != null) {
            return labelLocation;
        }
        Program program = this.getSourceProgram(association);
        return new AddressFieldLocation(program, defaultSourceAddress);
    }

    private FunctionNameFieldLocation getFunctionNameLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        Function function = program.getFunctionManager().getFunctionContaining(address);
        if (function == null) {
            return null;
        }
        Address entryAddress = function.getEntryPoint();
        FunctionNameStringable value = (FunctionNameStringable)(isSource ? this.getSourceValue(association, address) : this.getCurrentDestinationValue(association, address));
        String name = value != null ? value.getSymbolName() : "";
        return new FunctionNameFieldLocation(program, entryAddress, name);
    }

    private LabelFieldLocation getPrimaryLabelLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        Symbol primarySymbol = program.getSymbolTable().getPrimarySymbol(address);
        if (primarySymbol == null) {
            return null;
        }
        return new LabelFieldLocation(primarySymbol);
    }

    @Override
    public Stringable getCurrentDestinationValue(VTAssociation association, Address destAddress) {
        Address expectedDestAddress = association.getDestinationAddress();
        if (!expectedDestAddress.equals((Object)destAddress)) {
            return null;
        }
        Function function = this.getDestinationFunction(association);
        if (function == null) {
            return null;
        }
        String functionName = function.getName();
        Namespace namespace = function.getParentNamespace();
        Program program = this.getDestinationProgram(association);
        Address address = association.getDestinationAddress();
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(functionName, address, namespace);
        return new FunctionNameStringable(symbol);
    }

    @Override
    public Stringable getOriginalDestinationValue(VTAssociation association, Address destinationAddress) {
        return this.getCurrentDestinationValue(association, destinationAddress);
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.FunctionNameChoices functionNameChoice = (VTMatchApplyChoices.FunctionNameChoices)options.getEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME);
        switch (functionNameChoice) {
            case ADD: 
            case ADD_AS_PRIMARY: {
                return VTMarkupItemApplyActionType.ADD;
            }
            case REPLACE_DEFAULT_ONLY: 
            case REPLACE_ALWAYS: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.ADD);
                break;
            }
            case ADD_AS_PRIMARY: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.ADD_AS_PRIMARY);
                break;
            }
            case REPLACE_DEFAULT_ONLY: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY);
                break;
            }
            case REPLACE: {
                applyOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_ALWAYS);
                break;
            }
            case REPLACE_FIRST_ONLY: {
                break;
            }
        }
        return options;
    }

    @Override
    public boolean hasSameSourceAndDestinationValues(VTMarkupItem markupItem) {
        VTAssociation association = markupItem.getAssociation();
        Function sourceFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (sourceFunction == null || destinationFunction == null) {
            return false;
        }
        String sourceName = sourceFunction.getName(true);
        String destinationName = destinationFunction.getName(true);
        return sourceName.equals(destinationName);
    }
}

