/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.AddressRangeIterators;
import ghidra.util.DifferenceAddressSetView;

public class SymmetricDifferenceAddressSetView
extends AbstractAddressSetView {
    private final AddressSetView a;
    private final AddressSetView b;

    public SymmetricDifferenceAddressSetView(AddressSetView a, AddressSetView b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean contains(Address addr) {
        return this.a.contains(addr) ^ this.b.contains(addr);
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return AddressRangeIterators.xor(this.a.iterator(), this.b.iterator(), null, true);
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean forward) {
        return AddressRangeIterators.xor(this.a.iterator(forward), this.b.iterator(forward), null, forward);
    }

    protected static Address fixStart(AddressRangeIterator rev, boolean forward) {
        if (!rev.hasNext()) {
            return null;
        }
        AddressRange rng = (AddressRange)rev.next();
        return forward ? rng.getMinAddress() : rng.getMaxAddress();
    }

    protected static Address rewindIfBounding(AddressRangeIterator rev, Address start, boolean forward) {
        if (!rev.hasNext()) {
            return null;
        }
        AddressRange rng = (AddressRange)rev.next();
        if (forward) {
            if (rng.getMaxAddress().isSuccessor(start)) {
                return rng.getMinAddress();
            }
        } else if (start.isSuccessor(rng.getMinAddress())) {
            return rng.getMaxAddress();
        }
        return null;
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        AddressRangeIterator rev = AddressRangeIterators.xor(this.a.iterator(start, !forward), this.b.iterator(start, !forward), start, !forward);
        Address fixedStart = SymmetricDifferenceAddressSetView.fixStart(rev, start, forward);
        Address fixA = SymmetricDifferenceAddressSetView.rewindIfBounding(this.a.getAddressRanges(fixedStart, !forward), fixedStart, forward);
        if (fixA != null) {
            fixedStart = fixA;
        } else {
            Address fixB = SymmetricDifferenceAddressSetView.rewindIfBounding(this.b.getAddressRanges(fixedStart, !forward), fixedStart, forward);
            if (fixB != null) {
                fixedStart = fixB;
            }
        }
        return AddressRangeIterators.xor(this.a.iterator(fixedStart, forward), this.b.iterator(fixedStart, forward), start, forward);
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        AddressRange br;
        AddressRange ar = this.a.getRangeContaining(address);
        if (ar != null == ((br = this.b.getRangeContaining(address)) != null)) {
            return null;
        }
        AddressRange rng = ar != null ? ar : br;
        AddressSetView v = ar != null ? this.b : this.a;
        return DifferenceAddressSetView.truncate(rng, address, v);
    }
}

