/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.theme.GColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    private static Color BORDER_COLOR = new GColor("color.fg");
    private final Color color;

    ColorIcon(Color color) {
        this.color = color;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(x + 1, y + 1, 14, 14);
        g.setColor(Color.BLACK);
        g.drawLine(x + 1, y + 1, x + 16 - 2, y + 16 - 2);
        g.setColor(this.color);
        g.fillRect(x + 1, y + 1, 14, 14);
        g.setColor(BORDER_COLOR);
        g.drawLine(x + 1, y, x + 16 - 2, y);
        g.drawLine(x + 16 - 1, y + 1, x + 16 - 1, y + 16 - 2);
        g.drawLine(x + 1, y + 16 - 1, x + 16 - 2, y + 16 - 1);
        g.drawLine(x, y + 1, x, y + 16 - 2);
    }

    public int getRGBValue() {
        return this.color.getRGB();
    }
}

