/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.CursorPosition;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.search.SearchLocationContext;
import ghidra.app.plugin.core.decompile.actions.DecompilerCursorPosition;

public class DecompilerSearchLocation
extends SearchLocation {
    private final FieldLocation fieldLocation;
    private String textLine;

    public DecompilerSearchLocation(FieldLocation fieldLocation, int startIndexInclusive, int endIndexInclusive, String text, boolean forwardDirection, String textLine, int lineNumber, SearchLocationContext context) {
        super(startIndexInclusive, endIndexInclusive, text, lineNumber, context);
        this.fieldLocation = fieldLocation;
        this.textLine = textLine;
    }

    public FieldLocation getFieldLocation() {
        return this.fieldLocation;
    }

    public String getTextLine() {
        return this.textLine;
    }

    public CursorPosition getCursorPosition() {
        return new DecompilerCursorPosition(this.fieldLocation);
    }

    protected String fieldsToString() {
        return super.fieldsToString() + ", fieldLocation=" + String.valueOf(this.fieldLocation);
    }

    public boolean contains(FieldLocation other) {
        int otherLine;
        int line = this.getLineNumber();
        if (line != (otherLine = other.getIndex().intValue() + 1)) {
            return false;
        }
        int col = other.getCol();
        return this.contains(col);
    }
}

