/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.schema;

import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceRegisterContainer;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.iface.TraceAggregate;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathMatcher;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.trace.model.target.schema.DefaultTraceObjectSchema;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface TraceObjectSchema {
    public SchemaContext getContext();

    public SchemaName getName();

    public Class<?> getType();

    public Set<Class<? extends TraceObjectInterface>> getInterfaces();

    public boolean isCanonicalContainer();

    public Map<String, SchemaName> getElementSchemas();

    default public SchemaName getDefaultElementSchema() {
        return PrimitiveTraceObjectSchema.OBJECT.getName();
    }

    default public SchemaName getElementSchema(String index) {
        SchemaName schemaName = this.getElementSchemas().get(index);
        return schemaName == null ? this.getDefaultElementSchema() : schemaName;
    }

    public Map<String, AttributeSchema> getAttributeSchemas();

    public Map<String, String> getAttributeAliases();

    default public String checkAliasedAttribute(String name) {
        return this.getAttributeAliases().getOrDefault(name, name);
    }

    default public AttributeSchema getDefaultAttributeSchema() {
        return AttributeSchema.DEFAULT_ANY;
    }

    default public AttributeSchema getAttributeSchema(String name) {
        AttributeSchema attributeSchema = this.getAttributeSchemas().get(name);
        return attributeSchema == null ? this.getDefaultAttributeSchema() : attributeSchema;
    }

    default public SchemaName getChildSchemaName(String key) {
        if (KeyPath.isIndex(key)) {
            return this.getElementSchema(KeyPath.parseIndex(key));
        }
        return this.getAttributeSchema(key).getSchema();
    }

    default public TraceObjectSchema getChildSchema(String key) {
        SchemaName name = this.getChildSchemaName(key);
        return this.getContext().getSchema(name);
    }

    default public TraceObjectSchema getSuccessorSchema(KeyPath path) {
        return Private.getSuccessorSchema(this, path, 0);
    }

    default public List<TraceObjectSchema> getSuccessorSchemas(KeyPath path) {
        ArrayList<TraceObjectSchema> result = new ArrayList<TraceObjectSchema>();
        TraceObjectSchema schema = this;
        result.add(schema);
        for (String key : path) {
            schema = schema.getChildSchema(key);
            result.add(schema);
        }
        return result;
    }

    default public PathFilter searchFor(Class<? extends TraceObjectInterface> type, boolean requireCanonical) {
        return this.searchFor(type, KeyPath.ROOT, requireCanonical);
    }

    default public PathFilter searchFor(Class<? extends TraceObjectInterface> type, KeyPath prefix, boolean requireCanonical) {
        if (type == TraceObjectInterface.class) {
            throw new IllegalArgumentException("Must provide a specific interface");
        }
        HashSet<PathPattern> patterns = new HashSet<PathPattern>();
        Private.searchFor(this, patterns, prefix, true, type, false, requireCanonical, new HashSet<TraceObjectSchema>());
        return PathMatcher.any(patterns.stream());
    }

    default public KeyPath searchForCanonicalContainer(Class<? extends TraceObjectInterface> type) {
        if (type == TraceObjectInterface.class) {
            throw new IllegalArgumentException("Must provide a specific interface");
        }
        SchemaContext ctx = this.getContext();
        HashSet<TraceObjectSchema> visited = new HashSet<TraceObjectSchema>();
        HashSet<TraceObjectSchema> visitedAsElement = new HashSet<TraceObjectSchema>();
        HashSet<Private.CanonicalSearchEntry> allOnLevel = new HashSet<Private.CanonicalSearchEntry>();
        allOnLevel.add(new Private.CanonicalSearchEntry(KeyPath.ROOT, false, this));
        while (!allOnLevel.isEmpty()) {
            KeyPath found = null;
            for (Private.CanonicalSearchEntry ent : allOnLevel) {
                if (!ent.schema.getInterfaces().contains(type) || !ent.parentIsCanonical) continue;
                if (found != null) {
                    return null;
                }
                found = ent.path.parent();
            }
            if (found != null) {
                return found;
            }
            HashSet<Private.CanonicalSearchEntry> nextLevel = new HashSet<Private.CanonicalSearchEntry>();
            for (Private.CanonicalSearchEntry ent : allOnLevel) {
                if (PathPattern.isWildcard(ent.path.key())) continue;
                for (Map.Entry<String, AttributeSchema> entry : ent.schema.getAttributeSchemas().entrySet()) {
                    TraceObjectSchema attrSchema = ctx.getSchema(entry.getValue().getSchema());
                    if (!TraceObjectInterface.class.isAssignableFrom(attrSchema.getType()) && !TraceObject.class.isAssignableFrom(attrSchema.getType()) || !visited.add(attrSchema)) continue;
                    nextLevel.add(new Private.CanonicalSearchEntry(ent.path.key(entry.getKey()), false, attrSchema));
                }
                for (Map.Entry<String, Object> entry : ent.schema.getElementSchemas().entrySet()) {
                    TraceObjectSchema elemSchema = ctx.getSchema((SchemaName)entry.getValue());
                    visited.add(elemSchema);
                    if (!visitedAsElement.add(elemSchema)) continue;
                    nextLevel.add(new Private.CanonicalSearchEntry(ent.path.index(entry.getKey()), ent.schema.isCanonicalContainer(), elemSchema));
                }
                TraceObjectSchema deSchema = ctx.getSchema(ent.schema.getDefaultElementSchema());
                visited.add(deSchema);
                if (!visitedAsElement.add(deSchema)) continue;
                nextLevel.add(new Private.CanonicalSearchEntry(ent.path.index(""), ent.schema.isCanonicalContainer(), deSchema));
            }
            allOnLevel = nextLevel;
        }
        return null;
    }

    default public KeyPath searchForSuitable(Class<? extends TraceObjectInterface> type, KeyPath path) {
        List<TraceObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TraceObjectSchema schema = schemas.get(path.size());
            if (schema.getInterfaces().contains(type)) {
                return path;
            }
            KeyPath inAgg = Private.searchForSuitableInAggregate(schema, type);
            if (inAgg != null) {
                return path.extend(inAgg);
            }
            path = path.parent();
        }
        return null;
    }

    default public KeyPath searchForSuitable(TraceObjectSchema schema, KeyPath path) {
        List<TraceObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TraceObjectSchema check = schemas.get(path.size());
            if (schema.isAssignableFrom(check)) {
                return path;
            }
            KeyPath inAgg = Private.searchForSuitableInAggregate(check, schema);
            if (inAgg != null) {
                return path.extend(inAgg);
            }
            path = path.parent();
        }
        return null;
    }

    default public PathFilter filterForSuitable(Class<? extends TraceObjectInterface> type, KeyPath path) {
        HashSet<PathPattern> patterns = new HashSet<PathPattern>();
        HashSet<TraceObjectSchema> visited = new HashSet<TraceObjectSchema>();
        List<TraceObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TraceObjectSchema schema = schemas.get(path.size());
            Private.searchFor(schema, patterns, path, false, type, true, false, visited);
            path = path.parent();
        }
        return PathMatcher.any(patterns.stream());
    }

    default public KeyPath searchForSuitableContainer(Class<? extends TraceObjectInterface> type, KeyPath path) {
        List<TraceObjectSchema> schemas = this.getSuccessorSchemas(path);
        while (path != null) {
            TraceObjectSchema schema = schemas.get(path.size());
            TraceObjectSchema deSchema = schema.getContext().getSchema(schema.getDefaultElementSchema());
            if (deSchema.getInterfaces().contains(type) && schema.isCanonicalContainer()) {
                return path;
            }
            KeyPath inAgg = Private.searchForSuitableContainerInAggregate(schema, type);
            if (inAgg != null) {
                return path.extend(inAgg);
            }
            path = path.parent();
        }
        return null;
    }

    default public KeyPath searchForAncestor(Class<? extends TraceObjectInterface> type, KeyPath path) {
        while (path != null) {
            TraceObjectSchema schema = this.getSuccessorSchema(path);
            if (schema.getInterfaces().contains(type)) {
                return path;
            }
            path = path.parent();
        }
        return null;
    }

    default public KeyPath searchForAncestorContainer(Class<? extends TraceObjectInterface> type, KeyPath path) {
        while (path != null) {
            TraceObjectSchema deSchema;
            TraceObjectSchema schema = this.getSuccessorSchema(path);
            if (schema.isCanonicalContainer() && (deSchema = schema.getContext().getSchema(schema.getDefaultElementSchema())).getInterfaces().contains(type)) {
                return path;
            }
            path = path.parent();
        }
        return null;
    }

    default public boolean isHidden(String key) {
        if (KeyPath.isIndex(key)) {
            return false;
        }
        AttributeSchema schema = this.getAttributeSchema(key);
        return schema.isHidden(key);
    }

    default public void validateTypeAndInterfaces(Object value, KeyPath parentPath, String key, boolean strict) {
        Class<?> cls = value.getClass();
        if (!this.getType().isAssignableFrom(cls)) {
            String path = key == null ? null : parentPath.key(key).toString();
            String msg = path == null ? "Value " + String.valueOf(value) + " does not conform to required type " + String.valueOf(this.getType()) + " of schema " + String.valueOf(this) : "Value " + String.valueOf(value) + " for " + path + " does not conform to required type " + String.valueOf(this.getType()) + " of schema " + String.valueOf(this);
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
        for (Class<? extends TraceObjectInterface> iface : this.getInterfaces()) {
            if (iface.isAssignableFrom(cls)) continue;
            String msg = "Value " + String.valueOf(value) + " does not implement required interface " + String.valueOf(iface) + " of schema " + String.valueOf(this);
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
    }

    default public void validateRequiredAttributes(TraceObject object, boolean strict, long snap) {
        Set present = object.getAttributes(Lifespan.at(snap)).stream().map(a -> a.getEntryKey()).collect(Collectors.toUnmodifiableSet());
        Set absent = this.getAttributeSchemas().values().stream().filter(AttributeSchema::isRequired).map(AttributeSchema::getName).filter(a -> !present.contains(a)).collect(Collectors.toSet());
        if (!absent.isEmpty()) {
            String msg = "Object " + String.valueOf(object) + " is missing required attributes " + String.valueOf(absent) + " of schema " + String.valueOf(this);
            Msg.error((Object)this, (Object)msg);
            if (strict) {
                throw new AssertionError((Object)msg);
            }
        }
    }

    default public PathFilter searchForRegisterContainer(int frameLevel, KeyPath path) {
        KeyPath simple = this.searchForSuitable(TraceRegisterContainer.class, path);
        if (simple != null) {
            return PathFilter.pattern(simple);
        }
        KeyPath stackPath = this.searchForSuitable(TraceStack.class, path);
        if (stackPath == null) {
            return PathFilter.NONE;
        }
        PathPattern framePatternRelStack = this.getSuccessorSchema(stackPath).searchFor(TraceStackFrame.class, false).getSingletonPattern();
        if (framePatternRelStack == null) {
            return PathFilter.NONE;
        }
        if (framePatternRelStack.countWildcards() != 1) {
            return null;
        }
        HashSet<PathPattern> patterns = new HashSet<PathPattern>();
        for (String string : List.of(Integer.toString(frameLevel), "0x" + Integer.toHexString(frameLevel))) {
            KeyPath framePathRelStack = framePatternRelStack.applyKeys(string).getSingletonPath();
            KeyPath framePath = stackPath.extend(framePathRelStack);
            KeyPath regsPath = this.searchForSuitable(TraceRegisterContainer.class, framePath);
            if (regsPath == null) continue;
            patterns.add(new PathPattern(regsPath));
        }
        return PathMatcher.any(patterns.stream());
    }

    default public int computeFrameLevel(KeyPath path) {
        int i;
        KeyPath framePath = this.searchForAncestor(TraceStackFrame.class, path);
        if (framePath == null) {
            return 0;
        }
        KeyPath stackPath = this.searchForAncestor(TraceStack.class, framePath);
        int n = i = stackPath == null ? 0 : stackPath.size();
        while (i < framePath.size()) {
            String key = framePath.key(i);
            if (KeyPath.isIndex(key)) {
                return Integer.decode(KeyPath.parseIndex(key));
            }
            ++i;
        }
        throw new IllegalArgumentException("No index between stack and frame");
    }

    default public boolean isAssignableFrom(TraceObjectSchema that) {
        return this.equals(that);
    }

    public record SchemaName(String name) implements Comparable<SchemaName>
    {
        @Override
        public final String toString() {
            return this.name;
        }

        @Override
        public int compareTo(SchemaName o) {
            return this.name.compareTo(o.name);
        }
    }

    public static interface AttributeSchema {
        public static final AttributeSchema DEFAULT_ANY = new DefaultTraceObjectSchema.DefaultAttributeSchema("", PrimitiveTraceObjectSchema.ANY.getName(), false, false, Hidden.DEFAULT);
        public static final AttributeSchema DEFAULT_OBJECT = new DefaultTraceObjectSchema.DefaultAttributeSchema("", PrimitiveTraceObjectSchema.OBJECT.getName(), false, false, Hidden.DEFAULT);
        public static final AttributeSchema DEFAULT_VOID = new DefaultTraceObjectSchema.DefaultAttributeSchema("", PrimitiveTraceObjectSchema.VOID.getName(), false, true, Hidden.TRUE);

        public String getName();

        public SchemaName getSchema();

        public boolean isRequired();

        public boolean isFixed();

        default public boolean isHidden(String name) {
            return this.getHidden().isHidden(name);
        }

        public Hidden getHidden();
    }

    public static class Private {
        private static void searchFor(TraceObjectSchema sch, Set<PathPattern> patterns, KeyPath prefix, boolean parentIsCanonical, Class<? extends TraceObjectInterface> type, boolean requireAggregate, boolean requireCanonical, Set<TraceObjectSchema> visited) {
            if (sch instanceof PrimitiveTraceObjectSchema) {
                return;
            }
            if (sch.getInterfaces().contains(type) && (parentIsCanonical || !requireCanonical)) {
                patterns.add(new PathPattern(prefix));
                return;
            }
            if (!visited.add(sch)) {
                return;
            }
            if (requireAggregate && !sch.getInterfaces().contains(TraceAggregate.class)) {
                return;
            }
            SchemaContext ctx = sch.getContext();
            boolean isCanonical = sch.isCanonicalContainer();
            for (Map.Entry<String, SchemaName> ent : sch.getElementSchemas().entrySet()) {
                KeyPath extended = prefix.index(ent.getKey());
                TraceObjectSchema traceObjectSchema = ctx.getSchema(ent.getValue());
                Private.searchFor(traceObjectSchema, patterns, extended, isCanonical, type, requireAggregate, requireCanonical, visited);
            }
            KeyPath deExtended = prefix.key("[]");
            TraceObjectSchema deSchema = ctx.getSchema(sch.getDefaultElementSchema());
            Private.searchFor(deSchema, patterns, deExtended, isCanonical, type, requireAggregate, requireCanonical, visited);
            for (Map.Entry entry : sch.getAttributeSchemas().entrySet()) {
                KeyPath extended = prefix.key((String)entry.getKey());
                TraceObjectSchema attrSchema = ctx.getSchema(((AttributeSchema)entry.getValue()).getSchema());
                Private.searchFor(attrSchema, patterns, extended, isCanonical, type, requireAggregate, requireCanonical, visited);
            }
            KeyPath daExtended = prefix.key("");
            TraceObjectSchema traceObjectSchema = ctx.getSchema(sch.getDefaultAttributeSchema().getSchema());
            Private.searchFor(traceObjectSchema, patterns, daExtended, isCanonical, type, requireAggregate, requireCanonical, visited);
            visited.remove(sch);
        }

        static KeyPath searchForInAggregate(TraceObjectSchema seed, Predicate<SearchEntry> predicate) {
            InAggregateSearch inAgg = new InAggregateSearch(seed);
            while (!inAgg.allOnLevel.isEmpty()) {
                Set found = inAgg.allOnLevel.stream().filter(predicate).collect(Collectors.toSet());
                if (!found.isEmpty()) {
                    if (found.size() == 1) {
                        return ((SearchEntry)found.iterator().next()).path;
                    }
                    return null;
                }
                inAgg.nextLevel();
            }
            return null;
        }

        static KeyPath searchForSuitableInAggregate(TraceObjectSchema seed, Class<? extends TraceObjectInterface> type) {
            return Private.searchForInAggregate(seed, ent -> ent.schema.getInterfaces().contains(type));
        }

        static KeyPath searchForSuitableInAggregate(TraceObjectSchema seed, TraceObjectSchema schema) {
            return Private.searchForInAggregate(seed, ent -> ent.schema == schema);
        }

        static KeyPath searchForSuitableContainerInAggregate(TraceObjectSchema seed, Class<? extends TraceObjectInterface> type) {
            return Private.searchForInAggregate(seed, ent -> {
                if (!ent.schema.isCanonicalContainer()) {
                    return false;
                }
                TraceObjectSchema deSchema = ent.schema.getContext().getSchema(ent.schema.getDefaultElementSchema());
                return deSchema.getInterfaces().contains(type);
            });
        }

        static TraceObjectSchema getSuccessorSchema(TraceObjectSchema schema, KeyPath path, int i) {
            if (i >= path.size()) {
                return schema;
            }
            TraceObjectSchema childSchema = schema.getChildSchema(path.key(i));
            return Private.getSuccessorSchema(childSchema, path, i + 1);
        }

        private static class InAggregateSearch
        extends BreadthFirst<SearchEntry> {
            final Set<TraceObjectSchema> visited = new HashSet<TraceObjectSchema>();

            public InAggregateSearch(TraceObjectSchema seed) {
                super(Set.of(new SearchEntry(KeyPath.ROOT, seed)));
            }

            @Override
            public boolean descendAttributes(SearchEntry ent) {
                return ent.schema.getInterfaces().contains(TraceAggregate.class);
            }

            @Override
            public boolean descendElements(SearchEntry ent) {
                return ent.schema.isCanonicalContainer();
            }

            @Override
            public void expandAttribute(Set<SearchEntry> nextLevel, SearchEntry ent, TraceObjectSchema schema, KeyPath path) {
                if (this.visited.add(schema)) {
                    nextLevel.add(new SearchEntry(path, schema));
                }
            }

            @Override
            public void expandDefaultAttribute(Set<SearchEntry> nextLevel, SearchEntry ent) {
            }

            @Override
            public void expandElements(Set<SearchEntry> nextLevel, SearchEntry ent) {
            }

            @Override
            public void expandDefaultElement(Set<SearchEntry> nextLevel, SearchEntry ent) {
            }
        }

        private static class SearchEntry {
            final KeyPath path;
            final TraceObjectSchema schema;

            public SearchEntry(KeyPath path, TraceObjectSchema schema) {
                this.path = path;
                this.schema = schema;
            }
        }

        private static class CanonicalSearchEntry
        extends SearchEntry {
            final boolean parentIsCanonical;

            public CanonicalSearchEntry(KeyPath path, boolean parentIsCanonical, TraceObjectSchema schema) {
                super(path, schema);
                this.parentIsCanonical = parentIsCanonical;
            }
        }

        private static abstract class BreadthFirst<T extends SearchEntry> {
            Set<T> allOnLevel = new HashSet<T>();

            public BreadthFirst(Set<T> seed) {
                this.allOnLevel.addAll(seed);
            }

            public void expandAttributes(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                for (AttributeSchema as : ((SearchEntry)ent).schema.getAttributeSchemas().values()) {
                    try {
                        SchemaName schema = as.getSchema();
                        TraceObjectSchema child = ctx.getSchema(schema);
                        this.expandAttribute(nextLevel, ent, child, ((SearchEntry)ent).path.key(as.getName()));
                    }
                    catch (NullPointerException npe) {
                        Msg.error((Object)this, (Object)("Null schema for " + String.valueOf(as)));
                    }
                }
            }

            public void expandDefaultAttribute(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                AttributeSchema das = ((SearchEntry)ent).schema.getDefaultAttributeSchema();
                TraceObjectSchema child = ctx.getSchema(das.getSchema());
                this.expandAttribute(nextLevel, ent, child, ((SearchEntry)ent).path.key(das.getName()));
            }

            public void expandElements(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                for (Map.Entry<String, SchemaName> elemEnt : ((SearchEntry)ent).schema.getElementSchemas().entrySet()) {
                    TraceObjectSchema child = ctx.getSchema(elemEnt.getValue());
                    this.expandElement(nextLevel, ent, child, ((SearchEntry)ent).path.index(elemEnt.getKey()));
                }
            }

            public void expandDefaultElement(Set<T> nextLevel, T ent) {
                SchemaContext ctx = ((SearchEntry)ent).schema.getContext();
                TraceObjectSchema child = ctx.getSchema(((SearchEntry)ent).schema.getDefaultElementSchema());
                this.expandElement(nextLevel, ent, child, ((SearchEntry)ent).path.index(""));
            }

            public void nextLevel() {
                HashSet<T> nextLevel = new HashSet<T>();
                for (SearchEntry ent : this.allOnLevel) {
                    if (this.descendAttributes(ent)) {
                        this.expandAttributes(nextLevel, ent);
                        this.expandDefaultAttribute(nextLevel, ent);
                    }
                    if (!this.descendElements(ent)) continue;
                    this.expandElements(nextLevel, ent);
                    this.expandDefaultElement(nextLevel, ent);
                }
                this.allOnLevel = nextLevel;
            }

            public boolean descendAttributes(T ent) {
                return true;
            }

            public boolean descendElements(T ent) {
                return true;
            }

            public void expandAttribute(Set<T> nextLevel, T ent, TraceObjectSchema schema, KeyPath path) {
            }

            public void expandElement(Set<T> nextLevel, T ent, TraceObjectSchema schema, KeyPath path) {
            }
        }
    }

    public static enum Hidden {
        DEFAULT{

            @Override
            public boolean isHidden(String name) {
                return name.startsWith("_");
            }

            @Override
            public Hidden adjust(String name) {
                return name.isEmpty() ? this : FALSE;
            }
        }
        ,
        TRUE{

            @Override
            public boolean isHidden(String name) {
                return true;
            }
        }
        ,
        FALSE{

            @Override
            public boolean isHidden(String name) {
                return false;
            }
        };


        public abstract boolean isHidden(String var1);

        public Hidden adjust(String name) {
            return this;
        }
    }
}

