/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.Register;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.listing.DBTraceDataAdapter;
import ghidra.trace.database.listing.InternalTraceBaseDefinedUnitsView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceDefinedDataView;
import ghidra.trace.util.TraceRegisterUtils;

@Internal
public interface InternalTraceDefinedDataView
extends TraceDefinedDataView,
InternalTraceBaseDefinedUnitsView<TraceData> {
    default public TracePlatform getPlatformOf(DataType type) {
        TraceBasedDataTypeManager dtm;
        DataTypeManager dataTypeManager = type.getDataTypeManager();
        if (dataTypeManager instanceof TraceBasedDataTypeManager && (dtm = (TraceBasedDataTypeManager)dataTypeManager).getTrace() == this.getTrace()) {
            return dtm.getPlatform();
        }
        return this.getTrace().getPlatformManager().getHostPlatform();
    }

    @Override
    public DBTraceDataAdapter create(Lifespan var1, Address var2, TracePlatform var3, DataType var4) throws CodeUnitInsertionException;

    @Override
    public DBTraceDataAdapter create(Lifespan var1, Address var2, TracePlatform var3, DataType var4, int var5) throws CodeUnitInsertionException;

    @Override
    default public DBTraceDataAdapter create(Lifespan lifespan, Address address, DataType dataType, int length) throws CodeUnitInsertionException {
        return this.create(lifespan, address, this.getPlatformOf(dataType), dataType, length);
    }

    @Override
    default public DBTraceDataAdapter create(Lifespan lifespan, Address address, DataType dataType) throws CodeUnitInsertionException {
        return this.create(lifespan, address, this.getPlatformOf(dataType), dataType);
    }

    @Override
    default public DBTraceDataAdapter create(TracePlatform platform, Lifespan lifespan, Register register, DataType dataType) throws CodeUnitInsertionException {
        TraceRegisterUtils.requireByteBound(register);
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        return this.create(lifespan, range.getMinAddress(), platform, dataType, (int)range.getLength());
    }
}

