/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BinOpGen;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntSDivOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntSDivOpGen implements IntBinOpGen<JitIntSDivOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return true;
    }

    private void generateMpIntSDiv(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        BinOpGen.generateMpDelegationToStaticMethod(gen, type, "mpIntSignedDivide", mv, 1, BinOpGen.TakeOut.OUT);
    }

    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntSDivOp op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniform(gen, lType, rType, this.ext(), rv);
    }

    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntSDivOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniform(gen, rType, lType, this.rExt(), rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    rv.visitInsn(108);
                    break block6;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    rv.visitInsn(109);
                    break block6;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() != lType.size()) {
                        n = 3;
                        continue block6;
                    }
                    this.generateMpIntSDiv(gen, t, rv);
                    break block6;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    throw new AssertionError((Object)"forceUniform didn't work?");
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return rType;
    }
}

