/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;

public interface PcodeEmulationCallbacks<T> {
    public static <T> PcodeEmulationCallbacks<T> none() {
        return NoPcodeEmulationCallbacks.INSTANCE;
    }

    default public void emulatorCreated(PcodeMachine<T> machine) {
    }

    default public void sharedStateCreated(PcodeMachine<T> machine) {
    }

    default public void threadCreated(PcodeThread<T> thread) {
    }

    default public PcodeProgram getInject(PcodeThread<T> thread, Address address) {
        return null;
    }

    default public void beforeExecuteInject(PcodeThread<T> thread, Address address, PcodeProgram program) {
    }

    default public void afterExecuteInject(PcodeThread<T> thread, Address address) {
    }

    default public void beforeDecodeInstruction(PcodeThread<T> thread, Address counter, RegisterValue context) {
    }

    default public void beforeExecuteInstruction(PcodeThread<T> thread, Instruction instruction, PcodeProgram program) {
    }

    default public void afterExecuteInstruction(PcodeThread<T> thread, Instruction instruction) {
    }

    default public void beforeStepOp(PcodeThread<T> thread, PcodeOp op, PcodeFrame frame) {
    }

    default public void afterStepOp(PcodeThread<T> thread, PcodeOp op, PcodeFrame frame) {
    }

    default public void beforeLoad(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size) {
    }

    default public void afterLoad(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size, T value) {
    }

    default public void beforeStore(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size, T value) {
    }

    default public void afterStore(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size, T value) {
    }

    default public void afterBranch(PcodeThread<T> thread, PcodeOp op, Address target) {
    }

    default public boolean handleMissingUserop(PcodeThread<T> thread, PcodeOp op, PcodeFrame frame, String opName, PcodeUseropLibrary<T> library) {
        return false;
    }

    default public <A, U> void dataWritten(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length, U value) {
    }

    default public <A, U> void delegateDataWritten(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length, U value) {
        this.dataWritten(thread, piece, piece.getAddressArithmetic().toAddress(offset, space, PcodeArithmetic.Purpose.STORE), length, value);
    }

    default public <A, U> void dataWritten(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, Address address, int length, U value) {
    }

    default public <A, U> void delegateDataWritten(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, Address address, int length, U value) {
        this.dataWritten(thread, piece, address.getAddressSpace(), piece.getAddressArithmetic().fromConst(address), length, value);
    }

    default public <A, U> int readUninitialized(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length) {
        return 0;
    }

    default public <A, U> int delegateReadUninitialized(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length) {
        AddressSetView remains;
        long lOffset = piece.getAddressArithmetic().toLong(offset, PcodeArithmetic.Purpose.LOAD);
        AddressSet set = PcodeStateCallbacks.rngSet(space, lOffset, length);
        if (set == (remains = this.readUninitialized(thread, piece, (AddressSetView)set))) {
            return 0;
        }
        set.delete(remains);
        AddressRange first = set.getFirstRange();
        return first == null ? 0 : (int)first.getLength();
    }

    default public <A, U> AddressSetView readUninitialized(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSetView set) {
        return set;
    }

    default public <A, U> AddressSetView delegateReadUninitialized(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSetView set) {
        if (set.isEmpty()) {
            return set;
        }
        boolean result = false;
        AddressSet remains = new AddressSet(set);
        for (AddressRange range : set) {
            int l = this.readUninitialized(thread, piece, range.getAddressSpace(), piece.getAddressArithmetic().fromConst(range.getMinAddress()), (int)range.getLength());
            if (l == 0) continue;
            remains.delete(range.getMinAddress(), range.getMinAddress().add((long)(l - 1)));
            result = true;
        }
        return result ? remains : set;
    }

    default public PcodeStateCallbacks wrapFor(PcodeThread<T> thread) {
        return new Wrapper<T>(thread, this);
    }

    public static enum NoPcodeEmulationCallbacks implements PcodeEmulationCallbacks<Object>
    {
        INSTANCE;

    }

    public record Wrapper<T>(PcodeThread<T> thread, PcodeEmulationCallbacks<T> cb) implements PcodeStateCallbacks
    {
        public <A, U> void dataWritten(PcodeExecutorStatePiece<A, U> piece, Address address, int length, U value) {
            this.cb.dataWritten(this.thread, piece, address, length, value);
        }

        public <A, U> void dataWritten(PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length, U value) {
            this.cb.dataWritten(this.thread, piece, space, offset, length, value);
        }

        public <A, U> int readUninitialized(PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length) {
            return this.cb.readUninitialized(this.thread, piece, space, offset, length);
        }

        public <A, U> AddressSetView readUninitialized(PcodeExecutorStatePiece<A, U> piece, AddressSetView set) {
            return this.cb.readUninitialized(this.thread, piece, set);
        }
    }
}

