/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.emulator.AdaptedMemoryState;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emulate.BreakTable;
import ghidra.pcode.emulate.BreakTableCallBack;
import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModifiedPcodeThread<T>
extends DefaultPcodeThread<T> {
    protected final EmulateInstructionStateModifier modifier;
    protected final Emulate emulate;

    public ModifiedPcodeThread(String name, AbstractPcodeMachine<T> machine) {
        super(name, machine);
        this.emulate = new GlueEmulate(this.language, new AdaptedMemoryState<T>(this, this.state, PcodeExecutorStatePiece.Reason.EXECUTE_READ){

            @Override
            public void setMemoryBank(MemoryBank bank) {
            }
        }, new BreakTableCallBack(this.language));
        this.modifier = this.createModifier();
    }

    protected EmulateInstructionStateModifier createModifier() {
        String classname = this.language.getProperty("emulateInstructionStateModifierClass");
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(classname);
            if (!EmulateInstructionStateModifier.class.isAssignableFrom(c)) {
                Msg.error((Object)this, (Object)("Language " + String.valueOf(this.language.getLanguageID()) + " does not specify a valid emulateInstructionStateModifierClass"));
                throw new RuntimeException(classname + " does not implement interface " + EmulateInstructionStateModifier.class.getName());
            }
            Constructor<?> constructor = c.getConstructor(Emulate.class);
            return (EmulateInstructionStateModifier)constructor.newInstance(this.emulate);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Language " + String.valueOf(this.language.getLanguageID()) + " does not specify a valid emulateInstructionStateModifierClass"));
            throw new RuntimeException("Failed to instantiate " + classname + " for language " + String.valueOf(this.language.getLanguageID()), e);
        }
    }

    @Override
    protected PcodeUseropLibrary<T> createUseropLibrary() {
        return super.createUseropLibrary().compose(new ModifierUseropLibrary());
    }

    @Override
    public void overrideCounter(Address counter) {
        super.overrideCounter(counter);
        if (this.modifier != null) {
            this.modifier.initialExecuteCallback(this.emulate, counter, this.getContext());
        }
    }

    @Override
    protected void postExecuteInstruction() {
        if (this.modifier != null) {
            this.modifier.postExecuteCallback(this.emulate, this.instruction == null ? null : this.instruction.getAddress(), this.frame.copyCode(), this.frame.getBranched(), this.getCounter());
        }
    }

    protected class GlueEmulate
    extends Emulate {
        public GlueEmulate(SleighLanguage lang, MemoryState s, BreakTable b) {
            super(lang, s, b);
        }

        @Override
        public Language getLanguage() {
            return ModifiedPcodeThread.this.language;
        }

        @Override
        public void setExecuteAddress(Address addr) {
            ModifiedPcodeThread.this.overrideCounter(addr);
        }

        @Override
        public Address getExecuteAddress() {
            return ModifiedPcodeThread.this.getCounter();
        }

        @Override
        public void setContextRegisterValue(RegisterValue regValue) {
            ModifiedPcodeThread.this.overrideContext(regValue);
        }

        @Override
        public RegisterValue getContextRegisterValue() {
            return ModifiedPcodeThread.this.getContext();
        }
    }

    protected class ModifierUseropLibrary
    implements PcodeUseropLibrary<T> {
        Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> userops;

        protected ModifierUseropLibrary() {
        }

        private Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> computeUserops() {
            if (ModifiedPcodeThread.this.modifier == null) {
                return Map.of();
            }
            HashMap userops = new HashMap();
            for (Map.Entry<Integer, OpBehaviorOther> entry : ModifiedPcodeThread.this.modifier.getPcodeOpMap().entrySet()) {
                String name = ModifiedPcodeThread.this.language.getUserDefinedOpName(entry.getKey().intValue());
                userops.put(name, new ModifierUseropDefinition(name, entry.getValue()));
            }
            return userops;
        }

        @Override
        public Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> getUserops() {
            if (this.userops == null) {
                this.userops = this.computeUserops();
            }
            return this.userops;
        }

        protected class ModifierUseropDefinition
        implements PcodeUseropLibrary.PcodeUseropDefinition<T> {
            private final String name;
            private final OpBehaviorOther behavior;

            public ModifierUseropDefinition(String name, OpBehaviorOther behavior) {
                this.name = name;
                this.behavior = behavior;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public int getInputCount() {
                return -1;
            }

            @Override
            public void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library, PcodeOp op, Varnode outVar, List<Varnode> inVars) {
                this.behavior.evaluate(ModifiedPcodeThread.this.emulate, outVar, (Varnode[])inVars.toArray(Varnode[]::new));
            }

            @Override
            public boolean isFunctional() {
                return false;
            }

            @Override
            public boolean hasSideEffects() {
                return true;
            }

            @Override
            public boolean modifiesContext() {
                return true;
            }

            @Override
            public boolean canInlinePcode() {
                return false;
            }

            @Override
            public Class<?> getOutputType() {
                return Void.TYPE;
            }

            @Override
            public Method getJavaMethod() {
                return null;
            }

            @Override
            public PcodeUseropLibrary<?> getDefiningLibrary() {
                return ModifierUseropLibrary.this;
            }
        }
    }
}

