/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.search;

import docking.widgets.SearchLocation;
import docking.widgets.search.SearchResults;
import docking.widgets.search.TextComponentSearchLocation;
import generic.theme.GColor;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.worker.Worker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.View;
import util.CollectionUtils;

public class TextComponentSearchResults
extends SearchResults {
    private Color highlightColor = new GColor("color.bg.find.highlight");
    private Color activeHighlightColor = new GColor("color.bg.find.highlight.active");
    protected JEditorPane editorPane;
    private SearchResultsHighlighterWrapper highlighter;
    private DocumentListener documentListener = new DocumentChangeListener();
    private CaretListener caretListener = new CaretChangeListener();
    private SwingUpdateManager caretUpdater = new SwingUpdateManager(() -> this.setActiveHighlightBasedOnCaret());
    private boolean isUpdatingCaretInternally;
    private String name;
    private List<TextComponentSearchLocation> searchLocations;
    private TreeMap<Integer, TextComponentSearchLocation> matchesByPosition;
    private String searchText;
    private TextComponentSearchLocation activeLocation;
    private boolean isStale;

    protected TextComponentSearchResults(Worker worker, JEditorPane editorPane, String searchText, TreeMap<Integer, TextComponentSearchLocation> matchesByPosition) {
        super(worker);
        this.editorPane = editorPane;
        this.searchText = searchText;
        this.matchesByPosition = matchesByPosition;
        URL url = editorPane.getPage();
        this.name = this.getFilename(url);
        Collection<TextComponentSearchLocation> matches = matchesByPosition.values();
        this.searchLocations = new ArrayList<TextComponentSearchLocation>(matches);
        Document document = editorPane.getDocument();
        document.addDocumentListener(this.documentListener);
        editorPane.addCaretListener(this.caretListener);
        this.caretUpdater.updateLater();
        this.highlighter = this.createHighlighter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            SearchResults.SwingJob job = new SearchResults.SwingJob((SearchResults)this, this::unapplyHighlights);
            this.runJob(job);
        }
    }

    @Override
    public void activate() {
        SearchResults.ActivationJob job = this.startActivation();
        this.runJob(job);
    }

    @Override
    public void setActiveLocation(SearchLocation location) {
        if (this.isStale) {
            return;
        }
        if (this.activeLocation == location) {
            return;
        }
        if (location == null) {
            Swing.runNow(() -> this.doSetActiveLocation(null));
            return;
        }
        SearchResults.FindJob job = this.startActivation().thenRunSwing(() -> this.doSetActiveLocation(location));
        this.runActivationJob((SearchResults.ActivationJob)job);
    }

    protected SearchResults.ActivationJob startActivation() {
        if (this.isActive()) {
            return this.createFinishedActivationJob();
        }
        if (this.isStale) {
            this.unapplyHighlights();
            return this.createFinishedActivationJob();
        }
        return (SearchResults.ActivationJob)this.createActivationJob().thenRunSwing(() -> this.applyHighlights());
    }

    protected SearchResults.ActivationJob createActivationJob() {
        return new SearchResults.ActivationJob(this);
    }

    protected SearchResults.ActivationJob createFinishedActivationJob() {
        return new SearchResults.ActivationJob(this);
    }

    private void doSetActiveLocation(SearchLocation newLocation) {
        TextComponentSearchLocation oldLocation = this.activeLocation;
        this.activeLocation = (TextComponentSearchLocation)newLocation;
        if (oldLocation == newLocation) {
            this.scrollToLocation(this.activeLocation);
            return;
        }
        this.changeActiveLocation(oldLocation, this.activeLocation);
    }

    TextComponentSearchLocation getNextLocation(int searchStart, boolean searchForward) {
        Map.Entry<Integer, TextComponentSearchLocation> entry = searchForward ? this.matchesByPosition.ceilingEntry(searchStart) : this.matchesByPosition.floorEntry(searchStart);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.searchLocations.isEmpty();
    }

    @Override
    public List<SearchLocation> getLocations() {
        return CollectionUtils.asList(this.searchLocations, SearchLocation.class);
    }

    boolean isStale() {
        return this.isStale;
    }

    void setStale() {
        this.isStale = true;
        this.unapplyHighlights();
    }

    protected boolean isInvalid(String otherSearchText) {
        if (this.isStale) {
            return true;
        }
        return !this.searchText.equals(otherSearchText);
    }

    @Override
    public SearchLocation getActiveLocation() {
        return this.activeLocation;
    }

    private void updateActiveLocationForCaretChange(int caret) {
        TextComponentSearchLocation location = this.getLocation(caret);
        this.setActiveLocation(location);
    }

    private TextComponentSearchLocation getLocation(int caret) {
        Optional<TextComponentSearchLocation> optional = this.searchLocations.stream().filter(l -> l.contains(caret)).findFirst();
        return optional.orElseGet(() -> null);
    }

    private void changeActiveLocation(TextComponentSearchLocation oldLocation, TextComponentSearchLocation newLocation) {
        this.clearActiveHighlight(oldLocation);
        if (this.isStale) {
            return;
        }
        if (newLocation == null) {
            return;
        }
        newLocation.setActive(true);
        this.doHighlightLocation(newLocation);
        this.scrollToLocation(newLocation);
    }

    private void clearActiveHighlight(TextComponentSearchLocation location) {
        if (location == null) {
            return;
        }
        location.setActive(false);
        this.doHighlightLocation(location);
    }

    private void scrollToLocation(TextComponentSearchLocation location) {
        if (location == null) {
            return;
        }
        int caret = this.editorPane.getCaretPosition();
        if (!location.contains(caret)) {
            this.setCaretPositionInternally(location);
        }
        this.scrollToVisible(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCaretPositionInternally(TextComponentSearchLocation location) {
        if (this.isStale) {
            return;
        }
        Document doc = this.editorPane.getDocument();
        int len = doc.getLength();
        if (len == 0) {
            return;
        }
        this.isUpdatingCaretInternally = true;
        try {
            int pos = location.getStartIndexInclusive();
            this.editorPane.setCaretPosition(pos);
        }
        finally {
            this.isUpdatingCaretInternally = false;
        }
    }

    private void scrollToVisible(TextComponentSearchLocation location) {
        try {
            int start = location.getStartIndexInclusive();
            int end = location.getEndIndexInclusive();
            Rectangle startR = this.editorPane.modelToView2D(start).getBounds();
            Rectangle endR = this.editorPane.modelToView2D(end).getBounds();
            endR.width += 20;
            Rectangle union = startR.union(endR);
            this.editorPane.scrollRectToVisible(union);
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Exception scrolling to text", (Throwable)e);
        }
    }

    private void setActiveHighlightBasedOnCaret() {
        if (!this.isActive()) {
            return;
        }
        int pos = this.editorPane.getCaretPosition();
        this.updateActiveLocationForCaretChange(pos);
    }

    private SearchResultsHighlighterWrapper createHighlighter() {
        Highlighter activeHighlighter = this.editorPane.getHighlighter();
        if (activeHighlighter == null) {
            return new SearchResultsHighlighterWrapper(null);
        }
        if (activeHighlighter instanceof SearchResultsHighlighterWrapper) {
            SearchResultsHighlighterWrapper wrapper = (SearchResultsHighlighterWrapper)activeHighlighter;
            return new SearchResultsHighlighterWrapper(wrapper.delegate);
        }
        return new SearchResultsHighlighterWrapper(activeHighlighter);
    }

    private SearchResultsHighlighterWrapper getInstalledSearchResultsHighlighter() {
        Highlighter activeHighlighter = this.editorPane.getHighlighter();
        if (activeHighlighter == null) {
            return null;
        }
        if (activeHighlighter instanceof SearchResultsHighlighterWrapper) {
            SearchResultsHighlighterWrapper wrapper = (SearchResultsHighlighterWrapper)activeHighlighter;
            return wrapper;
        }
        return null;
    }

    boolean isActive() {
        SearchResultsHighlighterWrapper activeSearchHighlighter = this.getInstalledSearchResultsHighlighter();
        return activeSearchHighlighter == this.highlighter;
    }

    Highlighter.Highlight[] getHighlights() {
        return this.highlighter.getHighlights();
    }

    private void maybeInstallHighlighter() {
        SearchResultsHighlighterWrapper activeHighlighter = this.getInstalledSearchResultsHighlighter();
        if (activeHighlighter == this.highlighter) {
            return;
        }
        if (activeHighlighter != null) {
            activeHighlighter.removeAllHighlights();
        }
        this.editorPane.setHighlighter(this.highlighter);
    }

    private void applyHighlights() {
        this.unapplyHighlights();
        this.maybeInstallHighlighter();
        Collection<TextComponentSearchLocation> locations = this.matchesByPosition.values();
        for (TextComponentSearchLocation location : locations) {
            this.doHighlightLocation(location);
        }
        this.setActiveHighlightBasedOnCaret();
    }

    private void unapplyHighlights() {
        this.setActiveLocation(null);
        Highlighter activeHighlighter = this.editorPane.getHighlighter();
        if (activeHighlighter == this.highlighter) {
            this.highlighter.removeAllHighlights();
            this.highlighter.uninstall();
        }
    }

    private void doHighlightLocation(TextComponentSearchLocation location) {
        Highlighter activeHighlighter = this.editorPane.getHighlighter();
        if (activeHighlighter != this.highlighter) {
            return;
        }
        Object tag = location.getHighlightTag();
        if (tag != null) {
            this.highlighter.removeHighlight(tag);
        }
        if (this.isStale) {
            return;
        }
        Color c = location.isActive() ? this.activeHighlightColor : this.highlightColor;
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(c);
        int start = location.getStartIndexInclusive();
        int end = location.getEndIndexInclusive() + 1;
        try {
            tag = this.highlighter.addHighlight(start, end, painter);
            location.setHighlightTag(tag);
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Exception adding highlight", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.caretUpdater.dispose();
        if (this.editorPane != null) {
            Document document = this.editorPane.getDocument();
            document.removeDocumentListener(this.documentListener);
        }
        this.matchesByPosition.clear();
        this.searchLocations.clear();
        this.highlighter.uninstall();
        this.isStale = true;
    }

    public String toString() {
        return "%s: %s (%s)".formatted(this.getClass().getSimpleName(), this.searchText, System.identityHashCode(this));
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextComponentSearchResults.this.setStale();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextComponentSearchResults.this.setStale();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class CaretChangeListener
    implements CaretListener {
        private int lastPos = -1;

        private CaretChangeListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int pos = e.getDot();
            if (TextComponentSearchResults.this.isUpdatingCaretInternally) {
                this.lastPos = pos;
                return;
            }
            if (pos == this.lastPos) {
                return;
            }
            this.lastPos = pos;
            TextComponentSearchResults.this.caretUpdater.update();
        }
    }

    private class SearchResultsHighlighterWrapper
    extends DefaultHighlighter {
        private Highlighter delegate;
        private boolean nonSearchDelegate;

        SearchResultsHighlighterWrapper(Highlighter delegate) {
            if (delegate == null) {
                delegate = new DefaultHighlighter();
                this.nonSearchDelegate = false;
            } else {
                this.nonSearchDelegate = true;
            }
            this.delegate = delegate;
        }

        void uninstall() {
            Highlighter activeHighlighter = TextComponentSearchResults.this.editorPane.getHighlighter();
            if (activeHighlighter != this) {
                return;
            }
            if (this.nonSearchDelegate) {
                TextComponentSearchResults.this.editorPane.setHighlighter(this.delegate);
            } else {
                TextComponentSearchResults.this.editorPane.setHighlighter(null);
            }
        }

        @Override
        public void install(JTextComponent c) {
            this.delegate.install(c);
        }

        @Override
        public void deinstall(JTextComponent c) {
            this.delegate.deinstall(c);
        }

        @Override
        public void paint(Graphics g) {
            this.delegate.paint(g);
        }

        @Override
        public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            Highlighter highlighter = this.delegate;
            if (highlighter instanceof LayeredHighlighter) {
                LayeredHighlighter lh = (LayeredHighlighter)highlighter;
                lh.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
            }
        }

        @Override
        public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
            return this.delegate.addHighlight(p0, p1, p);
        }

        @Override
        public void removeHighlight(Object tag) {
            this.delegate.removeHighlight(tag);
        }

        @Override
        public void removeAllHighlights() {
            this.delegate.removeAllHighlights();
        }

        @Override
        public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
            this.delegate.changeHighlight(tag, p0, p1);
        }

        @Override
        public Highlighter.Highlight[] getHighlights() {
            return this.delegate.getHighlights();
        }
    }
}

