/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.search;

import docking.widgets.SearchLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import ghidra.util.worker.Worker;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.function.BooleanSupplier;

public abstract class SearchResults {
    private Worker worker;

    protected SearchResults(Worker worker) {
        this.worker = worker;
    }

    Worker getWorker() {
        return this.worker;
    }

    public abstract String getName();

    public abstract void activate();

    public abstract void deactivate();

    public abstract void setActiveLocation(SearchLocation var1);

    public abstract SearchLocation getActiveLocation();

    public abstract List<SearchLocation> getLocations();

    public abstract boolean isEmpty();

    public abstract void dispose();

    protected String getFilename(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        if (index < 0) {
            return null;
        }
        return path.substring(index + 1);
    }

    protected void cancelAllJobsOfType(FindJob job) {
        Class<?> clazz = ((Object)((Object)job)).getClass();
        this.worker.clearAllJobs(j -> j.getClass() == clazz);
    }

    protected void runActivationJob(ActivationJob job) {
        this.cancelAllJobsOfType(job);
        this.runJob(job);
    }

    protected void runJob(FindJob job) {
        this.worker.schedule((Job)job);
    }

    protected class FindJob
    extends Job {
        protected FindJob parent;
        protected FindJob nextJob;
        protected MonitoredRunnable runnable;

        public FindJob() {
        }

        public FindJob(FindJob parent) {
            this.parent = parent;
        }

        public FindJob(FindJob parent, MonitoredRunnable r) {
            this.parent = parent;
            this.runnable = r;
        }

        public final void run(TaskMonitor monitor) throws CancelledException {
            monitor.checkCancelled();
            if (this.runnable != null) {
                this.runnable.monitoredRun(monitor);
            } else {
                this.doRun(monitor);
            }
            monitor.checkCancelled();
            if (this.nextJob != null) {
                this.nextJob.run(monitor);
            }
        }

        protected void doRun(TaskMonitor monitor) throws CancelledException {
        }

        public FindJob thenRun(MonitoredRunnable r) {
            FindJob job = new FindJob(this, r);
            this.setNextJob(job);
            return this;
        }

        public FindJob thenWait(BooleanSupplier waitFor, Duration maxWaitTime) {
            WaitJob job = new WaitJob(SearchResults.this, this, waitFor, maxWaitTime);
            this.setNextJob(job);
            return this;
        }

        public FindJob thenRunSwing(Runnable r) {
            MonitoredRunnable swingRunnable = m -> Swing.runNow(() -> {
                if (m.isCancelled()) {
                    return;
                }
                r.run();
            });
            FindJob job = new FindJob(this, swingRunnable);
            this.setNextJob(job);
            return this;
        }

        private void setNextJob(FindJob job) {
            if (this.nextJob == null) {
                this.nextJob = job;
            } else {
                this.nextJob.setNextJob(job);
            }
        }

        public String toString() {
            String base = ((Object)((Object)this)).getClass().getSimpleName() + " " + String.valueOf(SearchResults.this);
            if (this.runnable != null) {
                return "runnable-only " + base;
            }
            return base;
        }
    }

    private class WaitJob
    extends FindJob {
        private BooleanSupplier waitFor;
        private Duration maxWaitTime;

        protected WaitJob(SearchResults searchResults, FindJob parent, BooleanSupplier waitFor, Duration maxWaitTime) {
            super(parent);
            this.waitFor = waitFor;
            this.maxWaitTime = maxWaitTime;
        }

        @Override
        protected void doRun(TaskMonitor monitor) throws CancelledException {
            int sleepyTime = 250;
            int totalMs = 0;
            while ((long)totalMs < this.maxWaitTime.toMillis()) {
                monitor.checkCancelled();
                if (this.waitFor.getAsBoolean()) {
                    return;
                }
                totalMs += sleepyTime;
                this.sleep(sleepyTime);
            }
            monitor.cancel();
            throw new CancelledException();
        }

        private void sleep(int sleepyTime) throws CancelledException {
            try {
                Thread.sleep(sleepyTime);
            }
            catch (InterruptedException e) {
                Msg.debug((Object)((Object)this), (Object)"Find job interrupted while waiting");
                throw new CancelledException();
            }
        }
    }

    public class SwingJob
    extends FindJob {
        public SwingJob(SearchResults this$0, Runnable r) {
            this.runnable = m -> Swing.runNow((Runnable)r);
        }
    }

    public class ActivationJob
    extends FindJob {
        public ActivationJob(SearchResults this$0) {
        }
    }
}

