/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.search;

import docking.widgets.search.SearchLocationContext;
import generic.json.Json;
import java.util.ArrayList;
import java.util.List;

public class SearchLocationContextBuilder {
    private List<SearchLocationContext.Part> parts = new ArrayList<SearchLocationContext.Part>();

    public SearchLocationContextBuilder append(String text) {
        if (text == null) {
            text = "";
        }
        this.parts.add(new SearchLocationContext.BasicPart(text));
        return this;
    }

    public SearchLocationContextBuilder appendMatch(String text) {
        if (text == null) {
            throw new NullPointerException("Match text cannot be null");
        }
        this.parts.add(new SearchLocationContext.MatchPart(text));
        return this;
    }

    public SearchLocationContextBuilder newline() {
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("Cannot add a newline without first appending text");
        }
        SearchLocationContext.Part last = this.parts.get(this.parts.size() - 1);
        last.text = last.text + "\n";
        return this;
    }

    public SearchLocationContext build() {
        return new SearchLocationContext(this.parts);
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public String toString() {
        return Json.toString((Object)this);
    }
}

