/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.widgets.SearchLocation;
import docking.widgets.search.SearchLocationContext;
import docking.widgets.search.SearchResults;
import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.actions.DeleteTableRowAction;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class FindDialogResultsProvider
extends ComponentProvider
implements TableModelListener {
    private static final String OWNER_NAME = "Search";
    private SearchResults searchResults;
    private JPanel componentPanel;
    private FindResultsModel model;
    private GTable table;
    private GTableFilterPanel<SearchLocation> filterPanel;
    private DockingAction removeItemsAction;

    FindDialogResultsProvider(Tool tool, String title, String subTitle, SearchResults searchResults) {
        super(tool, "Find All", OWNER_NAME);
        this.searchResults = searchResults;
        this.model = new FindResultsModel(searchResults);
        this.setTransient();
        this.setTitle(title + subTitle);
        this.setSubTitle(subTitle);
        this.setWindowMenuGroup(title);
        this.componentPanel = this.buildMainPanel();
        this.updateTitle();
        this.addToTool();
        this.installRemoveItemsAction();
        this.model.addTableModelListener(this);
        this.setVisible(true);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.table = new GTable(this.model);
        this.table.setHTMLRenderingEnabled(true);
        this.filterPanel = new GTableFilterPanel<SearchLocation>(this.table, this.model);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.getTool().contextChanged(this);
        });
        this.table.setActionsEnabled(true);
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setSelectionMode(2);
        selectionModel.addListSelectionListener(lse -> {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            this.setSearchLocationFromRow();
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                FindDialogResultsProvider.this.setSearchLocationFromRow();
            }
        });
        panel.add((Component)new JScrollPane(this.table), "Center");
        panel.add(this.filterPanel, "South");
        return panel;
    }

    private void setSearchLocationFromRow() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            this.searchResults.setActiveLocation(null);
            return;
        }
        SearchLocation location = (SearchLocation)this.model.getRowObject(row);
        this.searchResults.setActiveLocation(location);
    }

    public void installRemoveItemsAction() {
        if (this.removeItemsAction != null) {
            return;
        }
        this.removeItemsAction = new DeleteTableRowAction(this.table, OWNER_NAME){

            @Override
            protected void removeSelectedItems() {
                int[] rows = FindDialogResultsProvider.this.table.getSelectedRows();
                ArrayList<Object> itemsToRemove = new ArrayList<Object>();
                for (int row : rows) {
                    itemsToRemove.add(FindDialogResultsProvider.this.model.getRowObject(row));
                }
                this.removeRowObjects(FindDialogResultsProvider.this.model, itemsToRemove);
                int restoreRow = rows[0];
                this.selectRow(FindDialogResultsProvider.this.model, restoreRow);
            }

            @Override
            protected void removeRowObjects(TableModel tm, List<Object> itemsToRemove) {
                FindDialogResultsProvider.this.model.remove(itemsToRemove);
            }
        };
        this.getTool().addLocalAction(this, this.removeItemsAction);
    }

    private String generateSubTitle() {
        int n;
        StringBuilder buffer = new StringBuilder();
        Object filteredText = "";
        if (this.filterPanel.isFiltered()) {
            filteredText = " of " + this.filterPanel.getUnfilteredRowCount();
        }
        if ((n = this.model.getRowCount()) == 1) {
            buffer.append("    (1 entry").append((String)filteredText).append(")");
        } else if (n > 1) {
            buffer.append("    (").append(n).append(" entries").append((String)filteredText).append(")");
        }
        return buffer.toString();
    }

    @Override
    public void closeComponent() {
        this.searchResults.dispose();
        super.closeComponent();
        this.filterPanel.dispose();
    }

    @Override
    public JComponent getComponent() {
        return this.componentPanel;
    }

    @Override
    public void componentActivated() {
        this.searchResults.activate();
        this.setSearchLocationFromRow();
    }

    @Override
    public void componentDeactived() {
    }

    @Override
    public void tableChanged(TableModelEvent ev) {
        this.updateTitle();
    }

    private void updateTitle() {
        this.setSubTitle(this.generateSubTitle());
    }

    public GTable getTable() {
        return this.table;
    }

    public List<SearchLocation> getResults() {
        return new ArrayList<SearchLocation>(this.model.getModelData());
    }

    private class FindResultsModel
    extends GDynamicColumnTableModel<SearchLocation, Object> {
        private List<SearchLocation> data;

        FindResultsModel(SearchResults results) {
            super((ServiceProvider)new ServiceProviderStub());
            this.data = results.getLocations();
        }

        void remove(List<Object> itemsToRemove) {
            for (Object object : itemsToRemove) {
                this.data.remove(object);
            }
            this.fireTableDataChanged();
        }

        @Override
        public List<SearchLocation> getModelData() {
            return this.data;
        }

        @Override
        protected TableColumnDescriptor<SearchLocation> createTableColumnDescriptor() {
            TableColumnDescriptor<SearchLocation> descriptor = new TableColumnDescriptor<SearchLocation>();
            descriptor.addVisibleColumn(new LineNumberColumn(this), 1, true);
            descriptor.addVisibleColumn(new ContextColumn(this));
            return descriptor;
        }

        @Override
        public String getName() {
            return "Find All Results";
        }

        @Override
        public Object getDataSource() {
            return null;
        }

        private class LineNumberColumn
        extends AbstractDynamicTableColumnStub<SearchLocation, Integer> {
            private LineNumberColumn(FindResultsModel findResultsModel) {
            }

            @Override
            public Integer getValue(SearchLocation rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.getLineNumber();
            }

            @Override
            public String getColumnName() {
                return "Line";
            }

            @Override
            public int getColumnPreferredWidth() {
                return 75;
            }
        }

        private class ContextColumn
        extends AbstractDynamicTableColumnStub<SearchLocation, SearchLocationContext> {
            private GColumnRenderer<SearchLocationContext> renderer = new ContextCellRenderer();

            private ContextColumn(FindResultsModel findResultsModel) {
            }

            @Override
            public SearchLocationContext getValue(SearchLocation rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                SearchLocationContext context = rowObject.getContext();
                return context;
            }

            @Override
            public String getColumnName() {
                return "Context";
            }

            @Override
            public GColumnRenderer<SearchLocationContext> getColumnRenderer() {
                return this.renderer;
            }

            private class ContextCellRenderer
            extends AbstractGColumnRenderer<SearchLocationContext> {
                private ContextCellRenderer() {
                    this.setHTMLRenderingEnabled(true);
                }

                @Override
                public Component getTableCellRendererComponent(GTableCellRenderingData cellData) {
                    super.getTableCellRendererComponent(cellData);
                    SearchLocation match = (SearchLocation)cellData.getRowObject();
                    SearchLocationContext context = match.getContext();
                    String text = context.getBoldMatchingText();
                    this.setText(text);
                    return this;
                }

                @Override
                public String getFilterString(SearchLocationContext context, Settings settings) {
                    return context.getPlainText();
                }
            }
        }
    }
}

