/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DockingWindowManager;
import docking.ReusableDialogComponentProvider;
import docking.Tool;
import docking.widgets.CursorPosition;
import docking.widgets.FindDialogResultsProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import docking.widgets.search.FindDialogSearcher;
import docking.widgets.search.SearchResults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import utility.function.Callback;

public class FindDialog
extends ReusableDialogComponentProvider {
    protected GhidraComboBox<String> comboBox;
    protected FindDialogSearcher searcher;
    protected SearchResults searchResults;
    private JButton nextButton;
    private JButton previousButton;
    private JButton findAllButton;
    private boolean isFindButtonApiDisabled;
    private JRadioButton stringRadioButton;
    private JRadioButton regexRadioButton;
    private Callback closedCallback = Callback.dummy();

    public FindDialog(String title, FindDialogSearcher searcher) {
        super(title, false, true, true, true);
        this.searcher = searcher;
        this.addWorkPanel(this.buildMainPanel());
        this.buildFindButtons();
        this.addDismissButton();
    }

    public void setFindAllEnabled(boolean enabled) {
        this.isFindButtonApiDisabled = !enabled;
        this.findAllButton.setEnabled(enabled);
    }

    @Override
    public void dispose() {
        this.searcher.dispose();
        super.dispose();
    }

    public void setClosedCallback(Callback c) {
        this.closedCallback = Callback.dummyIfNull((Callback)c);
    }

    protected void buildFindButtons() {
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic('N');
        this.nextButton.getAccessibleContext().setAccessibleName("Next");
        this.nextButton.addActionListener(ev -> this.doSearch(true));
        this.addButton(this.nextButton);
        this.setDefaultButton(this.nextButton);
        this.previousButton = new JButton("Previous");
        this.previousButton.setMnemonic('P');
        this.previousButton.getAccessibleContext().setAccessibleName("Previous");
        this.previousButton.addActionListener(ev -> this.doSearch(false));
        this.addButton(this.previousButton);
        this.findAllButton = new JButton("Find All");
        this.findAllButton.setMnemonic('A');
        this.findAllButton.getAccessibleContext().setAccessibleName("Find All");
        this.findAllButton.addActionListener(ev -> this.doSearchAll());
        this.addButton(this.findAllButton);
        this.enableButtons(false);
    }

    private JPanel buildMainPanel() {
        ButtonGroup formatGroup = new ButtonGroup();
        this.stringRadioButton = new GRadioButton("String", true);
        this.stringRadioButton.getAccessibleContext().setAccessibleName("String");
        this.regexRadioButton = new GRadioButton("Regular Expression", false);
        this.regexRadioButton.getAccessibleContext().setAccessibleName("Regular Expresion");
        formatGroup.add(this.stringRadioButton);
        formatGroup.add(this.regexRadioButton);
        this.comboBox = new GhidraComboBox();
        this.comboBox.setEditable(true);
        this.comboBox.addActionListener(e -> this.doSearch(true));
        this.comboBox.getAccessibleContext().setAccessibleName("Checkboxes");
        this.comboBox.setColumns(20);
        this.comboBox.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            private void handleDocumentUpdate() {
                String text = FindDialog.this.comboBox.getText();
                FindDialog.this.enableButtons(text.length() != 0);
            }
        });
        GLabel findLabel = new GLabel("Find: ");
        findLabel.getAccessibleContext().setAccessibleName("Find");
        findLabel.setDisplayedMnemonic(78);
        this.comboBox.associateLabel(findLabel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.getAccessibleContext().setAccessibleName("Find Label and Checkboxes");
        textPanel.add(findLabel);
        textPanel.add(this.comboBox);
        mainPanel.add((Component)textPanel, "North");
        mainPanel.add((Component)this.buildFormatPanel(), "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.getAccessibleContext().setAccessibleName("Find");
        return mainPanel;
    }

    protected void enableButtons(boolean b) {
        this.nextButton.setEnabled(b);
        this.previousButton.setEnabled(b);
        if (!this.isFindButtonApiDisabled) {
            this.findAllButton.setEnabled(b);
        }
    }

    private JPanel buildFormatPanel() {
        JPanel formatPanel = new JPanel();
        formatPanel.setBorder(BorderFactory.createTitledBorder("Format"));
        formatPanel.setLayout(new BoxLayout(formatPanel, 1));
        formatPanel.add(this.stringRadioButton);
        formatPanel.add(this.regexRadioButton);
        formatPanel.getAccessibleContext().setAccessibleName("Format");
        return formatPanel;
    }

    public void next() {
        this.doSearch(true);
    }

    public void previous() {
        this.doSearch(false);
    }

    protected boolean useRegex() {
        return this.regexRadioButton.isSelected();
    }

    protected void doSearch(boolean forward) {
        String wrapMessage;
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.clearStatusText();
        boolean useRegex = this.regexRadioButton.isSelected();
        String searchText = this.comboBox.getText();
        CursorPosition cursorPosition = this.searcher.getCursorPosition();
        this.searchResults = this.searcher.search(searchText, cursorPosition, forward, useRegex);
        if (this.searchResults != null) {
            this.storeSearchText(searchText);
            return;
        }
        if (forward) {
            wrapMessage = "Reached the bottom, continued from top";
            cursorPosition = this.searcher.getStart();
        } else {
            wrapMessage = "Reached the top, continued from the bottom";
            cursorPosition = this.searcher.getEnd();
        }
        this.searchResults = this.searcher.search(searchText, cursorPosition, forward, useRegex);
        if (this.searchResults != null) {
            this.storeSearchText(searchText);
            this.notifyUser(wrapMessage);
            return;
        }
        this.notifyUser("Not found");
    }

    private void notifyUser(String message) {
        this.setStatus(message);
        this.enableButtons(false);
        this.alertMessage(() -> {
            String text = this.comboBox.getText();
            this.enableButtons(text.length() != 0);
        });
    }

    protected void doSearchAll() {
        DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
        if (dwm == null) {
            return;
        }
        String searchText = this.getSearchText();
        SearchResults results = this.searcher.searchAll(searchText, this.useRegex());
        if (results.isEmpty()) {
            this.setStatus("No results found");
            return;
        }
        this.storeSearchText(this.getSearchText());
        String resultsName = results.getName();
        resultsName = StringUtils.isBlank((CharSequence)resultsName) ? "" : "[%s]".formatted(resultsName);
        String dialogTitle = this.getTitle();
        String subTitle = ": '%s' %s".formatted(searchText, resultsName);
        Tool tool = dwm.getTool();
        FindDialogResultsProvider provider = new FindDialogResultsProvider(tool, dialogTitle, subTitle, results);
        provider.setTabText("'%s'".formatted(searchText));
        this.close();
    }

    @Override
    public void toFront() {
        super.toFront();
        String text = this.comboBox.getText();
        this.enableButtons(text.length() != 0);
    }

    @Override
    protected void dialogShown() {
        this.clearStatusText();
    }

    @Override
    protected void dialogClosed() {
        this.comboBox.setText("");
        if (this.searchResults != null) {
            this.searchResults.dispose();
            this.searchResults = null;
        }
        this.closedCallback.call();
    }

    public FindDialogSearcher getSearcher() {
        return this.searcher;
    }

    String getText() {
        if (this.isVisible()) {
            return this.comboBox.getText();
        }
        return null;
    }

    void setStatus(String statusText) {
        this.setStatusText(statusText);
    }

    public void setSearchText(String text) {
        String searchText = text == null ? this.comboBox.getText() : text;
        this.comboBox.setSelectedItem(searchText);
    }

    public String getSearchText() {
        return this.comboBox.getText();
    }

    public void setHistory(List<String> history) {
        history.forEach(this.comboBox::addToModel);
    }

    protected void storeSearchText(String text) {
        MutableComboBoxModel model = (MutableComboBoxModel)this.comboBox.getModel();
        model.insertElementAt(text, 0);
        int size = model.getSize();
        for (int i = 1; i < size; ++i) {
            String element = (String)model.getElementAt(i);
            if (!element.equals(text)) continue;
            model.removeElementAt(i);
            break;
        }
        model.setSelectedItem(text);
    }
}

