/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.help.DockingHelpBroker;
import docking.util.AnimationPainter;
import docking.util.AnimationUtils;
import generic.theme.GColor;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import ghidra.util.task.SwingUpdateManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.help.WindowPresentation;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

class CalloutRequest {
    private DockingHelpBroker helpBroker;
    private Animator animator;
    private JEditorPane editorPane;
    private URL requestUrl;
    private String pageInfo;
    private PropertyChangeListener pageLoadListener = new PageLoadingListener();
    private SwingUpdateManager calloutUpdater = new SwingUpdateManager(this::doUpdate);
    private ChangeListener changeListener = e -> {
        Object source = e.getSource();
        if (source instanceof JViewport) {
            this.calloutUpdater.updateLater();
        }
    };

    CalloutRequest(DockingHelpBroker helpBroker, JEditorPane editorPane, URL requestUrl) {
        this.helpBroker = helpBroker;
        this.editorPane = editorPane;
        this.requestUrl = requestUrl;
        this.savePageInfo();
    }

    private void savePageInfo() {
        this.pageInfo = this.requestUrl.toString();
        int lastSlash = this.pageInfo.lastIndexOf(47);
        if (lastSlash < 0) {
            return;
        }
        this.pageInfo = this.pageInfo.substring(lastSlash + 1, this.pageInfo.length());
    }

    public void runLater() {
        String ref = this.requestUrl.getRef();
        if (ref == null) {
            this.dispose();
            return;
        }
        if (this.isCurrentPage(this.requestUrl)) {
            this.start();
        } else {
            this.editorPane.addPropertyChangeListener("page", this.pageLoadListener);
        }
    }

    private void start() {
        JScrollPane scrollPane = this.getScrollPane();
        JViewport viewport = scrollPane.getViewport();
        viewport.addChangeListener(this.changeListener);
        this.calloutUpdater.updateLater();
    }

    public void dispose() {
        this.calloutUpdater.dispose();
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
        }
    }

    private void doUpdate() {
        JScrollPane scrollPane = this.getScrollPane();
        JViewport viewport = scrollPane.getViewport();
        viewport.removeChangeListener(this.changeListener);
        String ref = this.requestUrl.getRef();
        Rectangle currentRefArea = this.getReferenceArea(ref);
        currentRefArea.y = (int)((double)currentRefArea.y + ((double)viewport.getHeight() - currentRefArea.getHeight()));
        this.editorPane.scrollRectToVisible(currentRefArea);
        Rectangle updatedRefArea = this.getReferenceArea(ref);
        this.doCalloutReference(updatedRefArea);
    }

    private JScrollPane getScrollPane() {
        for (Container parent = this.editorPane.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPane)) continue;
            return (JScrollPane)parent;
        }
        return null;
    }

    private Rectangle getReferenceArea(String ref) {
        int pos = this.getAnchorPosition(ref);
        if (pos == -1) {
            return null;
        }
        Rectangle2D startArea = null;
        try {
            startArea = this.editorPane.modelToView2D(pos);
        }
        catch (BadLocationException ble) {
            Msg.trace((Object)this, (Object)"Unexpected exception searching for help reference", (Throwable)ble);
            return null;
        }
        Rectangle bounds = startArea.getBounds();
        bounds.width = Math.max(bounds.width, 10);
        return bounds;
    }

    private int getAnchorPosition(String ref) {
        HTMLDocument document = (HTMLDocument)this.editorPane.getDocument();
        HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            AttributeSet attrs = it.getAttributes();
            String name = (String)attrs.getAttribute(HTML.Attribute.NAME);
            if (ref.equals(name)) {
                return it.getStartOffset();
            }
            it.next();
        }
        return -1;
    }

    private boolean isCalloutEnabled() {
        String showAidString = Preferences.getProperty((String)"SHOW.HELP.NAVIGATION.AID");
        if (showAidString == null) {
            return false;
        }
        return Boolean.parseBoolean(showAidString);
    }

    private void doCalloutReference(Rectangle area) {
        if (!this.isCalloutEnabled()) {
            return;
        }
        WindowPresentation windowPresentation = this.helpBroker.getWindowPresentation();
        Window helpWindow = windowPresentation.getHelpWindow();
        Container contentPane = null;
        contentPane = helpWindow instanceof JDialog ? ((JDialog)helpWindow).getContentPane() : ((JFrame)helpWindow).getContentPane();
        JScrollPane scrollPane = this.getScrollPane();
        JViewport viewport = scrollPane.getViewport();
        Point viewPosition = viewport.getViewPosition();
        Rectangle offsetArea = new Rectangle(area);
        offsetArea.y -= viewPosition.y;
        Rectangle relativeArea = SwingUtilities.convertRectangle(scrollPane, offsetArea, contentPane);
        StarShape star = new StarShape(relativeArea.getLocation());
        this.animator = AnimationUtils.createPaintingAnimator(helpWindow, new LocationHintPainter(this, star));
        if (this.animator == null) {
            return;
        }
        this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                CalloutRequest.this.animator = null;
                CalloutRequest.this.dispose();
            }
        });
    }

    private boolean isCurrentPage(URL newURL) {
        if (newURL == null) {
            return false;
        }
        String newFile = newURL.getFile();
        URL currentURL = this.editorPane.getPage();
        if (currentURL == null) {
            return false;
        }
        String currentFile = currentURL.getFile();
        return newFile.equals(currentFile);
    }

    public String toString() {
        return this.pageInfo;
    }

    private class PageLoadingListener
    implements PropertyChangeListener {
        private PageLoadingListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CalloutRequest.this.editorPane.removePropertyChangeListener("page", CalloutRequest.this.pageLoadListener);
            CalloutRequest.this.start();
        }
    }

    private class StarShape
    extends Path2D.Float {
        StarShape(Point location) {
            this(5, location, 1.0, 0.3);
        }

        StarShape(int points, Point location, double outerRadius, double innerRadius) {
            int width;
            double angle = Math.PI / (double)points;
            GeneralPath path = new GeneralPath();
            int scale = 20;
            double lr = Math.max(outerRadius, innerRadius);
            int height = width = (int)((double)scale * (2.0 * lr));
            double cx = location.x + width / 2;
            double cy = location.y + height / 2;
            Point2D.Double center = new Point2D.Double(cx, cy);
            double r = outerRadius;
            double x = center.x + Math.cos(0.0 * angle) * r;
            double y = center.y + Math.sin(0.0 * angle) * r;
            path.moveTo(x, y);
            for (int i = 1; i < 2 * points; ++i) {
                r = i % 2 == 0 ? outerRadius : innerRadius;
                x = center.x + Math.cos((double)i * angle) * r;
                y = center.y + Math.sin((double)i * angle) * r;
                path.lineTo(x, y);
            }
            path.closePath();
            double scx = (double)scale * cx;
            double scy = (double)scale * cy;
            double offsetx = width / 4;
            double offsety = height / 4;
            double sox = scx - offsetx;
            double soy = scy - offsety;
            double dx = sox - (double)location.x;
            double dy = soy - (double)location.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(-dx, -dy);
            xform.scale(scale, scale);
            Shape shape = xform.createTransformedShape(path);
            super.append(shape, true);
        }
    }

    private class LocationHintPainter
    implements AnimationPainter {
        private Color color = new GColor("color.bg.help.hint");
        private Shape paintShape;

        LocationHintPainter(CalloutRequest calloutRequest, Shape paintShape) {
            this.paintShape = paintShape;
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics graphics, double percentComplete) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Composite originalComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)(1.0 - percentComplete));
            g2d.setComposite(alphaComposite);
            double transition = 1.0 - percentComplete;
            Color originalColor = g2d.getColor();
            AffineTransform originalTransform = g2d.getTransform();
            double scale = 4.0 * transition;
            int degrees = (int)(480.0 * transition);
            double rad = Math.toRadians(transition * (double)degrees);
            Rectangle b = this.paintShape.getBounds();
            double cx = b.getCenterX();
            double cy = b.getCenterY();
            double scx = cx * scale;
            double scy = cy * scale;
            double dcx = scx - cx;
            double dcy = scy - cy;
            AffineTransform scaler = new AffineTransform();
            scaler.translate(-dcx, -dcy);
            scaler.scale(scale, scale);
            Shape scaled = scaler.createTransformedShape(this.paintShape);
            AffineTransform rotater = new AffineTransform();
            rotater.rotate(rad, cx, cy);
            Shape finalShape = rotater.createTransformedShape(scaled);
            g2d.setColor(this.color);
            g2d.fill(finalShape);
            g2d.setColor(originalColor);
            g2d.setTransform(originalTransform);
            g2d.setComposite(originalComposite);
        }
    }
}

