/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.store.LockException;
import ghidra.util.NotOwnerException;
import ghidra.util.ReadOnlyException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultLocalGhidraProtocolConnector
extends GhidraProtocolConnector {
    private ProjectLocator localStorageLocator;
    private boolean readOnly;

    DefaultLocalGhidraProtocolConnector(URL ghidraURL) throws MalformedURLException {
        super(ghidraURL);
        try {
            this.localStorageLocator = GhidraURL.getProjectStorageLocator(ghidraURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    protected void checkHostInfo() throws MalformedURLException {
        String host = this.url.getHost();
        if (host.length() != 0) {
            throw new MalformedURLException("unsupported host specification");
        }
    }

    @Override
    public String getRepositoryName() {
        return this.localStorageLocator.getName();
    }

    @Override
    protected String parseItemPath() throws MalformedURLException {
        String path = this.url.getQuery();
        this.initFolderItemPath(path);
        return path != null ? path : this.folderPath;
    }

    @Override
    protected void connect(RepositoryAdapter repository) throws IOException {
        throw new UnsupportedOperationException("local project access only");
    }

    public ProjectLocator getLocalProjectLocator() {
        return this.localStorageLocator;
    }

    @Override
    protected URL getRepositoryRootGhidraURL() {
        return null;
    }

    @Override
    public boolean isReadOnly() throws NotConnectedException {
        if (this.statusCode == null) {
            throw new NotConnectedException("not connected");
        }
        return this.readOnly;
    }

    @Override
    public GhidraURLConnection.StatusCode connect(boolean readOnlyAccess) throws IOException {
        this.readOnly = readOnlyAccess;
        this.statusCode = !this.localStorageLocator.exists() ? GhidraURLConnection.StatusCode.NOT_FOUND : GhidraURLConnection.StatusCode.OK;
        return this.statusCode;
    }

    DefaultProjectData getLocalProjectData(boolean readOnlyAccess) throws IOException {
        if (this.connect(readOnlyAccess) != GhidraURLConnection.StatusCode.OK) {
            return null;
        }
        try {
            return new DefaultProjectData(this.localStorageLocator, !readOnlyAccess, false);
        }
        catch (NotOwnerException | ReadOnlyException e) {
            this.statusCode = GhidraURLConnection.StatusCode.UNAUTHORIZED;
        }
        catch (LockException e) {
            this.statusCode = GhidraURLConnection.StatusCode.LOCKED;
        }
        return null;
    }
}

