/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.DockingUtils;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.DataTreeNode;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.main.datatree.PasteFileTask;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyCutBaseAction;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ProjectDataPasteAction
extends ProjectDataCopyCutBaseAction {
    private static Icon ICON = new GIcon("icon.projectdata.paste");

    public ProjectDataPasteAction(String owner, String group) {
        super("Paste", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Paste"}, ICON, group));
        this.setKeyBindingData(new KeyBindingData('V', DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Paste"));
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolder destFolder = DataTree.getRealInternalFolderForNode(node);
        if (destFolder != null) {
            this.paste(context.getTree(), destFolder);
        }
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (!context.isInActiveProject() || !context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolder destFolder = DataTree.getRealInternalFolderForNode(node);
        return ProjectDataPasteAction.checkNodeForPaste(destFolder);
    }

    @Override
    protected boolean isAddToPopup(FrontEndProjectTreeContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        return context.isInActiveProject();
    }

    static boolean checkNodeForPaste(DomainFolder destFolder) {
        if (destFolder == null || !destFolder.isInWritableProject()) {
            return false;
        }
        List<GTreeNode> list = DataTreeClipboardUtils.getDataTreeNodesFromClipboard();
        for (GTreeNode node : list) {
            DomainFileNode fileNode;
            if (node instanceof DomainFileNode && !(fileNode = (DomainFileNode)node).isFolderLink()) {
                return true;
            }
            DomainFolder folder = DataTree.getRealInternalFolderForNode(node);
            if (folder == null || folder.isSameOrAncestor(destFolder)) continue;
            return true;
        }
        return false;
    }

    private void paste(DataTree tree, DomainFolder destFolder) {
        List<GTreeNode> list = DataTreeClipboardUtils.getDataTreeNodesFromClipboard();
        boolean isCutOperation = this.isCutOperation(list);
        this.checkPasteList(tree, destFolder, list, isCutOperation);
        if (!list.isEmpty()) {
            PasteFileTask task = new PasteFileTask(destFolder, list, isCutOperation);
            new TaskLauncher((Task)task, (Component)((Object)tree), 1000);
        } else {
            tree.removeSelectionPath(null);
            tree.setSelectionPath(null);
        }
    }

    private void checkPasteList(DataTree tree, DomainFolder destFolder, List<GTreeNode> list, boolean isCutOperation) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.removeDescendantsFromList(list);
        StringBuilder msgBuffer = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            GTreeNode tnode = list.get(i);
            boolean removeNodeFromList = true;
            if (tnode instanceof DataTreeNode) {
                DataTreeNode dataTreeNode = (DataTreeNode)tnode;
                boolean bl = removeNodeFromList = !this.canCopyNode(dataTreeNode, destFolder, isCutOperation, msgBuffer);
            }
            if (!removeNodeFromList) continue;
            list.remove(i--);
            if (!(tnode instanceof Cuttable)) continue;
            Cuttable cuttable = (Cuttable)tnode;
            cuttable.setIsCut(false);
        }
        if (msgBuffer.length() > 0) {
            String title = isCutOperation ? "Cannot Move File(s)" : "Cannot Copy File(s)";
            String action = isCutOperation ? "moved" : "copied";
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)((Object)tree), (String)title, (Object)("The following content could not be " + action + ":\n" + msgBuffer.toString()));
        }
    }

    private void appendMsg(String msg, StringBuilder msgBuffer) {
        if (!msg.isEmpty()) {
            msgBuffer.append("\n");
        }
        msgBuffer.append(msg);
    }

    private boolean canCopyNode(DataTreeNode dataTreeNode, DomainFolder destFolder, boolean isCutOperation, StringBuilder msgBuffer) {
        try {
            String nodeType = dataTreeNode instanceof DomainFolderNode ? "Folder" : "File";
            DomainFolder folder = this.getRealFolder(dataTreeNode);
            if (isCutOperation) {
                DomainFolder checkFolder;
                if (!folder.isInWritableProject()) {
                    this.appendMsg("Read-only project. " + nodeType + " '" + dataTreeNode.getName() + "' cannot be moved", msgBuffer);
                    return false;
                }
                if (dataTreeNode.getParent() == null) {
                    return false;
                }
                DomainFolder domainFolder = checkFolder = dataTreeNode instanceof DomainFolderNode ? folder.getParent() : folder;
                if (destFolder.equals(checkFolder)) {
                    return false;
                }
            }
            if (dataTreeNode instanceof DomainFolderNode) {
                if (folder.isSameOrAncestor(destFolder)) {
                    this.appendMsg(nodeType + " '" + dataTreeNode.getName() + "' contains destination folder '" + destFolder.getName() + "'", msgBuffer);
                    return false;
                }
                if (destFolder.getFolder(folder.getName()) != null) {
                    this.appendMsg("Folder '" + destFolder.getName() + "' already contains a folder named '" + dataTreeNode.getName() + "'", msgBuffer);
                    return false;
                }
            }
        }
        catch (IOException e) {
            Msg.warn((Object)((Object)this), (Object)("Failed to resolve linked item: " + dataTreeNode.getName() + ": " + e.getMessage()));
            this.appendMsg("Failed to resolve linked item: " + dataTreeNode.getName(), msgBuffer);
            return false;
        }
        return true;
    }

    private DomainFolder getRealFolder(DataTreeNode dataTreeNode) throws IOException {
        DomainFolder folder = null;
        if (dataTreeNode instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)dataTreeNode;
            folder = fileNode.getDomainFile().getParent();
        } else if (dataTreeNode instanceof DomainFolderNode) {
            DomainFolderNode folderNode = (DomainFolderNode)dataTreeNode;
            folder = folderNode.getDomainFolder();
        }
        if (folder instanceof LinkedDomainFolder) {
            LinkedDomainFolder linkedFolder = (LinkedDomainFolder)folder;
            folder = linkedFolder.getRealFolder();
        }
        return folder;
    }

    private void removeDescendantsFromList(List<GTreeNode> list) {
        int i;
        ArrayList<GTreeNode> newList = new ArrayList<GTreeNode>();
        for (i = 0; i < list.size(); ++i) {
            GTreeNode destNode = list.get(i);
            for (int j = 0; j < list.size(); ++j) {
                GTreeNode node = list.get(j);
                if (destNode == node || !node.isAncestor(destNode)) continue;
                newList.add(node);
            }
        }
        for (i = 0; i < newList.size(); ++i) {
            list.remove(newList.get(i));
        }
    }

    private boolean isCutOperation(List<GTreeNode> list) {
        for (GTreeNode node : list) {
            if (!(node instanceof Cuttable) || !((Cuttable)node).isCut()) continue;
            return true;
        }
        return false;
    }
}

