/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.DockingUtils;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import generic.theme.GIcon;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyCutBaseAction;
import ghidra.framework.model.Project;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class ProjectDataCopyAction
extends ProjectDataCopyCutBaseAction {
    private static final Icon icon = new GIcon("icon.projectdata.copy");

    public ProjectDataCopyAction(String owner, String group) {
        super("Copy", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Copy"}, icon, group));
        this.setKeyBindingData(new KeyBindingData('C', DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Copy"));
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        TreePath[] paths = this.adjustSelectionPaths(context.getSelectionPaths());
        DataTreeClipboardUtils.setClipboardContents(context.getTree(), paths);
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        Project activeProject = AppInfo.getActiveProject();
        if (activeProject == null || !context.isInActiveProject()) {
            return true;
        }
        return !context.containsRootFolder();
    }
}

