/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.framework.Application;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.lang.Language;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.VersionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeListener;

public class FidFileManager {
    private static final String SEPARATOR = ";";
    private static final String INACTIVE_FID_FILES = "FID.INACTIVE";
    private static final String USER_ADDED_FILES = "FID.USER.ADDED";
    private static FidFileManager THE_FID_FILE_MANAGER;
    private Set<FidFile> fidFiles;
    private WeakSet<ChangeListener> listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();

    public static FidFileManager getInstance() {
        if (THE_FID_FILE_MANAGER == null) {
            THE_FID_FILE_MANAGER = new FidFileManager();
        }
        return THE_FID_FILE_MANAGER;
    }

    private FidFileManager() {
    }

    private Set<FidFile> loadFidFiles() {
        if (this.fidFiles == null) {
            this.findDeliveredFidFiles();
            this.restoreFromPreferences();
        }
        return this.fidFiles;
    }

    public FidFile addUserFidFile(File file) {
        this.loadFidFiles();
        FidFile fidFile = this.findExistingFidFile(file);
        if (fidFile != null) {
            return fidFile;
        }
        fidFile = new FidFile(this, file, false);
        if (fidFile.isValidFile()) {
            this.fidFiles.add(fidFile);
            this.saveToPreferences();
            this.notifyListeners();
            return fidFile;
        }
        return null;
    }

    private FidFile findExistingFidFile(File file) {
        this.loadFidFiles();
        for (FidFile fidFile : this.fidFiles) {
            if (!fidFile.getFile().equals(file)) continue;
            return fidFile;
        }
        return null;
    }

    public List<FidFile> getFidFiles() {
        this.loadFidFiles();
        ArrayList<FidFile> files = new ArrayList<FidFile>(this.fidFiles);
        Collections.sort(files);
        return files;
    }

    public boolean hasFidFiles() {
        this.loadFidFiles();
        return !this.fidFiles.isEmpty();
    }

    public boolean hasUserFidFiles() {
        this.loadFidFiles();
        for (FidFile fidFile : this.fidFiles) {
            if (fidFile.isInstalled()) continue;
            return true;
        }
        return false;
    }

    public List<FidFile> getUserAddedFiles() {
        this.loadFidFiles();
        ArrayList<FidFile> files = new ArrayList<FidFile>();
        for (FidFile fidFile : this.fidFiles) {
            if (fidFile.isInstalled()) continue;
            files.add(fidFile);
        }
        Collections.sort(files);
        return files;
    }

    public FidQueryService openFidQueryService(Language language, boolean openForUpdate) throws VersionException, IOException {
        this.loadFidFiles();
        return new FidQueryService(this.fidFiles, language, openForUpdate);
    }

    public void createNewFidDatabase(File dbFile) throws IOException {
        FidDB.createNewFidDatabase(dbFile);
        FidFile newFidFile = new FidFile(this, dbFile, false);
        this.loadFidFiles();
        this.fidFiles.add(newFidFile);
        this.saveToPreferences();
        this.notifyListeners();
    }

    public void removeUserFile(FidFile fidFile) {
        this.loadFidFiles();
        this.fidFiles.remove(fidFile);
        this.saveToPreferences();
        this.notifyListeners();
    }

    public boolean canQuery(Language language) {
        this.loadFidFiles();
        for (FidFile file : this.fidFiles) {
            if (!file.isActive() || !file.canProcessLanguage(language)) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void saveToPreferences() {
        List<FidFile> userAddedFiles = this.getUserAddedFiles();
        this.saveFilesToPreferences(USER_ADDED_FILES, userAddedFiles);
        List<FidFile> inactiveFiles = this.getInactiveFiles();
        this.saveFilesToPreferences(INACTIVE_FID_FILES, inactiveFiles);
    }

    private void saveFilesToPreferences(String preferenceName, List<FidFile> files) {
        StringBuilder builder = new StringBuilder();
        for (FidFile file : files) {
            if (builder.length() > 0) {
                builder.append(SEPARATOR);
            }
            Path path = new Path(file.getFile());
            builder.append(path.getPathAsString());
        }
        Preferences.setProperty((String)preferenceName, (String)builder.toString());
    }

    private List<FidFile> getInactiveFiles() {
        this.loadFidFiles();
        ArrayList<FidFile> list = new ArrayList<FidFile>();
        for (FidFile fidFile : this.fidFiles) {
            if (fidFile.isActive()) continue;
            list.add(fidFile);
        }
        return list;
    }

    private void restoreFromPreferences() {
        Set<File> userAddedFiles = this.getFilesFromPreference(USER_ADDED_FILES);
        this.addUserFidFiles(userAddedFiles);
        Set<File> excludedFiles = this.getFilesFromPreference(INACTIVE_FID_FILES);
        this.excludeFidFiles(excludedFiles);
    }

    private void addUserFidFiles(Set<File> userAddedFiles) {
        this.loadFidFiles();
        for (File file : userAddedFiles) {
            FidFile fidFile = new FidFile(this, file, false);
            if (!fidFile.isValidFile()) continue;
            this.fidFiles.add(fidFile);
        }
    }

    private void excludeFidFiles(Set<File> excludedFiles) {
        this.loadFidFiles();
        for (FidFile fidFile : this.fidFiles) {
            if (!excludedFiles.contains(fidFile.getFile())) continue;
            fidFile.setActive(false);
        }
    }

    private Set<File> getFilesFromPreference(String preferenceName) {
        String[] filePaths;
        HashSet<File> set = new HashSet<File>();
        String concatenatedFilePaths = Preferences.getProperty((String)preferenceName, (String)"", (boolean)true);
        for (String filePath : filePaths = concatenatedFilePaths.split(SEPARATOR)) {
            Path path;
            ResourceFile resourceFile;
            if ((filePath = filePath.trim()).length() == 0 || !(resourceFile = (path = new Path(filePath)).getPath()).exists()) continue;
            set.add(resourceFile.getFile(false));
        }
        return set;
    }

    private void findDeliveredFidFiles() {
        this.fidFiles = new CopyOnWriteArraySet<FidFile>();
        List foundFiles = Application.findFilesByExtensionInApplication((String)".fidbf");
        for (ResourceFile resourceFile : foundFiles) {
            File file = resourceFile.getFile(true);
            FidFile fidFile = new FidFile(this, file, true);
            if (!fidFile.isValidFile()) continue;
            this.fidFiles.add(fidFile);
        }
    }

    void activeStateChanged(FidFile fidFile) {
        this.saveFilesToPreferences(INACTIVE_FID_FILES, this.getInactiveFiles());
    }

    private void notifyListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(null);
        }
    }
}

