/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra;

import generic.jar.ResourceFile;
import ghidra.app.script.AbstractPythonScriptProvider;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.GhidraScriptProperties;
import ghidra.app.script.GhidraState;
import ghidra.app.util.headless.HeadlessScript;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.pyghidra.PythonFieldExposer;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ExtensionPointProperties;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.Consumer;

@ExtensionPointProperties(priority=1000)
public final class PyGhidraScriptProvider
extends AbstractPythonScriptProvider {
    private static Consumer<GhidraScript> scriptRunner = null;

    public static void setScriptRunner(Consumer<GhidraScript> scriptRunner) {
        if (PyGhidraScriptProvider.scriptRunner != null) {
            throw new AssertException("scriptRunner has already been set");
        }
        PyGhidraScriptProvider.scriptRunner = scriptRunner;
    }

    public String getDescription() {
        return "PyGhidra";
    }

    public String getRuntimeEnvironmentName() {
        return "PyGhidra";
    }

    public GhidraScript getScriptInstance(ResourceFile sourceFile, PrintWriter writer) throws GhidraScriptLoadException {
        if (scriptRunner == null) {
            String msg = "Ghidra was not started with PyGhidra. Python is not available";
            throw new GhidraScriptLoadException(msg);
        }
        PythonFieldExposer script = SystemUtilities.isInHeadlessMode() ? new PyGhidraHeadlessScript() : new PyGhidraGhidraScript();
        script.setSourceFile(sourceFile);
        return script;
    }

    @PythonFieldExposer.ExposedFields(exposer=ExposedField.class, names={"currentAddress", "currentLocation", "currentSelection", "currentHighlight", "currentProgram", "monitor", "potentialPropertiesFileLocs", "propertiesFileParams", "sourceFile", "state", "writer", "errorWriter"}, types={Address.class, ProgramLocation.class, ProgramSelection.class, ProgramSelection.class, Program.class, TaskMonitor.class, List.class, GhidraScriptProperties.class, ResourceFile.class, GhidraState.class, PrintWriter.class, PrintWriter.class})
    static final class PyGhidraHeadlessScript
    extends HeadlessScript
    implements PythonFieldExposer {
        PyGhidraHeadlessScript() {
        }

        public void run() {
            scriptRunner.accept((GhidraScript)this);
        }

        private static class ExposedField
        extends PythonFieldExposer.ExposedField {
            public ExposedField(String name, Class<?> type) {
                super(MethodHandles.lookup().in(PyGhidraHeadlessScript.class), name, type);
            }
        }
    }

    @PythonFieldExposer.ExposedFields(exposer=ExposedField.class, names={"currentAddress", "currentLocation", "currentSelection", "currentHighlight", "currentProgram", "monitor", "potentialPropertiesFileLocs", "propertiesFileParams", "sourceFile", "state", "writer", "errorWriter"}, types={Address.class, ProgramLocation.class, ProgramSelection.class, ProgramSelection.class, Program.class, TaskMonitor.class, List.class, GhidraScriptProperties.class, ResourceFile.class, GhidraState.class, PrintWriter.class, PrintWriter.class})
    static final class PyGhidraGhidraScript
    extends GhidraScript
    implements PythonFieldExposer {
        PyGhidraGhidraScript() {
        }

        public void run() {
            scriptRunner.accept(this);
        }

        private static class ExposedField
        extends PythonFieldExposer.ExposedField {
            public ExposedField(String name, Class<?> type) {
                super(MethodHandles.lookup().in(PyGhidraGhidraScript.class), name, type);
            }
        }
    }
}

