/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupVertexSerializer;
import ghidra.app.plugin.core.functiongraph.mvc.LazySaveableXML;
import ghidra.util.Msg;
import ghidra.util.ObjectStorage;
import ghidra.util.xml.GenericXMLOutputter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.jdom.Document;
import org.jdom.Element;

public class LazyGraphRegroupSaveableXML
extends LazySaveableXML {
    private FunctionGraph functionGraph;

    public LazyGraphRegroupSaveableXML(FunctionGraph functionGraph) {
        this.functionGraph = functionGraph;
    }

    @Override
    public boolean isEmpty() {
        Collection<GroupHistoryInfo> groupHistory = this.functionGraph.getGroupHistory();
        return groupHistory.isEmpty();
    }

    @Override
    public void save(ObjectStorage objStorage) {
        Element groupVertexElement = GroupVertexSerializer.getXMLForRegroupableVertices(this.functionGraph);
        Document document = new Document(groupVertexElement);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GenericXMLOutputter xmlOutputter = new GenericXMLOutputter();
        try {
            xmlOutputter.output(document, (OutputStream)outputStream);
        }
        catch (IOException ioe) {
            Msg.error(((Object)((Object)this)).getClass(), (Object)"Unable to save XML data.", (Throwable)ioe);
            return;
        }
        String xmlString = outputStream.toString();
        objStorage.putString(xmlString);
    }
}

