/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import docking.DockingUtils;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.layout.ObservableCachingLayout;
import edu.uci.ics.jung.visualization.picking.PickedState;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.JungPickingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public class VisualGraphPickingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends JungPickingGraphMousePlugin<V, E>
implements VisualGraphMousePlugin<V, E> {
    public VisualGraphPickingGraphMousePlugin() {
        super(1024, 0x400 | DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    }

    public boolean checkModifiers(MouseEvent e) {
        if (e.getModifiersEx() == this.addToSelectionModifiers) {
            return true;
        }
        return e.getModifiersEx() == this.modifiers;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.locked) {
            return;
        }
        GraphViewer viewer = this.getGraphViewer(e);
        if (this.vertex != null) {
            this.dragVertices(e, viewer);
        } else {
            this.increaseDragRectangle(e);
        }
        viewer.repaint();
    }

    private void increaseDragRectangle(MouseEvent e) {
        Point out = e.getPoint();
        int theModifiers = e.getModifiersEx();
        if ((theModifiers == this.addToSelectionModifiers || theModifiers == this.modifiers) && this.down != null) {
            this.rect.setFrameFromDiagonal(this.down, out);
        }
    }

    private void dragVertices(MouseEvent e, GraphViewer<V, E> viewer) {
        Point p = e.getPoint();
        RenderContext context = viewer.getRenderContext();
        MultiLayerTransformer xformer = context.getMultiLayerTransformer();
        Point2D layoutPoint = xformer.inverseTransform((Point2D)p);
        Point2D layoutDown = xformer.inverseTransform((Point2D)this.down);
        Layout layout = viewer.getGraphLayout();
        double dx = layoutPoint.getX() - layoutDown.getX();
        double dy = layoutPoint.getY() - layoutDown.getY();
        PickedState ps = viewer.getPickedVertexState();
        for (VisualVertex v : ps.getPicked()) {
            Point2D vertexPoint = (Point2D)layout.apply((Object)v);
            vertexPoint.setLocation(vertexPoint.getX() + dx, vertexPoint.getY() + dy);
            VisualGraphLayout<VisualVertex, E> vgLayout = this.getVisualGraphLayout(layout);
            if (vgLayout != null) {
                vgLayout.setLocation(v, vertexPoint, LayoutListener.ChangeType.USER);
            } else {
                layout.setLocation((Object)v, vertexPoint);
            }
            this.updatedArticulatedEdges(viewer, v);
        }
        this.down = p;
        e.consume();
    }

    private VisualGraphLayout<V, E> getVisualGraphLayout(Layout<V, E> layout) {
        if (layout instanceof VisualGraphLayout) {
            VisualGraphLayout vgLayout = (VisualGraphLayout)layout;
            return vgLayout;
        }
        if (layout instanceof ObservableCachingLayout) {
            ObservableCachingLayout observable = (ObservableCachingLayout)layout;
            return this.getVisualGraphLayout(observable.getDelegate());
        }
        return null;
    }

    private void updatedArticulatedEdges(GraphViewer<V, E> viewer, V v) {
        Layout layout = viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        Collection edges = graph.getIncidentEdges(v);
        VisualGraphViewUpdater updater = this.getViewUpdater(viewer);
        updater.updateEdgeShapes(edges);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isOverVertex(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    private boolean isOverVertex(MouseEvent e) {
        VisualizationViewer viewer = this.getViewer(e);
        return GraphViewerUtils.getVertexFromPointInViewSpace(viewer, e.getPoint()) != null;
    }

    private void installCursor(Cursor newCursor, MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        viewer.setCursor(newCursor);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isDragging() && this.vertex == null && this.edge == null) {
            this.maybeClearPickedState(e);
        }
        super.mouseReleased(e);
    }

    private boolean isDragging() {
        Rectangle2D frame = this.rect.getFrame();
        return frame.getHeight() > 0.0;
    }

    private void maybeClearPickedState(MouseEvent event) {
        Point mousePoint;
        Layout layout;
        VisualizationViewer vv = (VisualizationViewer)event.getSource();
        PickedState pickedVertexState = vv.getPickedVertexState();
        PickedState pickedEdgeState = vv.getPickedEdgeState();
        if (pickedEdgeState == null || pickedVertexState == null) {
            return;
        }
        GraphElementAccessor pickSupport = vv.getPickSupport();
        VisualVertex v = (VisualVertex)pickSupport.getVertex(layout = vv.getGraphLayout(), ((Point2D)(mousePoint = event.getPoint())).getX(), ((Point2D)mousePoint).getY());
        if (v != null) {
            return;
        }
        VisualEdge e = (VisualEdge)pickSupport.getEdge(layout, ((Point2D)mousePoint).getX(), ((Point2D)mousePoint).getY());
        if (e != null) {
            return;
        }
        pickedEdgeState.clear();
        pickedVertexState.clear();
    }
}

