/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import generic.util.WindowUtilities;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.PathHighlightMode;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.PathHighlightListener;
import ghidra.graph.viewer.edge.VisualGraphPathHighlighter;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.event.mouse.VertexTooltipProvider;
import ghidra.graph.viewer.event.mouse.VisualGraphPluggableGraphMouse;
import ghidra.graph.viewer.event.picking.GPickedState;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.options.VisualGraphOptions;
import ghidra.graph.viewer.popup.PopupRegulator;
import ghidra.graph.viewer.popup.PopupSource;
import ghidra.graph.viewer.popup.ToolTipInfo;
import ghidra.graph.viewer.renderer.VisualGraphRenderer;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class GraphViewer<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualizationViewer<V, E> {
    private GPickedState<V> gPickedState;
    private Consumer<GraphViewer<V, E>> initializedListener;
    private PopupRegulator<V, E> popupRegulator;
    private VertexTooltipProvider<V, E> vertexTooltipProvider = new DummyTooltipProvider(this);
    protected VisualGraphOptions vgOptions;
    private VisualGraphViewUpdater<V, E> viewUpdater;
    private VisualGraphPathHighlighter<V, E> pathHighlighter;

    public GraphViewer(VisualGraphLayout<V, E> layout, Dimension size) {
        super(layout, size);
        this.buildUpdater();
        this.setRenderer((Renderer)new VisualGraphRenderer<V, E>(layout.getEdgeLabelRenderer()));
        this.setGraphMouse(new VisualGraphPluggableGraphMouse());
        PickedState pickedState = this.getPickedVertexState();
        this.gPickedState = new GPickedState((MultiPickedState)pickedState);
        this.setPickedVertexState(this.gPickedState);
        this.popupRegulator = new PopupRegulator(new GraphViewerPopupSource());
    }

    private void buildUpdater() {
        this.viewUpdater = this.createViewUpdater();
        PathHighlightListener listener = hoverChange -> {
            if (hoverChange) {
                this.viewUpdater.animateEdgeHover();
            } else {
                this.repaint();
            }
        };
        this.pathHighlighter = this.createPathHighlighter(listener);
        this.viewUpdater.addJobScheduledListener(() -> this.pathHighlighter.stop());
        this.pathHighlighter.setWorkPauser(() -> this.viewUpdater.isMutatingGraph());
    }

    protected VisualGraphPathHighlighter<V, E> createPathHighlighter(PathHighlightListener listener) {
        return new VisualGraphPathHighlighter<V, E>(this.getVisualGraph(), listener);
    }

    protected VisualGraphViewUpdater<V, E> createViewUpdater() {
        return new VisualGraphViewUpdater<V, E>(this, this.getVisualGraph());
    }

    public VisualGraphLayout<V, E> getVisualGraphLayout() {
        return GraphViewerUtils.getVisualGraphLayout(this.getGraphLayout());
    }

    public void setGraphLayout(Layout<V, E> layout) {
        if (!(layout instanceof VisualGraphLayout)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " only supports layouts of type " + VisualGraphLayout.class.getSimpleName());
        }
        super.setGraphLayout(layout);
    }

    public VisualGraph<V, E> getVisualGraph() {
        VisualGraphLayout<V, E> l = this.getVisualGraphLayout();
        return l.getVisualGraph();
    }

    public VisualGraphPluggableGraphMouse<V, E> getGraphMouse() {
        return (VisualGraphPluggableGraphMouse)super.getGraphMouse();
    }

    public void setGraphMouse(VisualizationViewer.GraphMouse graphMouse) {
        if (!(graphMouse instanceof VisualGraphPluggableGraphMouse)) {
            throw new IllegalArgumentException("GraphViewer must use a VisualGraphPluggableGraphMouse");
        }
        super.setGraphMouse(graphMouse);
    }

    public void setGraphOptions(VisualGraphOptions options) {
        this.vgOptions = options;
        this.optionsChanged();
    }

    public void optionsChanged() {
        this.setBackground(this.vgOptions.getGraphBackgroundColor());
    }

    public VisualGraphOptions getOptions() {
        return this.vgOptions;
    }

    public void setVertexHoverPathHighlightMode(PathHighlightMode hoverMode) {
        this.pathHighlighter.setVertexHoverMode(hoverMode);
    }

    public void setVertexFocusPathHighlightMode(PathHighlightMode focusMode) {
        this.pathHighlighter.setVertexFocusMode(focusMode);
    }

    public PathHighlightMode getVertexHoverPathHighlightMode() {
        return this.pathHighlighter.getVertexHoverPathHighlightMode();
    }

    public PathHighlightMode getVertexFocusPathHighlightMode() {
        return this.pathHighlighter.getVertexFocusPathHighlightMode();
    }

    public void setViewerInitializedListener(Consumer<GraphViewer<V, E>> listener) {
        this.initializedListener = listener;
    }

    public VisualGraphPathHighlighter<V, E> getPathHighlighter() {
        return this.pathHighlighter;
    }

    public VisualGraphViewUpdater<V, E> getViewUpdater() {
        return this.viewUpdater;
    }

    public GPickedState<V> getGPickedVertexState() {
        PickedState ps = super.getPickedVertexState();
        if (!(ps instanceof GPickedState)) {
            throw new IllegalArgumentException("GPickedState was not installed or was overrwritten");
        }
        return (GPickedState)ps;
    }

    public void setVertexTooltipProvider(VertexTooltipProvider<V, E> vertexTooltipProvider) {
        if (vertexTooltipProvider == null) {
            vertexTooltipProvider = new DummyTooltipProvider(this);
        }
        this.vertexTooltipProvider = vertexTooltipProvider;
    }

    public boolean useMouseRelativeZoom() {
        return this.vgOptions.useMouseRelativeZoom();
    }

    public Component add(Component comp) {
        if (SwingUtilities.isDescendingFrom(comp, (Component)((Object)this))) {
            return comp;
        }
        return super.add(comp);
    }

    protected void paintComponent(Graphics g) {
        if (this.initializedListener != null) {
            this.initializedListener.accept(this);
            this.initializedListener = null;
        }
        super.paintComponent(g);
    }

    public Point2D getCenter() {
        Dimension d = this.getSize();
        Container myParent = this.getParent();
        if (myParent != null) {
            d = myParent.getSize();
        }
        return new Point2D.Float(d.width / 2, d.height / 2);
    }

    private boolean isScaledPastInteractionThreshold() {
        return GraphViewerUtils.isScaledPastVertexInteractionThreshold(this);
    }

    void setPopupDelay(int delayMs) {
        this.popupRegulator.setPopupDelay(delayMs);
    }

    public void setPopupsVisible(boolean visible) {
        this.popupRegulator.setPopupsVisible(visible);
    }

    boolean isPopupShowing() {
        return this.popupRegulator.isPopupShowing();
    }

    public String getToolTipText(MouseEvent event) {
        return null;
    }

    private ToolTipInfo<?> getToolTipInfo(MouseEvent event) {
        Layout viewerLayout = this.getGraphLayout();
        Point p = event.getPoint();
        VisualVertex vertex = (VisualVertex)this.getPickSupport().getVertex(viewerLayout, p.getX(), p.getY());
        if (vertex != null) {
            return new VertexToolTipInfo(this, vertex, event);
        }
        VisualEdge edge = (VisualEdge)this.getPickSupport().getEdge(viewerLayout, p.getX(), p.getY());
        if (edge != null) {
            return new EdgeToolTipInfo(this, edge, event);
        }
        return new VertexToolTipInfo(this, vertex, event);
    }

    public VertexMouseInfo<V, E> createVertexMouseInfo(MouseEvent e, V v, Point2D vertexBasedClickPoint) {
        return new VertexMouseInfo(e, v, vertexBasedClickPoint, this);
    }

    public void dispose() {
        this.viewUpdater.dispose();
        this.pathHighlighter.dispose();
        this.removeAll();
    }

    private GraphViewer<V, E> viewer() {
        return this;
    }

    private class DummyTooltipProvider
    implements VertexTooltipProvider<V, E> {
        private DummyTooltipProvider(GraphViewer graphViewer) {
        }

        @Override
        public JComponent getTooltip(V v) {
            return null;
        }

        @Override
        public String getTooltipText(V v, MouseEvent e) {
            return null;
        }

        @Override
        public JComponent getTooltip(V v, E e) {
            return null;
        }
    }

    private class GraphViewerPopupSource
    implements PopupSource<V, E> {
        private GraphViewerPopupSource() {
        }

        @Override
        public ToolTipInfo<?> getToolTipInfo(MouseEvent event) {
            return GraphViewer.this.viewer().getToolTipInfo(event);
        }

        @Override
        public V getVertex(MouseEvent event) {
            Layout viewerLayout = GraphViewer.this.getGraphLayout();
            Point p = event.getPoint();
            return (VisualVertex)GraphViewer.this.getPickSupport().getVertex(viewerLayout, p.getX(), p.getY());
        }

        @Override
        public E getEdge(MouseEvent event) {
            Layout viewerLayout = GraphViewer.this.getGraphLayout();
            Point p = event.getPoint();
            return (VisualEdge)GraphViewer.this.getPickSupport().getEdge(viewerLayout, p.getX(), p.getY());
        }

        @Override
        public void addMouseMotionListener(MouseMotionListener l) {
            GraphViewer.this.viewer().addMouseMotionListener(l);
        }

        @Override
        public void repaint() {
            GraphViewer.this.viewer().repaint();
        }

        @Override
        public Window getPopupParent() {
            return WindowUtilities.windowForComponent(GraphViewer.this.viewer());
        }
    }

    private static class VertexToolTipInfo
    extends ToolTipInfo<V> {
        final /* synthetic */ GraphViewer this$0;

        VertexToolTipInfo(V vertex, MouseEvent event) {
            this.this$0 = var1_1;
            super(event, vertex);
        }

        @Override
        public JComponent createToolTipComponent() {
            if (this.graphObject == null) {
                return null;
            }
            if (this.this$0.isScaledPastInteractionThreshold()) {
                return this.this$0.vertexTooltipProvider.getTooltip((VisualVertex)this.graphObject);
            }
            VertexMouseInfo mouseInfo = GraphViewerUtils.convertMouseEventToVertexMouseEvent(this.this$0, this.event);
            MouseEvent translatedMouseEvent = mouseInfo.getTranslatedMouseEvent();
            String toolTip = this.this$0.vertexTooltipProvider.getTooltipText((VisualVertex)this.graphObject, translatedMouseEvent);
            if (toolTip == null) {
                return null;
            }
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(toolTip);
            return jToolTip;
        }

        @Override
        protected void emphasize() {
            if (this.graphObject == null) {
                return;
            }
            if (GraphViewerUtils.isScaledPastVertexInteractionThreshold(this.this$0)) {
                ((VisualVertex)this.graphObject).setEmphasis(0.25);
            }
        }

        @Override
        public void deEmphasize() {
            if (this.graphObject == null) {
                return;
            }
            ((VisualVertex)this.graphObject).setEmphasis(0.0);
        }
    }

    private static class EdgeToolTipInfo
    extends ToolTipInfo<E> {
        final /* synthetic */ GraphViewer this$0;

        EdgeToolTipInfo(E edge, MouseEvent event) {
            this.this$0 = var1_1;
            super(event, edge);
        }

        @Override
        public JComponent createToolTipComponent() {
            if (this.graphObject == null) {
                return null;
            }
            VisualVertex start = (VisualVertex)((VisualEdge)this.graphObject).getStart();
            VisualVertex end = (VisualVertex)((VisualEdge)this.graphObject).getEnd();
            JComponent startComponent = this.this$0.vertexTooltipProvider.getTooltip(start, (VisualEdge)this.graphObject);
            if (startComponent == null) {
                return null;
            }
            if (start == end) {
                JPanel component = new JPanel(new BorderLayout());
                component.add((Component)startComponent, "Center");
                return component;
            }
            JComponent endComponent = this.this$0.vertexTooltipProvider.getTooltip(end, (VisualEdge)this.graphObject);
            if (endComponent == null) {
                return null;
            }
            JPanel component = new JPanel((LayoutManager)new PairLayout());
            component.add(startComponent);
            component.add(endComponent);
            return component;
        }

        @Override
        protected void emphasize() {
            if (this.graphObject == null) {
                return;
            }
            ((VisualEdge)this.graphObject).setEmphasis(1.0);
        }

        @Override
        public void deEmphasize() {
            if (this.graphObject == null) {
                return;
            }
            ((VisualEdge)this.graphObject).setEmphasis(0.0);
        }
    }
}

