/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel.model.row;

import datagraph.data.graph.panel.model.row.ComponentDataRowObject;
import datagraph.data.graph.panel.model.row.DataRowObject;
import datagraph.data.graph.panel.model.row.DataRowObjectCache;
import datagraph.data.graph.panel.model.row.OpenDataChildren;
import docking.widgets.trable.AbstractGTrableRowModel;
import ghidra.program.model.listing.Data;

public class DataTrableRowModel
extends AbstractGTrableRowModel<DataRowObject> {
    private Data data;
    private OpenDataChildren openChildren;
    private DataRowObjectCache cache = new DataRowObjectCache();

    public DataTrableRowModel(Data data) {
        this.data = data;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
        this.cache.clear();
        this.openChildren = null;
    }

    public int getRowCount() {
        if (this.openChildren == null) {
            return 1;
        }
        return this.openChildren.getRowCount() + 1;
    }

    public DataRowObject getRow(int rowIndex) {
        if (this.cache.contains(rowIndex)) {
            return this.cache.getDataRow(rowIndex);
        }
        DataRowObject row = this.generateRow(rowIndex);
        this.cache.putData(rowIndex, row);
        return row;
    }

    private DataRowObject generateRow(int rowIndex) {
        if (rowIndex == 0) {
            return new ComponentDataRowObject(0, this.data, this.openChildren != null);
        }
        return this.openChildren.getRow(rowIndex - 1);
    }

    public boolean isExpandable(int rowIndex) {
        DataRowObject dataRow = this.getRow(rowIndex);
        return dataRow != null && dataRow.isExpandable();
    }

    public boolean isExpanded(int rowIndex) {
        DataRowObject row = this.getRow(rowIndex);
        return row != null && row.isExpanded();
    }

    public int collapseRow(int rowIndex) {
        this.cache.clear();
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowIndex == 0) {
            if (this.openChildren == null) {
                return 0;
            }
            int diff = this.openChildren.getRowCount();
            this.openChildren = null;
            this.fireModelChanged();
            return diff;
        }
        int rowCountDiff = this.openChildren.collapseChild(rowIndex - 1);
        this.fireModelChanged();
        return rowCountDiff;
    }

    public int expandRow(int rowIndex) {
        this.cache.clear();
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowIndex == 0) {
            if (this.openChildren != null) {
                return 0;
            }
            this.openChildren = OpenDataChildren.createOpenDataNode(this.data, 0, 0, 1);
            this.fireModelChanged();
            return this.openChildren.getRowCount();
        }
        int diff = this.openChildren.expandChild(rowIndex - 1);
        this.fireModelChanged();
        return diff;
    }

    public int getIndentLevel(int rowIndex) {
        DataRowObject row = this.getRow(rowIndex);
        return row.getIndentLevel();
    }

    public void refresh() {
        this.cache.clear();
        if (this.openChildren != null && !this.openChildren.refresh(this.data)) {
            this.openChildren = null;
        }
        this.fireModelChanged();
    }
}

