/*
 * Decompiled with CFR 0.152.
 */
package datagraph;

import datagraph.DataGraphPlugin;
import datagraph.DegContext;
import datagraph.DegSatelliteContext;
import datagraph.DegSharedConfig;
import datagraph.data.graph.DataDegVertex;
import datagraph.data.graph.DataExplorationGraph;
import datagraph.data.graph.DegController;
import datagraph.data.graph.DegEdge;
import datagraph.data.graph.DegVertex;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import generic.theme.GIcon;
import ghidra.app.nav.Navigatable;
import ghidra.graph.VisualGraphComponentProvider;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import resources.Icons;

public class DataGraphProvider
extends VisualGraphComponentProvider<DegVertex, DegEdge, DataExplorationGraph> {
    private static final GIcon DETAILS_ICON = new GIcon("icon.plugin.datagraph.action.viewer.vertex.format");
    private static final GIcon RESET_ICON = new GIcon("icon.plugin.datagraph.action.viewer.reset");
    private static final String NAME = "Data Graph";
    private DataGraphPlugin plugin;
    private JPanel mainPanel;
    private DegController controller;
    private ToggleDockingAction navagateInAction;
    private ToggleDockingAction navagateOutAction;
    private ToggleDockingAction expandedFormatAction;
    private Navigatable navigatable;
    private ToggleDockingAction togglePopups;

    public DataGraphProvider(DataGraphPlugin plugin, Navigatable navigatable, Data data, DegSharedConfig sharedConfig) {
        super((Tool)plugin.getTool(), NAME, plugin.getName());
        this.plugin = plugin;
        this.navigatable = navigatable;
        this.controller = new DegController(this, data, sharedConfig);
        this.createActions(sharedConfig);
        this.setTransient();
        this.buildComponent();
        this.addToTool();
        this.addSatelliteFeature(false, GraphComponent.SatellitePosition.LOWER_LEFT);
        this.setHelpLocation(new HelpLocation("DataGraphPlugin", "DataGraphPlugin"));
        this.updateSubTitle();
    }

    public void updateSubTitle() {
        Program program = this.controller.getProgram();
        DataExplorationGraph graph = this.controller.getGraph();
        Address address = ((DegVertex)graph.getRoot()).getAddress();
        this.setSubTitle(program.getName() + " @ " + String.valueOf(address));
    }

    private void buildComponent() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.controller.getComponent());
    }

    public VisualGraphView<DegVertex, DegEdge, DataExplorationGraph> getView() {
        return this.controller.getView();
    }

    public ActionContext getActionContext(MouseEvent event) {
        Set selectedVertices = this.getSelectedVertices();
        if (event == null) {
            return new DegContext(this, this.controller.getFocusedVertex(), selectedVertices);
        }
        Object source = event.getSource();
        if (source instanceof SatelliteGraphViewer) {
            return new DegSatelliteContext(this);
        }
        if (source instanceof GraphViewer) {
            GraphViewer viewer = (GraphViewer)source;
            VertexMouseInfo vertexMouseInfo = GraphViewerUtils.convertMouseEventToVertexMouseEvent((GraphViewer)viewer, (MouseEvent)event);
            DegVertex target = vertexMouseInfo != null ? (DegVertex)vertexMouseInfo.getVertex() : null;
            return new DegContext(this, target, selectedVertices, (VertexMouseInfo<DegVertex, DegEdge>)vertexMouseInfo);
        }
        throw new AssertException("Received mouse event from unexpected source in getActionContext(): " + String.valueOf(source));
    }

    public void dispose() {
        this.plugin.removeProvider(this);
        this.controller.dispose();
        super.dispose();
        this.removeFromTool();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void closeComponent() {
        super.closeComponent();
        this.dispose();
    }

    public Program getProgram() {
        return this.controller.getProgram();
    }

    public DegController getController() {
        return this.controller;
    }

    private void createActions(DegSharedConfig sharedConfig) {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Home Vertex", this.plugin.getName()).toolBarIcon(Icons.HOME_ICON)).toolBarGroup("A")).description("Selects and Centers Original Source Vertx")).onAction(c -> this.controller.selectAndCenterHomeVertex())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Relayout Graph", this.plugin.getName()).toolBarIcon((Icon)RESET_ICON)).toolBarGroup("A")).description("Erases all manual vertex positioning information")).onAction(c -> this.controller.resetAndRelayoutGraph())).buildAndInstallLocal((ComponentProvider)this);
        this.expandedFormatAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Expanded Format", this.plugin.getName()).toolBarIcon((Icon)DETAILS_ICON)).toolBarGroup("A")).description("Show Expanded information in data vertices.")).selected(!sharedConfig.useCompactFormat()).helpLocation(new HelpLocation("DataGraphPlugin", "Expanded_Format"))).onAction(c -> this.controller.setCompactFormat(!this.expandedFormatAction.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.navagateInAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Navigate on Incoming Location Changes", this.plugin.getName()).sharedKeyBinding()).toolBarIcon(Icons.NAVIGATE_ON_INCOMING_EVENT_ICON)).toolBarGroup("B")).description("Attemps to select vertex corresponding to tool location changes.")).selected(sharedConfig.isNavigateIn()).helpLocation(new HelpLocation("DataGraphPlugin", "Navigate_In"))).onAction(c -> this.controller.setNavigateIn(this.navagateInAction.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.navagateOutAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Selection Navigation Action", this.plugin.getName()).toolBarIcon(Icons.NAVIGATE_ON_OUTGOING_EVENT_ICON)).toolBarGroup("B")).sharedKeyBinding()).description("Selecting vetices or locations inside a vertex sends navigates the tool.")).selected(sharedConfig.isNavigateOut()).helpLocation(new HelpLocation("DataGraphPlugin", "Navigate_Out"))).onAction(c -> this.controller.setNavigateOut(this.navagateOutAction.isSelected()))).selected(true).buildAndInstallLocal((ComponentProvider)this);
        this.togglePopups = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Display Popup Windows", this.plugin.getName()).popupMenuPath(new String[]{"Display Popup Windows"})).description("Toggles whether or not to show tooltips")).selected(sharedConfig.isShowPopups()).helpLocation(new HelpLocation("DataGraphPlugin", "Show_Popups"))).withContext(DegContext.class).popupWhen(c -> c.getVertex() == null).onAction(c -> this.controller.setPopupsVisible(this.togglePopups.isSelected())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Incoming References", this.plugin.getName()).popupMenuPath(new String[]{"Add All Incoming References"})).popupMenuGroup("A", "2")).description("Show Vertices for known references to this vertex.")).helpLocation(new HelpLocation("DataGraphPlugin", "Add Incoming"))).withContext(DegContext.class).enabledWhen(c -> this.canShowReferences((DegVertex)c.getVertex())).onAction(c -> this.controller.showAllIncommingReferences((DataDegVertex)c.getVertex())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Outgoing References", this.plugin.getName()).popupMenuPath(new String[]{"Add All Outgoing References"})).popupMenuGroup("A", "1")).description("Show Vertices for known references to this vertex.")).helpLocation(new HelpLocation("DataGraphPlugin", "Add Outgoing"))).withContext(DegContext.class).enabledWhen(c -> this.canShowReferences((DegVertex)c.getVertex())).onAction(c -> this.controller.showAllOutgoingReferences((DataDegVertex)c.getVertex())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Delete Vertices", this.plugin.getName()).popupMenuPath(new String[]{"Delete Selected Vertices"})).popupMenuGroup("B", "1")).description("Removes the selected vertices and their descendents from the graph")).helpLocation(new HelpLocation("DataGraphPlugin", "Delete_Selected"))).withContext(DegContext.class).enabledWhen(c -> this.canClose(c.getSelectedVertices())).onAction(c -> this.controller.deleteVertices(c.getSelectedVertices())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Set Original Vertex", this.plugin.getName()).popupMenuPath(new String[]{"Set Vertex as Original Source"})).popupMenuGroup("B", "2")).description("Reorient graph as though this was the first vertex shown")).helpLocation(new HelpLocation("DataGraphPlugin", "Original_Source"))).withContext(DegContext.class).enabledWhen(c -> this.canOrientGraphAround((DegVertex)c.getVertex())).onAction(c -> this.controller.orientAround((DegVertex)c.getVertex())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Reset Vertex Location", this.plugin.getName()).popupMenuPath(new String[]{"Restore Location"})).popupMenuGroup("B", "3")).popupMenuIcon(Icons.REFRESH_ICON)).description("Resets the vertex to the automated layout location.")).helpLocation(new HelpLocation("DataGraphPlugin", "Reset_Location"))).withContext(DegContext.class).enabledWhen(c -> c.getVertex() != null && ((DegVertex)c.getVertex()).hasUserChangedLocation()).onAction(c -> ((DegVertex)c.getVertex()).clearUserChangedLocation()).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Expand Fully", this.plugin.getName()).popupMenuPath(new String[]{"Expand Fully"})).popupMenuGroup("C", "1")).description("Expand all levels under selected row")).helpLocation(new HelpLocation("DataGraphPlugin", "Expand_Fully"))).withContext(DegContext.class).enabledWhen(this::canExpandRecursively).onAction(this::expandRecursively).buildAndInstallLocal((ComponentProvider)this);
    }

    private boolean canOrientGraphAround(DegVertex vertex) {
        if (vertex instanceof DataDegVertex) {
            return !vertex.isRoot();
        }
        return false;
    }

    private boolean canShowReferences(DegVertex vertex) {
        return vertex instanceof DataDegVertex;
    }

    private boolean canClose(Set<DegVertex> selectedVertices) {
        if (selectedVertices.isEmpty()) {
            return false;
        }
        if (selectedVertices.size() > 1) {
            return true;
        }
        DegVertex v = selectedVertices.iterator().next();
        return !v.isRoot();
    }

    void setLocation(ProgramLocation location) {
        this.controller.setLocation(location);
    }

    private boolean canExpandRecursively(DegContext context) {
        DegVertex vertex = (DegVertex)context.getVertex();
        if (vertex instanceof DataDegVertex) {
            DataDegVertex dataVertex = (DataDegVertex)vertex;
            return dataVertex.isOnExpandableRow();
        }
        return false;
    }

    private void expandRecursively(DegContext context) {
        DataDegVertex vertex = (DataDegVertex)context.getVertex();
        vertex.expandSelectedRowRecursively();
    }

    public void navigateOut(ProgramLocation location) {
        this.navigatable.goTo(location);
    }
}

