/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph;

import functioncalls.graph.FcgDirection;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.FcgVertexExpansionListener;
import functioncalls.plugin.FcgOptions;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.base.graph.CircleWithLabelVertexShapeProvider;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.util.Objects;
import javax.swing.Icon;
import resources.Icons;

public class FcgVertexShapeProvider
extends CircleWithLabelVertexShapeProvider {
    private static final Color TOO_BIG_VERTEX_SHAPE_COLOR = new GColor("color.bg.plugin.fcg.vertex.toobig");
    public static final Icon NOT_ALLOWED_ICON = Icons.ERROR_ICON;
    private FcgVertex vertex;
    private Paint inPaint;
    private Paint outPaint;
    private boolean hasIncomingReferences;
    private boolean hasOutgoingReferences;
    private boolean tooManyIncomingReferences;
    private boolean tooManyOutgoingReferences;

    public FcgVertexShapeProvider(FcgVertex vertex, FcgVertexExpansionListener expansionListener) {
        super(vertex.getName());
        this.vertex = vertex;
        Objects.requireNonNull(expansionListener);
        this.toggleInsButton.addActionListener(e -> {
            if (this.tooManyIncomingReferences) {
                return;
            }
            expansionListener.toggleIncomingVertices(vertex);
        });
        this.toggleOutsButton.addActionListener(e -> {
            if (this.tooManyOutgoingReferences) {
                return;
            }
            expansionListener.toggleOutgoingVertices(vertex);
        });
        this.buildUi();
        this.setTogglesVisible(false);
    }

    private void createPaints() {
        Color vertexShapeColor;
        Color lightColor = vertexShapeColor = this.getDefaultVertexShapeColor();
        Color darkColor = Gui.darker((Color)vertexShapeColor);
        Color darkestColor = Gui.darker((Color)darkColor);
        FcgLevel level = this.vertex.getLevel();
        int offset = 5 * level.getDistance();
        int half = 25;
        int start = 0;
        int end = half + offset;
        this.inPaint = new LinearGradientPaint(new Point(0, start), new Point(0, end), new float[]{0.0f, 0.2f, 1.0f}, new Color[]{darkestColor, darkColor, lightColor});
        start = half - offset;
        end = 50;
        this.outPaint = new LinearGradientPaint(new Point(0, start), new Point(0, end), new float[]{0.0f, 0.8f, 1.0f}, new Color[]{lightColor, darkColor, darkestColor});
    }

    protected void buildUi() {
        if (this.vertex == null) {
            return;
        }
        this.createPaints();
        super.buildUi();
    }

    protected String generateLabelText() {
        FcgOptions options = this.vertex.getOptions();
        boolean optionsUseTruncatedName = options.useTruncatedFunctionNames();
        String name = this.getName();
        if (optionsUseTruncatedName) {
            name = StringUtilities.trimMiddle((String)this.getName(), (int)30);
        }
        return name;
    }

    protected Paint getVertexShapePaint() {
        FcgLevel level = this.vertex.getLevel();
        FcgDirection direction = level.getDirection();
        if (direction.isSource()) {
            return this.getDefaultVertexShapeColor();
        }
        if (direction.isIn()) {
            return this.inPaint;
        }
        return this.outPaint;
    }

    protected Color getDefaultVertexShapeColor() {
        if (this.isInDirection() && this.tooManyIncomingReferences) {
            return TOO_BIG_VERTEX_SHAPE_COLOR;
        }
        if (this.isOutDirection() && this.tooManyOutgoingReferences) {
            return TOO_BIG_VERTEX_SHAPE_COLOR;
        }
        return DEFAULT_VERTEX_SHAPE_COLOR;
    }

    private boolean isInDirection() {
        FcgLevel level = this.vertex.getLevel();
        FcgDirection direction = level.getDirection();
        boolean isIn = direction.isIn() || direction.isSource();
        return isIn;
    }

    private boolean isOutDirection() {
        FcgLevel level = this.vertex.getLevel();
        FcgDirection direction = level.getDirection();
        boolean isOut = direction.isOut() || direction.isSource();
        return isOut;
    }

    public void setIncomingExpanded(boolean setExpanded) {
        this.validateIncomingExpandedState(setExpanded);
        super.setIncomingExpanded(setExpanded);
    }

    private void validateOutgoingExpandedState(boolean isExpanding) {
        if (isExpanding) {
            if (!this.canExpandOutgoingReferences()) {
                throw new IllegalStateException("Vertex cannot be expanded: " + String.valueOf((Object)this));
            }
            return;
        }
        if (!this.isOutgoingExpanded()) {
            throw new IllegalStateException("Vertex cannot be collapsed: " + String.valueOf((Object)this));
        }
    }

    private void validateIncomingExpandedState(boolean expanding) {
        if (expanding) {
            if (!this.canExpandIncomingReferences()) {
                throw new IllegalStateException("Vertex cannot be expanded: " + String.valueOf((Object)this));
            }
            return;
        }
        if (!this.isIncomingExpanded()) {
            throw new IllegalStateException("Vertex cannot be collapsed: " + String.valueOf((Object)this));
        }
    }

    public void setOutgoingExpanded(boolean setExpanded) {
        this.validateOutgoingExpandedState(setExpanded);
        super.setOutgoingExpanded(setExpanded);
    }

    public boolean isExpanded() {
        FcgLevel level = this.vertex.getLevel();
        FcgDirection direction = level.getDirection();
        if (direction.isSource()) {
            return this.isIncomingExpanded() && this.isOutgoingExpanded();
        }
        if (direction.isIn()) {
            return this.isIncomingExpanded();
        }
        return this.isOutgoingExpanded();
    }

    public void setTooManyIncomingReferences(boolean tooMany) {
        this.tooManyIncomingReferences = tooMany;
        this.toggleInsButton.setIcon(NOT_ALLOWED_ICON);
        this.toggleInsButton.setToolTipText("Too many incoming references to show");
        this.buildUi();
    }

    public void setTooManyOutgoingReferences(boolean tooMany) {
        this.tooManyOutgoingReferences = tooMany;
        this.toggleOutsButton.setIcon(NOT_ALLOWED_ICON);
        this.toggleOutsButton.setToolTipText("Too many outgoing references to show");
        this.buildUi();
    }

    public boolean hasTooManyIncomingReferences() {
        return this.tooManyIncomingReferences;
    }

    public boolean hasTooManyOutgoingReferences() {
        return this.tooManyOutgoingReferences;
    }

    public boolean canExpand() {
        FcgLevel level = this.vertex.getLevel();
        FcgDirection direction = level.getDirection();
        if (direction.isSource()) {
            return this.canExpandIncomingReferences() || this.canExpandOutgoingReferences();
        }
        if (direction.isIn()) {
            return this.canExpandIncomingReferences();
        }
        return this.canExpandOutgoingReferences();
    }

    public boolean canExpandIncomingReferences() {
        return this.hasIncomingReferences && !this.tooManyIncomingReferences && !this.incomingExpanded;
    }

    public boolean canExpandOutgoingReferences() {
        return this.hasOutgoingReferences && !this.tooManyOutgoingReferences && !this.outgoingExpanded;
    }

    public void setHasIncomingReferences(boolean hasIncoming) {
        this.hasIncomingReferences = hasIncoming;
    }

    public void setHasOutgoingReferences(boolean hasOutgoing) {
        this.hasOutgoingReferences = hasOutgoing;
    }

    public void setTogglesVisible(boolean visible) {
        boolean isIn = this.isInDirection();
        boolean turnOn = isIn && this.hasIncomingReferences && visible;
        this.toggleInsButton.setVisible(turnOn);
        boolean isOut = this.isOutDirection();
        turnOn = isOut && this.hasOutgoingReferences && visible;
        this.toggleOutsButton.setVisible(turnOn);
    }
}

