/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import docking.DialogComponentProvider;
import ghidra.async.AsyncUtils;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class BackgroundUtils
extends Enum<BackgroundUtils> {
    private static final /* synthetic */ BackgroundUtils[] $VALUES;

    public static BackgroundUtils[] values() {
        return (BackgroundUtils[])$VALUES.clone();
    }

    public static BackgroundUtils valueOf(String name) {
        return Enum.valueOf(BackgroundUtils.class, name);
    }

    public static <T extends DomainObject> AsyncBackgroundCommand<T> async(PluginTool tool, T obj, String name, boolean hasProgress, boolean canCancel, boolean isModal, BiFunction<T, TaskMonitor, CompletableFuture<?>> futureProducer) {
        AsyncBackgroundCommand<T> cmd = new AsyncBackgroundCommand<T>(name, hasProgress, canCancel, isModal, futureProducer);
        tool.executeBackgroundCommand(cmd, obj);
        return cmd;
    }

    public static <T> CompletableFuture<T> asyncModal(PluginTool tool, final String name, boolean hasProgress, boolean canCancel, final Function<TaskMonitor, CompletableFuture<T>> futureProducer) {
        var dialog = new TaskDialog(name, canCancel, true, hasProgress){
            CancelledListener cancelledListener;
            CompletableFuture<T> orig;
            CompletableFuture<T> future;
            {
                super(arg0, arg1, arg2, arg3);
                this.cancelledListener = this::cancelled;
                this.orig = (CompletableFuture)futureProducer.apply(this);
                this.future = ((CompletableFuture)this.orig.exceptionally(ex -> {
                    if (AsyncUtils.unwrapThrowable((Throwable)ex) instanceof CancellationException) {
                        return null;
                    }
                    Msg.showError((Object)((Object)this), null, (String)name, (Object)"Error running asynchronous background task", (Throwable)ex);
                    return null;
                })).thenApply(v -> {
                    Swing.runIfSwingOrRunLater(() -> this.close());
                    return v;
                });
                this.addCancelledListener(this.cancelledListener);
            }

            private void cancelled() {
                this.future.cancel(true);
                this.close();
            }
        };
        if (!dialog.orig.isDone()) {
            tool.showDialog((DialogComponentProvider)dialog);
        }
        return dialog.future;
    }

    private static /* synthetic */ BackgroundUtils[] $values() {
        return new BackgroundUtils[0];
    }

    static {
        $VALUES = BackgroundUtils.$values();
    }

    public static class AsyncBackgroundCommand<T extends DomainObject>
    extends BackgroundCommand<T> {
        private CompletableFuture<?> promise;
        private final CancelledListener cancelledListener = this::cancelled;
        private final BiFunction<T, TaskMonitor, CompletableFuture<?>> futureProducer;

        private AsyncBackgroundCommand(String name, boolean hasProgress, boolean canCancel, boolean isModal, BiFunction<T, TaskMonitor, CompletableFuture<?>> futureProducer) {
            super(name, hasProgress, canCancel, isModal);
            this.futureProducer = futureProducer;
        }

        private void cancelled() {
            this.promise.cancel(true);
        }

        public boolean applyTo(T obj, TaskMonitor monitor) {
            this.promise = this.futureProducer.apply(obj, monitor);
            monitor.addCancelledListener(this.cancelledListener);
            try {
                this.promise.get();
                return true;
            }
            catch (InterruptedException e) {
                this.setStatusMsg("Interrupted");
                return false;
            }
            catch (ExecutionException e) {
                this.setStatusMsg(e.getMessage());
                if (!(e.getCause() instanceof CancellationException)) {
                    return (Boolean)ExceptionUtils.rethrow((Throwable)e.getCause());
                }
                return false;
            }
            catch (CancellationException e) {
                this.setStatusMsg("Cancelled");
                return false;
            }
        }
    }

    public static class PluginToolExecutorService
    extends AbstractExecutorService {
        private final PluginTool tool;
        private final String name;
        private final DomainObject obj;
        private final int delay;
        private final EnumSet<TaskOpt> opts;
        private TaskMonitor lastMonitor;

        public PluginToolExecutorService(PluginTool tool, String name, DomainObject obj, int delay, TaskOpt ... opts) {
            this.tool = tool;
            this.name = name;
            this.obj = obj;
            this.opts = EnumSet.copyOf(Arrays.asList(opts));
            this.delay = delay;
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            if (this.opts.contains((Object)TaskOpt.IS_BACKGROUND)) {
                this.executeBackground(command);
            } else {
                this.executeForeground(command);
            }
        }

        protected void executeForeground(final Runnable command) {
            Task task = new Task(this.name, this.opts.contains((Object)TaskOpt.CAN_CANCEL), this.opts.contains((Object)TaskOpt.HAS_PROGRESS), this.opts.contains((Object)TaskOpt.IS_MODAL)){

                public void run(TaskMonitor monitor) throws CancelledException {
                    lastMonitor = monitor;
                    command.run();
                }
            };
            this.tool.execute(task, this.delay);
        }

        protected void executeBackground(final Runnable command) {
            BackgroundCommand<DomainObject> cmd = new BackgroundCommand<DomainObject>(this.name, this.opts.contains((Object)TaskOpt.HAS_PROGRESS), this.opts.contains((Object)TaskOpt.CAN_CANCEL), this.opts.contains((Object)TaskOpt.IS_MODAL)){

                public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
                    lastMonitor = monitor;
                    command.run();
                    return true;
                }
            };
            this.tool.executeBackgroundCommand((BackgroundCommand)cmd, this.obj);
        }

        public TaskMonitor getLastMonitor() {
            return this.lastMonitor;
        }

        public static enum TaskOpt {
            CAN_CANCEL,
            HAS_PROGRESS,
            IS_MODAL,
            IS_BACKGROUND;

        }
    }
}

