/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.program.model.lang.Endian;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceEnvironment;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface DebuggerPlatformOpinion
extends ExtensionPoint {
    public static final Comparator<DebuggerPlatformOffer> HIGHEST_CONFIDENCE_FIRST = Comparator.comparing(o -> -o.getConfidence());

    public static TraceObject getEnvironment(TraceObject object, long snap) {
        if (object == null) {
            return null;
        }
        TraceObject root = object.getRoot();
        KeyPath pathToEnv = root.getSchema().searchForSuitable(TraceEnvironment.class, object.getCanonicalPath());
        if (pathToEnv == null) {
            return null;
        }
        return root.getSuccessors(Lifespan.at((long)snap), PathFilter.pattern((KeyPath)pathToEnv)).findAny().map(p -> p.getDestination(root)).orElse(null);
    }

    public static String getStringAttribute(TraceObject obj, long snap, String key) {
        TraceObjectValue val = obj.getValue(snap, key);
        if (val == null) {
            return null;
        }
        return val.getValue().toString();
    }

    public static String getDebugggerFromEnv(TraceObject env, long snap) {
        return DebuggerPlatformOpinion.getStringAttribute(env, snap, "_debugger");
    }

    public static String getArchitectureFromEnv(TraceObject env, long snap) {
        return DebuggerPlatformOpinion.getStringAttribute(env, snap, "_arch");
    }

    public static String getOperatingSystemFromEnv(TraceObject env, long snap) {
        return DebuggerPlatformOpinion.getStringAttribute(env, snap, "_os");
    }

    public static Endian getEndianFromEnv(TraceObject env, long snap) {
        String strEndian = DebuggerPlatformOpinion.getStringAttribute(env, snap, "_endian");
        if (strEndian == null) {
            return null;
        }
        if (strEndian.toLowerCase().contains("little")) {
            return Endian.LITTLE;
        }
        if (strEndian.toLowerCase().contains("big")) {
            return Endian.BIG;
        }
        return null;
    }

    public static List<DebuggerPlatformOffer> queryOpinions(Trace trace, TraceObject object, long snap, boolean includeOverrides) {
        ArrayList<DebuggerPlatformOffer> result = new ArrayList<DebuggerPlatformOffer>();
        for (DebuggerPlatformOpinion opinion : ClassSearcher.getInstances(DebuggerPlatformOpinion.class)) {
            try {
                Set<DebuggerPlatformOffer> offers = opinion.getOffers(trace, object, snap, includeOverrides);
                result.addAll(offers);
            }
            catch (Exception e) {
                Msg.error(DebuggerPlatformOpinion.class, (Object)("Problem querying opinion " + String.valueOf(opinion) + " for platform offers: " + String.valueOf(e)));
            }
        }
        result.sort(HIGHEST_CONFIDENCE_FIRST);
        return result;
    }

    public Set<DebuggerPlatformOffer> getOffers(Trace var1, TraceObject var2, long var3, boolean var5);
}

