/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.action.LocationTracker;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import javax.swing.Icon;

public enum NoneLocationTrackingSpec implements LocationTrackingSpec,
LocationTracker
{
    INSTANCE;

    public static final String CONFIG_NAME = "TRACK_NONE";

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public String getMenuName() {
        return "Do Not Track";
    }

    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_NONE;
    }

    public String computeTitle(DebuggerCoordinates coordinates) {
        return null;
    }

    public String getLocationLabel() {
        return null;
    }

    public LocationTracker getTracker() {
        return this;
    }

    public Address computeTraceAddress(ServiceProvider provider, DebuggerCoordinates coordinates) {
        return null;
    }

    public GoToInput getDefaultGoToInput(ServiceProvider provider, DebuggerCoordinates coordinates, ProgramLocation location) {
        if (location == null) {
            return GoToInput.fromString((String)"00000000");
        }
        return GoToInput.fromAddress((Address)location.getAddress());
    }

    public boolean affectedByBytesChange(AddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        return false;
    }

    public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return false;
    }

    public boolean shouldDisassemble() {
        return false;
    }
}

