/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponsePrewarm;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class PrewarmRequest
extends BSimQuery<ResponsePrewarm> {
    public int mainIndexConfig = 2;
    public int secondaryIndexConfig = 1;
    public int vectorTableConfig = 1;
    public ResponsePrewarm prewarmresponse;

    public PrewarmRequest() {
        super("prewarmrequest");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.prewarmresponse = new ResponsePrewarm();
            this.response = this.prewarmresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<').append(this.name).append(">\n");
        buffer.append("<main>");
        SpecXmlUtils.encodeSignedInteger((long)this.mainIndexConfig);
        buffer.append("</main>\n");
        buffer.append("<secondary>");
        SpecXmlUtils.encodeSignedInteger((long)this.secondaryIndexConfig);
        buffer.append("</secondary>\n");
        buffer.append("<table>");
        SpecXmlUtils.encodeSignedInteger((long)this.vectorTableConfig);
        buffer.append("</table>\n");
        buffer.append("</").append(this.name).append(">\n");
        fwrite.write(buffer.toString());
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        parser.start(new String[]{"main"});
        this.mainIndexConfig = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"secondary"});
        this.secondaryIndexConfig = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"table"});
        this.vectorTableConfig = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.end();
    }
}

