/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.features.bsim.query.BSimDBConnectTaskManager;
import ghidra.features.bsim.query.BSimJDBCDataSource;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.DefaultClientAuthenticator;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.dbcp2.BasicDataSource;

public class BSimPostgresDBConnectionManager {
    private static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final int CONN_POOL_SIZE = 2;
    private static final int CONN_POOL_MAX_IDLE = 2;
    private static HashMap<BSimServerInfo, BSimPostgresDataSource> dataSourceMap = new HashMap();
    private static boolean shutdownHookInstalled = false;

    public static synchronized BSimPostgresDataSource getDataSource(BSimServerInfo postgresServerInfo) {
        if (postgresServerInfo.getDBType() != BSimServerInfo.DBType.postgres) {
            throw new IllegalArgumentException("expected postgres server info");
        }
        BSimPostgresDBConnectionManager.enableShutdownHook();
        return dataSourceMap.computeIfAbsent(postgresServerInfo, info -> new BSimPostgresDataSource((BSimServerInfo)info));
    }

    @Deprecated
    public static BSimPostgresDataSource getDataSource(URL postgresUrl) {
        return BSimPostgresDBConnectionManager.getDataSource(new BSimServerInfo(postgresUrl));
    }

    public static synchronized BSimPostgresDataSource getDataSourceIfExists(BSimServerInfo serverInfo) {
        return dataSourceMap.get(serverInfo);
    }

    private static synchronized void remove(BSimServerInfo serverInfo, boolean force) {
        BSimPostgresDataSource ds = dataSourceMap.get(serverInfo);
        if (ds == null) {
            return;
        }
        int n = ds.bds.getNumActive();
        if (n != 0 && !force) {
            Msg.error(BSimPostgresDBConnectionManager.class, (Object)("Unable to remove data source which has " + n + " active connections"));
            return;
        }
        ds.close();
        dataSourceMap.remove(serverInfo);
    }

    private static synchronized void enableShutdownHook() {
        if (shutdownHookInstalled) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Collection<BSimPostgresDataSource> dataSources = dataSourceMap.values();
                for (BSimPostgresDataSource ds : dataSources) {
                    int activeConnections = ds.getActiveConnections();
                    if (activeConnections != 0) {
                        Msg.error(BSimPostgresDBConnectionManager.class, (Object)(activeConnections + " BSim active Postgres connections were not properly closed: " + String.valueOf(ds.serverInfo)));
                    }
                    ds.close();
                }
                dataSourceMap.clear();
            }
        });
        shutdownHookInstalled = true;
    }

    public static class BSimPostgresDataSource
    implements BSimJDBCDataSource {
        private final BSimServerInfo serverInfo;
        private FunctionDatabase.ConnectionType connectionType = FunctionDatabase.ConnectionType.SSL_No_Authentication;
        private boolean successfulConnection = false;
        private BasicDataSource bds = new BasicDataSource();
        private BSimDBConnectTaskManager taskManager;

        private BSimPostgresDataSource(BSimServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.taskManager = new BSimDBConnectTaskManager(serverInfo);
        }

        @Override
        public BSimServerInfo getServerInfo() {
            return this.serverInfo;
        }

        public void initializeFrom(BSimPostgresDataSource otherDs) {
            if (!otherDs.successfulConnection || otherDs.connectionType != FunctionDatabase.ConnectionType.SSL_Password_Authentication) {
                return;
            }
            this.setDefaultProperties();
            this.setSSLProperties();
            this.bds.setUsername(otherDs.getUserName());
            this.bds.setPassword(otherDs.bds.getPassword());
            this.successfulConnection = true;
        }

        public String getUserName() {
            return this.bds.getUsername();
        }

        public void setPreferredUserName(String userName) {
            this.bds.setUsername(userName);
        }

        @Override
        public void dispose() {
            BSimPostgresDBConnectionManager.remove(this.serverInfo, true);
        }

        private void close() {
            try {
                this.bds.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.bds.setPassword(null);
        }

        @Override
        public FunctionDatabase.Status getStatus() {
            if (this.bds.isClosed()) {
                return FunctionDatabase.Status.Unconnected;
            }
            if (this.successfulConnection) {
                return FunctionDatabase.Status.Ready;
            }
            return FunctionDatabase.Status.Error;
        }

        @Override
        public int getActiveConnections() {
            return this.bds.getNumActive();
        }

        @Override
        public int getIdleConnections() {
            return this.bds.getNumIdle();
        }

        public void setPassword(String username, char[] newPassword) {
            if (username.equals(this.bds.getUsername())) {
                this.bds.setPassword(String.valueOf(newPassword));
            }
        }

        private void setDefaultProperties() {
            this.bds.setDriverClassName(BSimPostgresDBConnectionManager.DRIVER_CLASS_NAME);
            int port = this.serverInfo.getPort();
            this.bds.setUrl("jdbc:postgresql://" + this.serverInfo.getServerName() + (String)(port > 0 ? ":" + Integer.toString(port) : "") + "/" + this.serverInfo.getDBName());
            this.bds.setInitialSize(2);
            this.bds.setMaxIdle(2);
            this.bds.setValidationQuery("SELECT 1");
            this.bds.setTestOnBorrow(true);
            this.bds.addConnectionProperty("prepareThreshold", "2");
        }

        private void setSSLProperties() {
            this.bds.addConnectionProperty("sslmode", "require");
            this.bds.addConnectionProperty("sslfactory", "ghidra.net.ApplicationSSLSocketFactory");
        }

        @Override
        public synchronized Connection getConnection() throws SQLException {
            if (this.successfulConnection) {
                try {
                    Connection connection = this.bds.getConnection();
                    return connection;
                }
                catch (SQLException sQLException) {
                    this.bds.restart();
                    Connection connection = this.bds.getConnection();
                    return connection;
                }
                finally {
                    Msg.debug((Object)this, (Object)(String.valueOf(this.serverInfo) + " getConnection: active=" + this.bds.getNumActive() + " idle=" + this.bds.getNumIdle()));
                }
            }
            this.setDefaultProperties();
            return this.taskManager.getConnection(() -> this.connect());
        }

        @Override
        public FunctionDatabase.ConnectionType getConnectionType() {
            return this.connectionType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BSimPostgresDataSource) {
                BSimPostgresDataSource ds = (BSimPostgresDataSource)obj;
                return this.bds.getUrl().equals(ds.bds.getUrl());
            }
            return false;
        }

        public int hashCode() {
            return this.bds.getUrl().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection connect() throws SQLException, CancelledException {
            String loginError;
            block25: {
                loginError = null;
                if (this.bds.getPassword() == null) {
                    this.serverInfo.setUserInfo(this.bds);
                }
                this.connectionType = this.serverInfo.hasPassword() ? FunctionDatabase.ConnectionType.SSL_Password_Authentication : FunctionDatabase.ConnectionType.SSL_No_Authentication;
                try {
                    this.setSSLProperties();
                    Connection c = this.bds.getConnection();
                    this.successfulConnection = true;
                    Connection connection = c;
                    return connection;
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("password-based authentication") || e.getMessage().contains("SCRAM-based") || e.getMessage().contains("password authentication failed")) {
                        if (this.serverInfo.hasPassword()) {
                            loginError = "Access denied: " + String.valueOf(this.serverInfo);
                            Msg.error((Object)this, (Object)loginError);
                        }
                        this.connectionType = FunctionDatabase.ConnectionType.SSL_Password_Authentication;
                        break block25;
                    }
                    if (e.getMessage().contains("SSL on") && e.getMessage().contains("no pg_hba.conf entry")) {
                        this.connectionType = FunctionDatabase.ConnectionType.Unencrypted_No_Authentication;
                        this.bds.removeConnectionProperty("sslmode");
                        this.bds.removeConnectionProperty("sslfactory");
                        break block25;
                    }
                    throw e;
                }
                finally {
                    Msg.debug((Object)this, (Object)(String.valueOf(this.serverInfo) + " getConnection: active=" + this.bds.getNumActive() + " idle=" + this.bds.getNumIdle()));
                }
            }
            while (true) {
                ClientAuthenticator clientAuthenticator = null;
                if (this.connectionType == FunctionDatabase.ConnectionType.SSL_Password_Authentication) {
                    clientAuthenticator = ClientUtil.getClientAuthenticator();
                    if (clientAuthenticator == null) {
                        throw new SQLException("No registered authenticator");
                    }
                    NameCallback nameCb = new NameCallback("User ID:", this.bds.getUsername());
                    boolean allowUserIDEntry = true;
                    if (!this.serverInfo.hasDefaultLogin()) {
                        nameCb.setName(this.bds.getUsername());
                        allowUserIDEntry = false;
                    }
                    PasswordCallback passCb = new PasswordCallback(" ", false);
                    try {
                        if (!clientAuthenticator.processPasswordCallbacks("BSim Database Authentication", "BSim DB Server", this.serverInfo.toString(), allowUserIDEntry, nameCb, passCb, null, null, loginError)) {
                            throw new CancelledException();
                        }
                        this.bds.setPassword(new String(passCb.getPassword()));
                        if (this.serverInfo.hasDefaultLogin()) {
                            this.bds.setUsername(nameCb.getName());
                        }
                    }
                    finally {
                        passCb.clearPassword();
                    }
                }
                try {
                    Connection c = this.bds.getConnection();
                    this.successfulConnection = true;
                    Connection connection = c;
                    return connection;
                }
                catch (SQLException e) {
                    if (clientAuthenticator instanceof DefaultClientAuthenticator && e.getMessage().contains("password authentication failed")) {
                        loginError = "Access denied: " + String.valueOf(this.serverInfo);
                        continue;
                    }
                    this.connectionType = FunctionDatabase.ConnectionType.SSL_No_Authentication;
                    throw e;
                }
                finally {
                    Msg.debug((Object)this, (Object)(String.valueOf(this.serverInfo) + " getConnection: active=" + this.bds.getNumActive() + " idle=" + this.bds.getNumIdle()));
                    continue;
                }
                break;
            }
        }
    }
}

