/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class FramePointerOmissionRecord {
    private long firstFunctionByteOffset;
    private long numFunctionBytes;
    private long numLocalVariables;
    private int sizeOfParametersInDwords;
    private int numFunctionPrologBytes;
    private boolean hasStructuredExceptionHandling;
    private boolean ebpAllocatedAndUsed;
    private int reserved;
    private FrameType frameType;

    public long getFirstFunctionByteOffset() {
        return this.firstFunctionByteOffset;
    }

    public long getNumberOfFunctionBytes() {
        return this.numFunctionBytes;
    }

    public long getNumberLocalVariables() {
        return this.numLocalVariables;
    }

    public int getSizeOfParametersInDwords() {
        return this.sizeOfParametersInDwords;
    }

    public int getNumberFunctionPrologBytes() {
        return this.numFunctionPrologBytes;
    }

    public boolean hasStructuredExceptionHandling() {
        return this.hasStructuredExceptionHandling;
    }

    public boolean EBPAllocatedAndUsed() {
        return this.ebpAllocatedAndUsed;
    }

    public int reserved() {
        return this.reserved;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void parse(PdbByteReader reader) throws PdbException {
        if (reader.numRemaining() < 16) {
            throw new PdbException("Not enough data for FramePointerOmissionRecord");
        }
        this.firstFunctionByteOffset = reader.parseUnsignedIntVal();
        this.numFunctionBytes = reader.parseUnsignedIntVal();
        this.numLocalVariables = reader.parseUnsignedIntVal();
        this.sizeOfParametersInDwords = reader.parseUnsignedShortVal();
        int data = reader.parseUnsignedShortVal();
        this.numFunctionPrologBytes = data & 0xFF;
        this.hasStructuredExceptionHandling = ((data >>= 8) & 1) == 1;
        this.ebpAllocatedAndUsed = ((data >>= 1) & 1) == 1;
        this.reserved = (data >>= 1) & 1;
        this.frameType = FrameType.fromValue((data >>= 1) & 3);
    }

    void dump(Writer writer) throws IOException {
        writer.write("FramePointerOmissionRecord----------------------------------\n");
        writer.write(String.format("firstFunctionByteOffset: 0X%08X\n", this.firstFunctionByteOffset));
        writer.write(String.format("numFunctionBytes: 0X%08X\n", this.numFunctionBytes));
        writer.write(String.format("numLocalVariables: 0X%08X\n", this.numLocalVariables));
        writer.write(String.format("sizeOfParametersInDwords: 0X%08X\n", this.sizeOfParametersInDwords));
        writer.write(String.format("numFunctionPrologBytes: 0X%04X\n", this.numFunctionPrologBytes));
        writer.write(String.format("hasStructuredExceptionHandling: %s\n", Boolean.toString(this.hasStructuredExceptionHandling)));
        writer.write(String.format("EBPAllocatedAndUsed: %s\n", Boolean.toString(this.ebpAllocatedAndUsed)));
        writer.write(String.format("reserved: 0X%01X\n", this.reserved));
        writer.write(String.format("frameType: %s\n", this.frameType.toString()));
        writer.write("End FramePointerOmissionRecord------------------------------\n");
    }

    public static enum FrameType {
        FPO("fpo", 0),
        TRAP("trap", 1),
        TSS("tss", 2),
        NON_FPO("std", 3);

        private static final Map<Integer, FrameType> BY_VALUE;
        public final String label;
        private final int value;

        public String toString() {
            return this.label;
        }

        public static FrameType fromValue(int val) {
            return BY_VALUE.getOrDefault(val, FPO);
        }

        private FrameType(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, FrameType>();
            for (FrameType val : FrameType.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

