/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.JavaEnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.util.exception.DuplicateNameException;

public class TranslationSettingsDefinition
extends JavaEnumSettingsDefinition<TRANSLATION_ENUM> {
    public static final TranslationSettingsDefinition TRANSLATION = new TranslationSettingsDefinition();
    private static final String SHOW_TRANSLATED_TOGGLE_SETTING_NAME = "translated";
    public static String TRANSLATION_PROPERTY_MAP_NAME = "StringTranslations";
    private static final String DEPRECATED_TRANSLATED_VALUE_SETTING_NAME = "translation";

    private TranslationSettingsDefinition() {
        super(SHOW_TRANSLATED_TOGGLE_SETTING_NAME, "Translation", "Selects the display of translated strings", (Enum)TRANSLATION_ENUM.SHOW_ORIGINAL);
    }

    public boolean isShowTranslated(Settings settings) {
        return this.getEnumValue(settings) == TRANSLATION_ENUM.SHOW_TRANSLATED;
    }

    public void setShowTranslated(Settings settings, boolean shouldShowTranslatedValue) {
        this.setEnumValue(settings, shouldShowTranslatedValue ? TRANSLATION_ENUM.SHOW_TRANSLATED : TRANSLATION_ENUM.SHOW_ORIGINAL);
    }

    public boolean hasTranslatedValue(Data data) {
        Program p = data.getProgram();
        PropertyMapManager propertyMapManager = p.getUsrPropertyManager();
        StringPropertyMap translationMap = propertyMapManager.getStringPropertyMap(TRANSLATION_PROPERTY_MAP_NAME);
        boolean hasValue = false;
        if (translationMap != null) {
            hasValue = translationMap.hasProperty(data.getAddress());
        }
        if (!hasValue) {
            Data d = p.getListing().getDefinedDataAt(data.getAddress());
            hasValue = d != null ? d.hasProperty(DEPRECATED_TRANSLATED_VALUE_SETTING_NAME) : false;
        }
        return hasValue;
    }

    public String getTranslatedValue(Data data) {
        Program p = data.getProgram();
        PropertyMapManager propertyMapManager = p.getUsrPropertyManager();
        StringPropertyMap translationMap = propertyMapManager.getStringPropertyMap(TRANSLATION_PROPERTY_MAP_NAME);
        String value = null;
        if (translationMap != null) {
            value = translationMap.getString(data.getAddress());
        }
        if (value == null) {
            Data d = p.getListing().getDefinedDataAt(data.getAddress());
            value = d != null ? d.getString(DEPRECATED_TRANSLATED_VALUE_SETTING_NAME) : null;
        }
        return value;
    }

    public void setTranslatedValue(Data data, String translatedValue) {
        Data d;
        Program p = data.getProgram();
        PropertyMapManager propertyMapManager = p.getUsrPropertyManager();
        StringPropertyMap translationMap = propertyMapManager.getStringPropertyMap(TRANSLATION_PROPERTY_MAP_NAME);
        if (translationMap == null) {
            try {
                translationMap = propertyMapManager.createStringPropertyMap(TRANSLATION_PROPERTY_MAP_NAME);
            }
            catch (DuplicateNameException e) {
                throw new RuntimeException(e);
            }
        }
        if ((d = p.getListing().getDefinedDataAt(data.getAddress())) != null) {
            d.clearSetting(DEPRECATED_TRANSLATED_VALUE_SETTING_NAME);
        }
        if (translatedValue == null) {
            translationMap.remove(data.getAddress());
        } else {
            translationMap.add(data.getAddress(), translatedValue);
        }
    }

    public static enum TRANSLATION_ENUM {
        SHOW_ORIGINAL("show original"),
        SHOW_TRANSLATED("show translated");

        private final String s;

        private TRANSLATION_ENUM(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }

        public TRANSLATION_ENUM invert() {
            return this == SHOW_ORIGINAL ? SHOW_TRANSLATED : SHOW_ORIGINAL;
        }
    }
}

