/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.InvalidInputException;

public class ParameterDefinitionImpl
implements ParameterDefinition {
    private int ordinal;
    private String name;
    private DataType dataType;
    private String comment;

    public ParameterDefinitionImpl(String name, DataType dataType, String comment) {
        this(name, dataType, comment, -2);
    }

    protected ParameterDefinitionImpl(String name, DataType dataType, String comment, int ordinal) {
        this.dataType = ParameterDefinitionImpl.validateDataType(dataType, dataType != null ? dataType.getDataTypeManager() : null, false);
        this.name = name;
        this.comment = comment;
        this.ordinal = ordinal;
    }

    public static DataType validateDataType(DataType dataType, DataTypeManager dtMgr, boolean voidOK) throws IllegalArgumentException {
        try {
            return VariableUtilities.checkDataType(dataType, voidOK, dtMgr);
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public final int compareTo(ParameterDefinition p) {
        return this.ordinal - p.getOrdinal();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getLength() {
        return this.dataType.getLength();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public void setComment(String comment) {
        if (comment != null && comment.endsWith("\n")) {
            comment = comment.substring(0, comment.length() - 1);
        }
        this.comment = comment;
    }

    @Override
    public void setDataType(DataType type) {
        this.dataType = ParameterDefinitionImpl.validateDataType(type, this.dataType.getDataTypeManager(), false);
    }

    @Override
    public void setName(String name) {
        if (SymbolUtilities.isDefaultParameterName(name)) {
            name = null;
        }
        this.name = name;
    }

    @Override
    public boolean isEquivalent(Variable variable) {
        if (variable == null) {
            return false;
        }
        if (!(variable instanceof Parameter)) {
            return false;
        }
        if (this.ordinal != ((Parameter)variable).getOrdinal()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.dataType, variable.getDataType());
    }

    @Override
    public boolean isEquivalent(ParameterDefinition parm) {
        if (parm == null) {
            return false;
        }
        if (this.ordinal != parm.getOrdinal()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.dataType, parm.getDataType());
    }

    public String toString() {
        return this.dataType.getName() + " " + (this.name == null ? "" : this.name);
    }
}

