/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import java.util.Iterator;

public class ImmutableAddressSet
implements AddressSetView {
    public static final ImmutableAddressSet EMPTY_SET = new ImmutableAddressSet(new AddressSet());
    private AddressSet set;

    public static ImmutableAddressSet asImmutable(AddressSetView view) {
        if (view == null) {
            return EMPTY_SET;
        }
        if (view instanceof ImmutableAddressSet) {
            ImmutableAddressSet ias = (ImmutableAddressSet)view;
            return ias;
        }
        return new ImmutableAddressSet(view);
    }

    public ImmutableAddressSet(AddressSetView addresses) {
        this.set = new AddressSet(addresses);
    }

    @Override
    public boolean contains(Address addr) {
        return this.set.contains(addr);
    }

    @Override
    public boolean contains(Address start, Address end) {
        return this.set.contains(start, end);
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        return this.set.contains(rangeSet);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Address getMinAddress() {
        return this.set.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        return this.set.getMaxAddress();
    }

    @Override
    public int getNumAddressRanges() {
        return this.set.getNumAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return this.set.getAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.set.getAddressRanges(forward);
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.set.getAddressRanges(start, forward);
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.set.iterator();
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        return this.set.iterator(forward);
    }

    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.set.iterator(start, forward);
    }

    @Override
    public long getNumAddresses() {
        return this.set.getNumAddresses();
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        return this.set.getAddresses(forward);
    }

    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.set.getAddresses(start, forward);
    }

    @Override
    public boolean intersects(AddressSetView addrSet) {
        return this.set.intersects(addrSet);
    }

    @Override
    public boolean intersects(Address start, Address end) {
        return this.set.intersects(start, end);
    }

    @Override
    public AddressSet intersect(AddressSetView view) {
        return this.set.intersect(view);
    }

    @Override
    public AddressSet intersectRange(Address start, Address end) {
        return this.set.intersectRange(start, end);
    }

    @Override
    public AddressSet union(AddressSetView addrSet) {
        return this.set.union(addrSet);
    }

    @Override
    public AddressSet subtract(AddressSetView addrSet) {
        return this.set.subtract(addrSet);
    }

    @Override
    public AddressSet xor(AddressSetView addrSet) {
        return this.set.xor(addrSet);
    }

    @Override
    public boolean hasSameAddresses(AddressSetView view) {
        return this.set.hasSameAddresses(view);
    }

    @Override
    public AddressRange getFirstRange() {
        return this.set.getFirstRange();
    }

    @Override
    public AddressRange getLastRange() {
        return this.set.getLastRange();
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        return this.set.getRangeContaining(address);
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView addresses) {
        return this.set.findFirstAddressInCommon(addresses);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImmutableAddressSet)) {
            return false;
        }
        ImmutableAddressSet otherSet = (ImmutableAddressSet)obj;
        if (this.getNumAddresses() != otherSet.getNumAddresses()) {
            return false;
        }
        if (this.getNumAddressRanges() != otherSet.getNumAddressRanges()) {
            return false;
        }
        AddressRangeIterator otherRanges = otherSet.getAddressRanges();
        AddressRangeIterator myRanges = this.getAddressRanges();
        while (myRanges.hasNext()) {
            AddressRange otherRange;
            AddressRange myRange = (AddressRange)myRanges.next();
            if (myRange.equals(otherRange = (AddressRange)otherRanges.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getMinAddress().hashCode() + this.getMaxAddress().hashCode();
    }
}

