/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.program.util.ChangeManagerAdapter;
import ghidra.util.Lock;
import ghidra.util.datastruct.ObjectCache;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.NoSuchElementException;

public abstract class PropertyMapDB<T>
extends DatabaseObject
implements PropertyMap<T> {
    private static final String PROPERTY_TABLE_PREFIX = "Property Map - ";
    protected static final String[] SCHEMA_FIELD_NAMES = new String[]{"Value"};
    protected static final String[] NO_SCHEMA_FIELD_NAMES = new String[0];
    protected static final Field[] NO_SCHEMA_FIELDS = new Field[0];
    protected static final int PROPERTY_VALUE_COL = 0;
    protected static final int DEFAULT_CACHE_SIZE = 100;
    static final NoValueException NO_VALUE_EXCEPTION = new NoValueException();
    protected DBHandle dbHandle;
    protected ErrorHandler errHandler;
    protected ChangeManager changeMgr;
    protected Schema schema;
    protected Table propertyTable;
    protected AddressMap addrMap;
    protected String name;
    protected ObjectCache<T> cache = new ObjectCache(100);
    protected Lock lock;

    public static String getTableName(String propertyName) {
        return PROPERTY_TABLE_PREFIX + propertyName;
    }

    PropertyMapDB(DBHandle dbHandle, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name) {
        super(null, 0L);
        this.dbHandle = dbHandle;
        this.errHandler = errHandler;
        this.changeMgr = changeMgr;
        this.lock = new Lock("Property");
        if (changeMgr == null) {
            this.changeMgr = new ChangeManagerAdapter();
        }
        this.addrMap = addrMap;
        this.name = name;
        this.propertyTable = dbHandle.getTable(this.getTableName());
        if (this.propertyTable != null) {
            this.schema = this.propertyTable.getSchema();
        }
    }

    @Override
    protected boolean validate(Lock lck) {
        return super.validate(lck);
    }

    void checkMapVersion(OpenMode openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (this.propertyTable != null && this.addrMap.isUpgraded()) {
            if (openMode == OpenMode.UPGRADE) {
                this.upgradeTable(monitor);
            } else if (openMode != null) {
                throw new VersionException(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeTable(TaskMonitor monitor) throws IOException, CancelledException {
        AddressMap oldAddressMap = this.addrMap.getOldAddressMap();
        monitor.setMessage("Upgrading '" + this.name + "' Properties...");
        monitor.initialize((long)(this.propertyTable.getRecordCount() * 2));
        int count = 0;
        try (DBHandle tmpDb = new DBHandle();){
            DBRecord rec;
            tmpDb.startTransaction();
            Table tempTable = null;
            RecordIterator iter = this.propertyTable.iterator();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                rec = iter.next();
                if (tempTable == null) {
                    tempTable = tmpDb.createTable(this.getTableName(), this.schema);
                }
                Address addr = oldAddressMap.decodeAddress(rec.getKey());
                rec.setKey(this.addrMap.getKey(addr, true));
                tempTable.putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            if (tempTable == null) {
                return;
            }
            this.dbHandle.deleteTable(this.getTableName());
            this.propertyTable = this.dbHandle.createTable(this.getTableName(), this.schema);
            iter = tempTable.iterator();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                rec = iter.next();
                this.propertyTable.putRecord(rec);
                monitor.setProgress((long)(++count));
            }
        }
    }

    protected String getTableName() {
        return PROPERTY_TABLE_PREFIX + this.name;
    }

    protected void createTable(Field valueField) throws IOException {
        this.schema = PropertyMapDB.getTableSchema(valueField);
        this.propertyTable = this.dbHandle.createTable(this.getTableName(), this.schema);
    }

    private static Schema getTableSchema(Field valueField) {
        if (valueField != null) {
            Field[] fields = new Field[]{valueField};
            return new Schema(0, "Address", fields, SCHEMA_FIELD_NAMES);
        }
        return new Schema(0, "Address", NO_SCHEMA_FIELDS, NO_SCHEMA_FIELD_NAMES);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        if (this.propertyTable == null) {
            return;
        }
        this.cache = new ObjectCache(100);
        try {
            this.propertyTable.deleteAll();
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    public void setCacheSize(int size) {
        this.lock.acquire();
        try {
            this.cache.setHardCacheSize(size);
        }
        finally {
            this.lock.release();
        }
    }

    public void delete() throws IOException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.setDeleted();
            if (this.propertyTable != null) {
                this.cache = new ObjectCache(100);
                this.dbHandle.deleteTable(this.getTableName());
                this.propertyTable = null;
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean intersects(Address startAddr, Address endAddr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return false;
        }
        try {
            AddressKeyIterator iter = new AddressKeyIterator(table, this.addrMap, startAddr, endAddr, startAddr, true);
            return iter.hasNext();
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return false;
        }
    }

    @Override
    public boolean intersects(AddressSetView set) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return false;
        }
        try {
            AddressKeyIterator iter = new AddressKeyIterator(table, this.addrMap, set, set.getMinAddress(), true);
            return iter.hasNext();
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRange(Address startAddr, Address endAddr) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.propertyTable == null) {
                boolean bl = false;
                return bl;
            }
            if (AddressRecordDeleter.deleteRecords(this.propertyTable, this.addrMap, startAddr, endAddr)) {
                this.cache = new ObjectCache(100);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Address addr) {
        this.lock.acquire();
        boolean result = false;
        try {
            this.checkDeleted();
            if (this.propertyTable == null) {
                boolean bl = false;
                return bl;
            }
            long addrKey = this.addrMap.getKey(addr, false);
            this.cache.remove(addrKey);
            result = this.propertyTable.deleteRecord(addrKey);
            this.changeMgr.setPropertyChanged(this.name, addr, null, null);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return result;
    }

    @Override
    public boolean hasProperty(Address addr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return false;
        }
        try {
            long addrKey = this.addrMap.getKey(addr, false);
            if (addrKey != -1L) {
                return this.cache.contains(addrKey) || table.hasRecord(addrKey);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return false;
    }

    @Override
    public Address getNextPropertyAddress(Address addr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        try {
            AddressKeyIterator iter = new AddressKeyIterator(table, this.addrMap, addr, false);
            return this.addrMap.decodeAddress(iter.next());
        }
        catch (NoSuchElementException iter) {
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    @Override
    public Address getPreviousPropertyAddress(Address addr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        try {
            AddressKeyIterator iter = new AddressKeyIterator(table, this.addrMap, addr, true);
            return this.addrMap.decodeAddress(iter.previous());
        }
        catch (NoSuchElementException iter) {
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    @Override
    public Address getFirstPropertyAddress() {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        try {
            AddressKeyIterator iter = new AddressKeyIterator(table, this.addrMap, true);
            return this.addrMap.decodeAddress(iter.next());
        }
        catch (NoSuchElementException iter) {
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    @Override
    public Address getLastPropertyAddress() {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        try {
            AddressKeyIterator iter = new AddressKeyIterator(table, this.addrMap, this.addrMap.getAddressFactory().getAddressSet().getMaxAddress(), false);
            return this.addrMap.decodeAddress(iter.previous());
        }
        catch (NoSuchElementException iter) {
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    @Override
    public int getSize() {
        this.validate(this.lock);
        Table table = this.propertyTable;
        return table != null ? table.getRecordCount() : 0;
    }

    public AddressKeyIterator getAddressKeyIterator(AddressSetView set, boolean atStart) throws IOException {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null || set != null && set.isEmpty()) {
            return AddressKeyIterator.EMPTY_ITERATOR;
        }
        if (atStart) {
            return new AddressKeyIterator(table, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(table, this.addrMap, set, set.getMaxAddress(), false);
    }

    public AddressKeyIterator getAddressKeyIterator(Address start, boolean before) throws IOException {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return AddressKeyIterator.EMPTY_ITERATOR;
        }
        return new AddressKeyIterator(table, this.addrMap, start, before);
    }

    public AddressKeyIterator getAddressKeyIterator(Address start, Address end, boolean atStart) throws IOException {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return AddressKeyIterator.EMPTY_ITERATOR;
        }
        if (atStart) {
            return new AddressKeyIterator(table, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(table, this.addrMap, start, end, end, false);
    }

    @Override
    public AddressIterator getPropertyIterator(Address start, Address end) {
        AddressKeyIterator keyIter = null;
        try {
            keyIter = this.getAddressKeyIterator(start, end, true);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return new AddressKeyAddressIterator(keyIter, true, this.addrMap, this.errHandler);
    }

    @Override
    public AddressIterator getPropertyIterator(Address start, Address end, boolean forward) {
        AddressKeyIterator keyIter = null;
        try {
            keyIter = this.getAddressKeyIterator(start, end, forward);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return new AddressKeyAddressIterator(keyIter, forward, this.addrMap, this.errHandler);
    }

    @Override
    public AddressIterator getPropertyIterator() {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return new EmptyAddressIterator();
        }
        AddressKeyIterator keyIter = null;
        try {
            keyIter = new AddressKeyIterator(table, this.addrMap, true);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return new AddressKeyAddressIterator(keyIter, true, this.addrMap, this.errHandler);
    }

    @Override
    public AddressIterator getPropertyIterator(AddressSetView asv) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return new EmptyAddressIterator();
        }
        AddressKeyIterator keyIter = null;
        try {
            keyIter = new AddressKeyIterator(table, this.addrMap, asv, asv.getMinAddress(), true);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return new AddressKeyAddressIterator(keyIter, true, this.addrMap, this.errHandler);
    }

    @Override
    public AddressIterator getPropertyIterator(AddressSetView asv, boolean forward) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null || asv != null && asv.isEmpty()) {
            return AddressIterator.EMPTY_ITERATOR;
        }
        AddressKeyIterator keyIter = null;
        try {
            keyIter = forward ? new AddressKeyIterator(table, this.addrMap, asv, asv.getMinAddress(), true) : new AddressKeyIterator(table, this.addrMap, asv, asv.getMaxAddress(), false);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return new AddressKeyAddressIterator(keyIter, forward, this.addrMap, this.errHandler);
    }

    @Override
    public AddressIterator getPropertyIterator(Address start, boolean forward) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return new EmptyAddressIterator();
        }
        AddressKeyIterator keyIter = null;
        try {
            keyIter = new AddressKeyIterator(table, this.addrMap, start, forward);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return new AddressKeyAddressIterator(keyIter, forward, this.addrMap, this.errHandler);
    }

    public void invalidate() {
        this.lock.acquire();
        try {
            this.setInvalid();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected boolean refresh() {
        this.cache = new ObjectCache(100);
        this.propertyTable = this.dbHandle.getTable(this.getTableName());
        if (this.propertyTable != null && !this.propertyTable.getSchema().equals((Object)this.schema)) {
            this.propertyTable = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveRange(Address start, Address end, Address newStart) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.cache = new ObjectCache(100);
            if (this.propertyTable != null) {
                try {
                    DatabaseTableUtils.updateAddressKey(this.propertyTable, this.addrMap, start, end, newStart, TaskMonitor.DUMMY);
                }
                catch (CancelledException cancelledException) {
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }
}

