/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.program.database.OverlayRegionSupplier;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.util.InvalidNameException;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;

public class ProgramAddressFactory
extends DefaultAddressFactory {
    protected final OverlayRegionSupplier overlayRegionSupplier;
    private AddressFactory originalFactory;
    private AddressSpace stackSpace;
    private boolean hasStaleOverlays = false;
    private long nextTmpId = 1L;

    public ProgramAddressFactory(Language language, CompilerSpec compilerSpec, OverlayRegionSupplier overlayRegionSupplier) {
        super(language.getAddressFactory().getAllAddressSpaces(), language.getAddressFactory().getDefaultAddressSpace());
        this.originalFactory = language.getAddressFactory();
        this.overlayRegionSupplier = overlayRegionSupplier;
        this.initOtherSpace(language);
        this.initExternalSpace(language);
        this.initStackSpace(language, compilerSpec);
        this.initHashSpace(language);
        this.initJoinSpace(language);
    }

    public void invalidateOverlayCache() {
        for (AddressSpace space : this.getAddressSpaces()) {
            if (!(space instanceof ProgramOverlayAddressSpace)) continue;
            ProgramOverlayAddressSpace os = (ProgramOverlayAddressSpace)space;
            os.invalidate();
        }
    }

    private void initOtherSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.OTHER_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'OTHER' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initExternalSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.EXTERNAL_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'EXTERNAL' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initStackSpace(Language language, CompilerSpec compilerSpec) {
        this.stackSpace = compilerSpec.getStackSpace();
        try {
            this.addAddressSpace(this.stackSpace);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'STACK' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initHashSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.HASH_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'HASH' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initJoinSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.VARIABLE_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'JOIN' space: " + language.getLanguageID().getIdAsString());
        }
    }

    @Override
    public AddressSpace getStackSpace() {
        return this.stackSpace;
    }

    AddressFactory getOriginalAddressFactory() {
        return this.originalFactory;
    }

    protected boolean isValidOverlayBaseSpace(AddressSpace baseSpace) {
        if (baseSpace != this.getAddressSpace(baseSpace.getName())) {
            return false;
        }
        return baseSpace.isMemorySpace() && !baseSpace.isOverlaySpace();
    }

    protected void addOverlaySpace(ProgramOverlayAddressSpace ovSpace) throws DuplicateNameException {
        if (!ovSpace.getOrderedKey().equals(ovSpace.getName())) {
            this.hasStaleOverlays = true;
        }
        this.addAddressSpace(ovSpace);
    }

    protected ProgramOverlayAddressSpace addOverlaySpace(long key, String overlayName, AddressSpace baseSpace) throws DuplicateNameException {
        if (!this.isValidOverlayBaseSpace(baseSpace)) {
            throw new IllegalArgumentException("Invalid base space for overlay: " + baseSpace.getName());
        }
        AddressSpace space = this.getAddressSpace(baseSpace.getName());
        if (space != baseSpace) {
            throw new IllegalArgumentException("Invalid memory address space instance");
        }
        return new ProgramOverlayAddressSpace(key, overlayName, baseSpace, this.getNextUniqueID(), this.overlayRegionSupplier, this);
    }

    public void checkValidOverlaySpaceName(String name) throws InvalidNameException, DuplicateNameException {
        if (!AddressSpace.isValidName(name)) {
            throw new InvalidNameException("Invalid overlay space name: " + name);
        }
        if (this.getAddressSpace(name) != null) {
            throw new DuplicateNameException("Duplicate address space name: " + name);
        }
    }

    @Override
    public Address getAddress(int spaceID, long offset) {
        Address addr = super.getAddress(spaceID, offset);
        if (addr == null && spaceID == this.stackSpace.getSpaceID()) {
            return this.stackSpace.getAddress(offset);
        }
        return addr;
    }

    @Override
    public Address getAddress(String addrString) {
        Address addr = null;
        if (addrString.startsWith("Stack[") && addrString.endsWith("]")) {
            try {
                long stackOffset = NumericUtilities.parseHexLong((String)addrString.substring(6, addrString.length() - 1));
                addr = this.stackSpace.getAddress(stackOffset);
            }
            catch (AddressOutOfBoundsException | NumberFormatException runtimeException) {}
        } else {
            addr = super.getAddress(addrString);
        }
        return addr;
    }

    protected void removeOverlaySpace(String name) {
        AddressSpace space = this.getAddressSpace(name);
        if (!(space instanceof ProgramOverlayAddressSpace)) {
            throw new IllegalArgumentException("Overlay " + name + " not found");
        }
        this.removeAddressSpace(name);
    }

    protected void overlaySpaceRenamed(String oldOverlaySpaceName, String newName, boolean refreshStatusIfNeeded) {
        OverlayAddressSpace os = super.overlaySpaceRenamed(oldOverlaySpaceName, newName);
        if (!newName.equals(os.getOrderedKey())) {
            this.hasStaleOverlays = true;
        } else if (this.hasStaleOverlays && refreshStatusIfNeeded) {
            this.refreshStaleOverlayStatus();
        }
    }

    private int getNextUniqueID() {
        AddressSpace[] spaces;
        int maxID = 0;
        for (AddressSpace space : spaces = this.getAllAddressSpaces()) {
            maxID = Math.max(maxID, space.getUnique());
        }
        return maxID + 1;
    }

    protected void refreshStaleOverlayStatus() {
        this.hasStaleOverlays = false;
        for (AddressSpace space : this.getAddressSpaces()) {
            ProgramOverlayAddressSpace os;
            if (!(space instanceof ProgramOverlayAddressSpace) || (os = (ProgramOverlayAddressSpace)space).getName().equals(os.getOrderedKey())) continue;
            this.hasStaleOverlays = true;
            break;
        }
    }

    @Override
    public boolean hasStaleOverlayCondition() {
        return this.hasStaleOverlays;
    }

    synchronized String generateOrderedKey(String overlayName) {
        for (AddressSpace space : this.getAddressSpaces()) {
            ProgramOverlayAddressSpace os;
            if (!(space instanceof ProgramOverlayAddressSpace) || !overlayName.equals((os = (ProgramOverlayAddressSpace)space).getOrderedKey())) continue;
            return overlayName + ":" + this.nextTmpId++;
        }
        return overlayName;
    }
}

