/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.Sequence;
import ghidra.trace.model.time.schedule.SkipStep;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.trace.model.time.schedule.TickStep;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TraceSchedule
implements Comparable<TraceSchedule> {
    public static final TraceSchedule ZERO = TraceSchedule.snap(0L);
    private static final String PARSE_ERR_MSG = "Time specification must have form 'snap[:steps[.pSteps]]'";
    private final long snap;
    private final Sequence steps;
    private final Sequence pSteps;
    private final Source source;

    public static final TraceSchedule snap(long snap) {
        return new TraceSchedule(snap, new Sequence(), new Sequence(), Source.RECORD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TraceSchedule parse(String spec, Source source, TimeRadix radix) {
        Sequence pTicks;
        Sequence ticks;
        long snap;
        String[] parts = spec.split(":", 2);
        if (parts.length > 2) {
            throw new AssertionError();
        }
        try {
            snap = radix.decode(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(PARSE_ERR_MSG, e);
        }
        if (parts.length > 1) {
            String[] subs = parts[1].split("\\.");
            try {
                ticks = Sequence.parse(subs[0], radix);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(PARSE_ERR_MSG, e);
            }
            if (subs.length == 1) {
                pTicks = new Sequence();
                return new TraceSchedule(snap, ticks, pTicks, source);
            } else {
                if (subs.length != 2) throw new IllegalArgumentException(PARSE_ERR_MSG);
                try {
                    pTicks = Sequence.parse(subs[1], radix);
                    return new TraceSchedule(snap, ticks, pTicks, source);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(PARSE_ERR_MSG, e);
                }
            }
        }
        ticks = new Sequence();
        pTicks = new Sequence();
        return new TraceSchedule(snap, ticks, pTicks, source);
    }

    public static TraceSchedule parse(String spec, TimeRadix radix) {
        return TraceSchedule.parse(spec, Source.INPUT, radix);
    }

    public static TraceSchedule parse(String spec) {
        return TraceSchedule.parse(spec, TimeRadix.DEFAULT);
    }

    public TraceSchedule(long snap, Sequence steps, Sequence pSteps, Source source) {
        this.snap = snap;
        this.steps = steps;
        this.pSteps = pSteps;
        this.source = source.adjust(pSteps.totalTickCount(), pSteps.totalPatchCount(), pSteps.totalSkipCount());
    }

    public TraceSchedule(long snap, Sequence steps, Sequence pSteps) {
        this(snap, steps, pSteps, Source.INPUT);
    }

    public String toString() {
        return this.toString(TimeRadix.DEFAULT);
    }

    public String toString(TimeRadix radix) {
        if (this.pSteps.isNop()) {
            if (this.steps.isNop()) {
                return radix.format(this.snap);
            }
            return String.format("%s:%s", radix.format(this.snap), this.steps.toString(radix));
        }
        return String.format("%s:%s.%s", radix.format(this.snap), this.steps.toString(radix), this.pSteps.toString(radix));
    }

    public CompareResult compareSchedule(TraceSchedule that) {
        CompareResult result = CompareResult.unrelated(Long.compare(this.snap, that.snap));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        result = this.steps.compareSeq(that.steps);
        return switch (result) {
            case CompareResult.UNREL_LT, CompareResult.UNREL_GT -> result;
            case CompareResult.REL_LT -> {
                if (this.pSteps.isNop() || this.source == Source.RECORD) {
                    yield CompareResult.REL_LT;
                }
                yield CompareResult.UNREL_LT;
            }
            case CompareResult.REL_GT -> {
                if (that.pSteps.isNop() || that.source == Source.RECORD) {
                    yield CompareResult.REL_GT;
                }
                yield CompareResult.UNREL_GT;
            }
            default -> this.pSteps.compareSeq(that.pSteps);
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TraceSchedule)) {
            return false;
        }
        TraceSchedule that = (TraceSchedule)obj;
        if (this.snap != that.snap) {
            return false;
        }
        if (!Objects.equals(this.steps, that.steps)) {
            return false;
        }
        return Objects.equals(this.pSteps, that.pSteps);
    }

    public int hashCode() {
        return Objects.hash(this.snap, this.steps, this.pSteps);
    }

    @Override
    public int compareTo(TraceSchedule o) {
        return this.compareSchedule((TraceSchedule)o).compareTo;
    }

    public boolean isSnapOnly() {
        return ScheduleForm.SNAP_ONLY.contains(null, this);
    }

    public boolean hasSteps() {
        return !this.steps.isNop();
    }

    public long getSnap() {
        return this.snap;
    }

    public long getLastThreadKey() {
        long last = this.pSteps.getLastThreadKey();
        if (last != -1L) {
            return last;
        }
        return this.steps.getLastThreadKey();
    }

    public TraceThread getEventThread(Trace trace) {
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(this.snap, false);
        return snapshot == null ? null : snapshot.getEventThread();
    }

    public TraceThread getLastThread(Trace trace) {
        long lastKey = this.getLastThreadKey();
        return lastKey == -1L ? this.getEventThread(trace) : trace.getThreadManager().getThread(lastKey);
    }

    public TraceThread requireLastThread(Trace trace) {
        long lastKey = this.getLastThreadKey();
        return Step.requireThread(lastKey == -1L ? this.getEventThread(trace) : trace.getThreadManager().getThread(lastKey), lastKey);
    }

    public long totalTickCount() {
        return this.steps.totalTickCount() + this.pSteps.totalTickCount();
    }

    public long totalPatchCount() {
        return this.steps.totalPatchCount() + this.pSteps.totalPatchCount();
    }

    public long tickCount() {
        return this.steps.totalTickCount();
    }

    public long patchCount() {
        return this.steps.totalPatchCount();
    }

    public long pTickCount() {
        return this.pSteps.totalTickCount();
    }

    public long pPatchCount() {
        return this.pSteps.totalPatchCount();
    }

    public void execute(Trace trace, PcodeMachine<?> machine, TaskMonitor monitor) throws CancelledException {
        machine.setSoftwareInterruptMode(PcodeMachine.SwiMode.IGNORE_ALL);
        TraceThread lastThread = this.getEventThread(trace);
        lastThread = this.steps.execute(trace, lastThread, machine, Stepper.instruction(), monitor);
        lastThread = this.pSteps.execute(trace, lastThread, machine, Stepper.pcode(), monitor);
    }

    public void validate(Trace trace) {
        TraceThread lastThread = this.getEventThread(trace);
        lastThread = this.steps.validate(trace, lastThread);
        lastThread = this.pSteps.validate(trace, lastThread);
    }

    public void finish(Trace trace, TraceSchedule position, PcodeMachine<?> machine, TaskMonitor monitor) throws CancelledException {
        TraceThread lastThread = position.requireLastThread(trace);
        Sequence remains = this.steps.relativize(position.steps);
        machine.setSoftwareInterruptMode(PcodeMachine.SwiMode.IGNORE_ALL);
        if (remains.isNop()) {
            Sequence pRemains = this.pSteps.relativize(position.pSteps);
            lastThread = pRemains.execute(trace, lastThread, machine, Stepper.pcode(), monitor);
        } else {
            remains = remains.checkFinish(lastThread, machine);
            lastThread = remains.execute(trace, lastThread, machine, Stepper.instruction(), monitor);
            lastThread = this.pSteps.execute(trace, lastThread, machine, Stepper.pcode(), monitor);
        }
    }

    public TraceSchedule steppedForward(TraceThread thread, long tickCount) {
        Sequence steps = this.steps.clone();
        steps.advance(new TickStep(thread == null ? -1L : thread.getKey(), tickCount));
        return new TraceSchedule(this.snap, steps, new Sequence(), Source.RECORD);
    }

    public TraceSchedule skippedForward(TraceThread thread, long tickCount) {
        Sequence steps = this.steps.clone();
        steps.advance(new SkipStep(thread == null ? -1L : thread.getKey(), tickCount));
        return new TraceSchedule(this.snap, steps, new Sequence(), Source.RECORD);
    }

    protected TraceSchedule doSteppedBackward(Trace trace, long tickCount, Set<Long> visited) {
        if (!visited.add(this.snap)) {
            return null;
        }
        long excess = tickCount - this.totalTickCount() - this.totalPatchCount();
        if (excess > 0L) {
            if (trace == null) {
                return null;
            }
            TraceSnapshot source = trace.getTimeManager().getSnapshot(this.snap, false);
            if (source == null) {
                return null;
            }
            TraceSchedule rec = source.getSchedule();
            if (rec == null) {
                return null;
            }
            return rec.doSteppedBackward(trace, excess, visited);
        }
        Sequence steps = this.steps.clone();
        steps.rewind(tickCount);
        return new TraceSchedule(this.snap, steps, new Sequence(), Source.RECORD);
    }

    public TraceSchedule steppedBackward(Trace trace, long stepCount) {
        return this.doSteppedBackward(trace, stepCount, new HashSet<Long>());
    }

    public TraceSchedule steppedPcodeForward(TraceThread thread, int pTickCount) {
        Sequence pTicks = this.pSteps.clone();
        pTicks.advance(new TickStep(thread == null ? -1L : thread.getKey(), pTickCount));
        return new TraceSchedule(this.snap, this.steps.clone(), pTicks, Source.INPUT);
    }

    public TraceSchedule skippedPcodeForward(TraceThread thread, int pTickCount) {
        Sequence pTicks = this.pSteps.clone();
        pTicks.advance(new SkipStep(thread == null ? -1L : thread.getKey(), pTickCount));
        return new TraceSchedule(this.snap, this.steps.clone(), pTicks, Source.INPUT);
    }

    public TraceSchedule steppedPcodeBackward(int pStepCount) {
        if ((long)pStepCount > this.pSteps.totalTickCount()) {
            return null;
        }
        Sequence pTicks = this.pSteps.clone();
        pTicks.rewind(pStepCount);
        return new TraceSchedule(this.snap, this.steps.clone(), pTicks, Source.INPUT);
    }

    private long keyOf(TraceThread thread) {
        return thread == null ? -1L : thread.getKey();
    }

    public TraceSchedule patched(TraceThread thread, Language language, String sleigh) {
        if (!this.pSteps.isNop()) {
            Sequence pTicks = this.pSteps.clone();
            pTicks.advance(new PatchStep(thread.getKey(), sleigh));
            pTicks.coalescePatches(language);
            return new TraceSchedule(this.snap, this.steps.clone(), pTicks, Source.INPUT);
        }
        Sequence ticks = this.steps.clone();
        ticks.advance(new PatchStep(this.keyOf(thread), sleigh));
        ticks.coalescePatches(language);
        return new TraceSchedule(this.snap, ticks, new Sequence(), Source.RECORD);
    }

    public TraceSchedule patched(TraceThread thread, Language language, List<String> sleigh) {
        if (!this.pSteps.isNop()) {
            Sequence pTicks = this.pSteps.clone();
            for (String line : sleigh) {
                pTicks.advance(new PatchStep(thread.getKey(), line));
            }
            pTicks.coalescePatches(language);
            return new TraceSchedule(this.snap, this.steps.clone(), pTicks, Source.INPUT);
        }
        Sequence ticks = this.steps.clone();
        for (String line : sleigh) {
            ticks.advance(new PatchStep(thread.getKey(), line));
        }
        ticks.coalescePatches(language);
        return new TraceSchedule(this.snap, ticks, new Sequence(), Source.RECORD);
    }

    public TraceSchedule advanced(TraceSchedule next) {
        if (this.pSteps.isNop()) {
            Sequence ticks = this.steps.clone();
            ticks.advance(next.steps);
            return new TraceSchedule(this.snap, ticks, next.pSteps.clone(), next.source);
        }
        if (next.steps.isNop()) {
            Sequence pTicks = this.pSteps.clone();
            pTicks.advance(next.pSteps);
            return new TraceSchedule(this.snap, this.steps.clone(), pTicks, Source.INPUT);
        }
        throw new IllegalArgumentException("Cannot have instructions steps following p-code steps");
    }

    public TraceSchedule dropPSteps() {
        return new TraceSchedule(this.snap, this.steps, new Sequence());
    }

    public Set<TraceThread> getThreads(Trace trace) {
        HashSet<TraceThread> result = new HashSet<TraceThread>();
        TraceThread lastThread = this.getEventThread(trace);
        lastThread = this.steps.collectThreads(result, trace, lastThread);
        lastThread = this.pSteps.collectThreads(result, trace, lastThread);
        result.add(lastThread);
        result.remove(null);
        return result;
    }

    public TraceSchedule assumeRecorded() {
        return new TraceSchedule(this.snap, this.steps, this.pSteps, Source.RECORD);
    }

    public boolean differsOnlyByPatch(TraceSchedule that) {
        if (this.snap != that.snap) {
            return false;
        }
        if (this.pSteps.isNop() != that.pSteps.isNop()) {
            return false;
        }
        if (this.pSteps.isNop()) {
            return this.steps.differsOnlyByPatch(that.steps);
        }
        if (!this.steps.equals(that.steps)) {
            return false;
        }
        return this.pSteps.differsOnlyByPatch(that.pSteps);
    }

    public static enum Source {
        INPUT{

            @Override
            Source adjust(long pTickCount, long pPatchCount, long pSkipCount) {
                return pTickCount <= 1L && pPatchCount == 0L && pSkipCount == 0L ? RECORD : INPUT;
            }
        }
        ,
        RECORD{

            @Override
            Source adjust(long pTickCount, long pPatchCount, long pSkipCount) {
                return pPatchCount == 0L && pSkipCount == 0L ? RECORD : INPUT;
            }
        };


        abstract Source adjust(long var1, long var3, long var5);
    }

    public static enum TimeRadix {
        DEC("dec", 10, "%d"),
        HEX_UPPER("HEX", 16, "%X"),
        HEX_LOWER("hex", 16, "%x");

        public static final TimeRadix DEFAULT;
        public final String name;
        public final int n;
        public final String fmt;

        public static TimeRadix fromStr(String s) {
            return switch (s) {
                case "dec" -> DEC;
                case "HEX" -> HEX_UPPER;
                case "hex" -> HEX_LOWER;
                default -> DEFAULT;
            };
        }

        private TimeRadix(String name, int n2, String fmt) {
            this.name = name;
            this.n = n2;
            this.fmt = fmt;
        }

        public String format(long time) {
            return this.fmt.formatted(time);
        }

        public long decode(String nm) {
            if (nm.startsWith("0x") || nm.startsWith("0X") || nm.startsWith("-0x") || nm.startsWith("-0X")) {
                return Long.parseLong(nm, 16);
            }
            if (nm.startsWith("0n") || nm.startsWith("0N") || nm.startsWith("-0n") || nm.startsWith("-0N")) {
                return Long.parseLong(nm, 10);
            }
            return Long.parseLong(nm, this.n);
        }

        static {
            DEFAULT = DEC;
        }
    }

    public static enum ScheduleForm {
        SNAP_ONLY{

            @Override
            public boolean contains(Trace trace, TraceSchedule schedule) {
                return schedule.steps.isNop() && schedule.pSteps.isNop();
            }
        }
        ,
        SNAP_EVT_STEPS{

            @Override
            public boolean contains(Trace trace, TraceSchedule schedule) {
                TraceThread thread;
                if (!schedule.pSteps.isNop()) {
                    return false;
                }
                List<Step> steps = schedule.steps.getSteps();
                if (steps.isEmpty()) {
                    return true;
                }
                if (steps.size() != 1) {
                    return false;
                }
                Step step = steps.getFirst();
                if (!(step instanceof TickStep)) {
                    return false;
                }
                TickStep ticks = (TickStep)step;
                if (ticks.getThreadKey() == -1L) {
                    return true;
                }
                if (trace == null) {
                    return false;
                }
                TraceThread eventThread = schedule.getEventThread(trace);
                return eventThread == (thread = ticks.getThread(trace.getThreadManager(), eventThread));
            }

            @Override
            public TraceSchedule validate(Trace trace, TraceSchedule schedule) {
                TraceThread thread;
                if (!schedule.pSteps.isNop()) {
                    return null;
                }
                List<Step> steps = schedule.steps.getSteps();
                if (steps.isEmpty()) {
                    return schedule;
                }
                if (steps.size() != 1) {
                    return null;
                }
                Step step = steps.getFirst();
                if (!(step instanceof TickStep)) {
                    return null;
                }
                TickStep ticks = (TickStep)step;
                if (ticks.getThreadKey() == -1L) {
                    return schedule;
                }
                if (trace == null) {
                    return null;
                }
                TraceThread eventThread = schedule.getEventThread(trace);
                if (eventThread != (thread = ticks.getThread(trace.getThreadManager(), eventThread))) {
                    return null;
                }
                return TraceSchedule.snap(schedule.snap).steppedForward(null, ticks.getTickCount());
            }
        }
        ,
        SNAP_ANY_STEPS{

            @Override
            public boolean contains(Trace trace, TraceSchedule schedule) {
                return schedule.pSteps.isNop();
            }
        }
        ,
        SNAP_ANY_STEPS_OPS{

            @Override
            public boolean contains(Trace trace, TraceSchedule schedule) {
                return true;
            }
        };

        public static final List<ScheduleForm> VALUES;

        public abstract boolean contains(Trace var1, TraceSchedule var2);

        public TraceSchedule validate(Trace trace, TraceSchedule schedule) {
            if (!this.contains(trace, schedule)) {
                return null;
            }
            return schedule;
        }

        public ScheduleForm intersect(ScheduleForm that) {
            int ord = Math.min(this.ordinal(), that.ordinal());
            return VALUES.get(ord);
        }

        static {
            VALUES = List.of(ScheduleForm.values());
        }
    }
}

