/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.info.TraceObjectInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

@TraceObjectInfo(schemaName="MemoryRegion", shortName="region", attributes={"_range", "_readable", "_writable", "_executable", "_volatile"}, fixedKeys={"_display", "_range"})
public interface TraceMemoryRegion
extends TraceUniqueObject,
TraceObjectInterface {
    public static final String KEY_RANGE = "_range";
    public static final String KEY_READABLE = "_readable";
    public static final String KEY_WRITABLE = "_writable";
    public static final String KEY_EXECUTABLE = "_executable";
    public static final String KEY_VOLATILE = "_volatile";

    public Trace getTrace();

    public String getPath();

    public void setName(Lifespan var1, String var2);

    public void setName(long var1, String var3);

    public String getName(long var1);

    public void setRange(Lifespan var1, AddressRange var2);

    public void setRange(long var1, AddressRange var3) throws TraceOverlappedRegionException;

    public AddressRange getRange(long var1);

    public void setMinAddress(long var1, Address var3) throws TraceOverlappedRegionException;

    public Address getMinAddress(long var1);

    public void setMaxAddress(long var1, Address var3) throws TraceOverlappedRegionException;

    public Address getMaxAddress(long var1);

    public void setLength(long var1, long var3) throws AddressOverflowException, TraceOverlappedRegionException;

    public long getLength(long var1);

    public void setFlags(Lifespan var1, Collection<TraceMemoryFlag> var2);

    public void setFlags(long var1, Collection<TraceMemoryFlag> var3);

    default public void setFlags(long snap, TraceMemoryFlag ... flags) {
        this.setFlags(snap, Arrays.asList(flags));
    }

    public void addFlags(Lifespan var1, Collection<TraceMemoryFlag> var2);

    public void addFlags(long var1, Collection<TraceMemoryFlag> var3);

    default public void addFlags(long snap, TraceMemoryFlag ... flags) {
        this.addFlags(snap, Arrays.asList(flags));
    }

    public void clearFlags(Lifespan var1, Collection<TraceMemoryFlag> var2);

    public void clearFlags(long var1, Collection<TraceMemoryFlag> var3);

    default public void clearFlags(long snap, TraceMemoryFlag ... flags) {
        this.clearFlags(snap, Arrays.asList(flags));
    }

    public Set<TraceMemoryFlag> getFlags(long var1);

    default public void setRead(long snap, boolean read) {
        if (read) {
            this.addFlags(snap, TraceMemoryFlag.READ);
        } else {
            this.clearFlags(snap, TraceMemoryFlag.READ);
        }
    }

    default public boolean isRead(long snap) {
        return this.getFlags(snap).contains((Object)TraceMemoryFlag.READ);
    }

    default public void setWrite(long snap, boolean write) {
        if (write) {
            this.addFlags(snap, TraceMemoryFlag.WRITE);
        } else {
            this.clearFlags(snap, TraceMemoryFlag.WRITE);
        }
    }

    default public boolean isWrite(long snap) {
        return this.getFlags(snap).contains((Object)TraceMemoryFlag.WRITE);
    }

    default public void setExecute(long snap, boolean execute) {
        if (execute) {
            this.addFlags(snap, TraceMemoryFlag.EXECUTE);
        } else {
            this.clearFlags(snap, TraceMemoryFlag.EXECUTE);
        }
    }

    default public boolean isExecute(long snap) {
        return this.getFlags(snap).contains((Object)TraceMemoryFlag.EXECUTE);
    }

    default public void setVolatile(long snap, boolean vol) {
        if (vol) {
            this.addFlags(snap, TraceMemoryFlag.VOLATILE);
        } else {
            this.clearFlags(snap, TraceMemoryFlag.VOLATILE);
        }
    }

    default public boolean isVolatile(long snap) {
        return this.getFlags(snap).contains((Object)TraceMemoryFlag.VOLATILE);
    }

    public void delete();

    public void remove(long var1);

    public boolean isValid(long var1);
}

