/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import java.util.Collection;
import java.util.EnumSet;

public enum TraceMemoryFlag {
    EXECUTE(1),
    WRITE(2),
    READ(4),
    VOLATILE(8);

    private final byte bits;

    public static EnumSet<TraceMemoryFlag> fromBits(EnumSet<TraceMemoryFlag> flags, int mask) {
        for (TraceMemoryFlag f : TraceMemoryFlag.values()) {
            if ((mask & f.getBits()) == 0) continue;
            flags.add(f);
        }
        return flags;
    }

    public static Collection<TraceMemoryFlag> fromBits(int mask) {
        return TraceMemoryFlag.fromBits(EnumSet.noneOf(TraceMemoryFlag.class), mask);
    }

    public static byte toBits(Collection<TraceMemoryFlag> flags) {
        byte bits = 0;
        for (TraceMemoryFlag f : flags) {
            bits = (byte)(bits | f.getBits());
        }
        return bits;
    }

    private TraceMemoryFlag(int mask) {
        this.bits = (byte)mask;
    }

    public byte getBits() {
        return this.bits;
    }
}

