/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceMemoryRegion
implements TraceMemoryRegion,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final RegionChangeTranslator translator;

    public DBTraceMemoryRegion(DBTraceObject object) {
        this.object = object;
        this.translator = new RegionChangeTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(long snap, String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(Lifespan.nowOn(snap), name);
        }
    }

    @Override
    public String getName(long snap) {
        String key = this.object.getCanonicalPath().key();
        String index = KeyPath.parseIfIndex(key);
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_display", String.class, index);
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange newRange) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", newRange);
        }
    }

    @Override
    public void setRange(long snap, AddressRange newRange) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(Lifespan.nowOn(snap), newRange);
        }
    }

    @Override
    public AddressRange getRange(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            AddressRange addressRange = TraceObjectInterfaceUtils.getValue(this.object, snap, "_range", AddressRange.class, null);
            return addressRange;
        }
    }

    @Override
    public void setMinAddress(long snap, Address min) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(Lifespan.nowOn(snap), DBTraceUtils.toRange(min, this.getMaxAddress(snap)));
        }
    }

    @Override
    public Address getMinAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public void setMaxAddress(long snap, Address max) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(Lifespan.nowOn(snap), DBTraceUtils.toRange(this.getMinAddress(snap), max));
        }
    }

    @Override
    public Address getMaxAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public void setLength(long snap, long length) throws AddressOverflowException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(Lifespan.nowOn(snap), (AddressRange)new AddressRangeImpl(this.getMinAddress(snap), length));
        }
    }

    @Override
    public long getLength(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? 0L : range.getLength();
    }

    protected static String keyForFlag(TraceMemoryFlag flag) {
        return switch (flag) {
            case TraceMemoryFlag.READ -> "_readable";
            case TraceMemoryFlag.WRITE -> "_writable";
            case TraceMemoryFlag.EXECUTE -> "_executable";
            case TraceMemoryFlag.VOLATILE -> "_volatile";
            default -> throw new AssertionError();
        };
    }

    @Override
    public void setFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : TraceMemoryFlag.values()) {
                this.object.setValue(lifespan, DBTraceMemoryRegion.keyForFlag(flag), flags.contains((Object)flag));
            }
        }
    }

    @Override
    public void addFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : flags) {
                this.object.setValue(lifespan, DBTraceMemoryRegion.keyForFlag(flag), true);
            }
        }
    }

    @Override
    public void clearFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : flags) {
                this.object.setValue(lifespan, DBTraceMemoryRegion.keyForFlag(flag), false);
            }
        }
    }

    @Override
    public void setFlags(long snap, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setFlags(Lifespan.nowOn(snap), flags);
        }
    }

    @Override
    public void addFlags(long snap, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.addFlags(Lifespan.nowOn(snap), flags);
        }
    }

    @Override
    public void clearFlags(long snap, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.clearFlags(Lifespan.nowOn(snap), flags);
        }
    }

    @Override
    public Set<TraceMemoryFlag> getFlags(long snap) {
        EnumSet<TraceMemoryFlag> result = EnumSet.noneOf(TraceMemoryFlag.class);
        for (TraceMemoryFlag flag : TraceMemoryFlag.values()) {
            DBTraceObjectValue value = this.object.getValue(snap, DBTraceMemoryRegion.keyForFlag(flag));
            if (value == null || value.getValue() != Boolean.TRUE) continue;
            result.add(flag);
        }
        return result;
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected void updateViewsAdded() {
        this.object.getTrace().updateViewsAddRegionBlock(this);
    }

    protected void updateViewsLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
        this.object.getTrace().updateViewsChangeRegionBlockLifespan(this, oldLifespan, newLifespan);
    }

    protected void updateViewsValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
        DBTrace trace = this.object.getTrace();
        if (this.translator.keys.isRange(key)) {
            trace.updateViewsRefreshBlocks();
        } else if (this.translator.keys.isDisplay(key)) {
            trace.updateViewsChangeRegionBlockName(this);
        } else if (this.translator.keys.isFlag(key)) {
            trace.updateViewsChangeRegionBlockFlags(this, lifespan);
        }
    }

    protected void updateViewsDeleted() {
        this.object.getTrace().updateViewsDeleteRegionBlock(this);
    }

    protected class RegionChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceMemoryRegion> {
        private static final Map<TraceObjectSchema, Keys> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Keys>();
        private final Keys keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RegionChangeTranslator(DBTraceObject object, TraceMemoryRegion iface) {
            super("_range", object, iface);
            TraceObjectSchema schema = object.getSchema();
            Map<TraceObjectSchema, Keys> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, Keys::fromSchema);
            }
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Void> getAddedType() {
            return TraceEvents.REGION_ADDED;
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Lifespan> getLifespanChangedType() {
            return TraceEvents.REGION_LIFESPAN_CHANGED;
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Void> getChangedType() {
            return TraceEvents.REGION_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.all.contains(key);
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Void> getDeletedType() {
            return TraceEvents.REGION_DELETED;
        }

        @Override
        protected void emitExtraAdded() {
            DBTraceMemoryRegion.this.updateViewsAdded();
        }

        @Override
        protected void emitExtraLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
            DBTraceMemoryRegion.this.updateViewsLifespanChanged(oldLifespan, newLifespan);
        }

        @Override
        protected void emitExtraValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
            DBTraceMemoryRegion.this.updateViewsValueChanged(lifespan, key, oldValue, newValue);
        }

        @Override
        protected void emitExtraDeleted() {
            DBTraceMemoryRegion.this.updateViewsDeleted();
        }
    }

    protected record Keys(Set<String> all, String range, String display, Set<String> flags) {
        static Keys fromSchema(TraceObjectSchema schema) {
            String keyRange = schema.checkAliasedAttribute("_range");
            String keyDisplay = schema.checkAliasedAttribute("_display");
            String keyReadable = schema.checkAliasedAttribute("_readable");
            String keyWritable = schema.checkAliasedAttribute("_writable");
            String keyExecutable = schema.checkAliasedAttribute("_executable");
            return new Keys(Set.of(keyRange, keyDisplay, keyReadable, keyWritable, keyExecutable), keyRange, keyDisplay, Set.of(keyReadable, keyWritable, keyExecutable));
        }

        public boolean isRange(String key) {
            return this.range.equals(key);
        }

        public boolean isDisplay(String key) {
            return this.display.equals(key);
        }

        public boolean isFlag(String key) {
            return this.flags.contains(key);
        }
    }
}

