/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.address;

import db.DBHandle;
import db.DBRecord;
import db.FixedField10;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.TraceAddressFactory;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceOverlaySpaceAdapter
implements DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceOverlaySpaceEntry> overlayStore;
    protected final DBCachedObjectIndex<String, DBTraceOverlaySpaceEntry> overlaysByName;

    public DBTraceOverlaySpaceAdapter(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.overlayStore = factory.getOrCreateCachedStore("AddressSpaces", DBTraceOverlaySpaceEntry.class, DBTraceOverlaySpaceEntry::new, true);
        this.overlaysByName = this.overlayStore.getIndex(String.class, DBTraceOverlaySpaceEntry.NAME_COLUMN);
        this.resyncAddressFactory();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.overlayStore.invalidateCache();
            this.resyncAddressFactory();
        }
    }

    protected void resyncAddressFactory() {
        TraceAddressFactory factory = this.trace.getInternalAddressFactory();
        this.resyncAddressFactory(factory);
    }

    protected void resyncAddressFactory(TraceAddressFactory factory) {
        HashMap keyToRecordMap = new HashMap(this.overlayStore.asMap());
        ArrayList<ProgramOverlayAddressSpace> renameList = new ArrayList<ProgramOverlayAddressSpace>();
        for (AddressSpace space : factory.getAllAddressSpaces()) {
            if (!(space instanceof ProgramOverlayAddressSpace)) continue;
            ProgramOverlayAddressSpace os = (ProgramOverlayAddressSpace)space;
            String name = os.getName();
            DBTraceOverlaySpaceEntry ent = (DBTraceOverlaySpaceEntry)((Object)keyToRecordMap.get(os.getKey()));
            if (ent == null || !this.isCompatibleOverlay(os, ent, factory)) {
                factory.removeOverlaySpace(name);
                continue;
            }
            if (name.equals(ent.name)) {
                keyToRecordMap.remove(os.getKey());
                continue;
            }
            renameList.add(os);
            factory.removeOverlaySpace(name);
        }
        try {
            for (ProgramOverlayAddressSpace existingSpace : renameList) {
                long key = existingSpace.getKey();
                DBTraceOverlaySpaceEntry ent = (DBTraceOverlaySpaceEntry)((Object)keyToRecordMap.get(key));
                existingSpace.setName(ent.name);
                factory.addOverlaySpace(existingSpace);
                keyToRecordMap.remove(key);
            }
            Iterator iterator = keyToRecordMap.keySet().iterator();
            while (iterator.hasNext()) {
                long key = (Long)iterator.next();
                DBTraceOverlaySpaceEntry ent = (DBTraceOverlaySpaceEntry)((Object)keyToRecordMap.get(key));
                String spaceName = ent.name;
                AddressSpace baseSpace = factory.getAddressSpace(ent.baseSpace);
                factory.addOverlaySpace(key, spaceName, baseSpace);
            }
        }
        catch (DuplicateNameException | IllegalArgumentException e) {
            throw new AssertionError("Unexpected error updating overlay address spaces", e);
        }
        factory.refreshStaleOverlayStatus();
    }

    private boolean isCompatibleOverlay(ProgramOverlayAddressSpace os, DBTraceOverlaySpaceEntry ent, ProgramAddressFactory factory) {
        AddressSpace baseSpace = factory.getAddressSpace(ent.baseSpace);
        if (baseSpace == null) {
            throw new RuntimeException("Base space for overlay not found: " + ent.baseSpace);
        }
        return baseSpace == os.getOverlayedSpace();
    }

    protected AddressSpace doCreateOverlaySpace(String name, AddressSpace base) throws DuplicateNameException {
        TraceAddressFactory factory = this.trace.getInternalAddressFactory();
        if (!factory.isValidOverlayBaseSpace(base)) {
            throw new IllegalArgumentException("Invalid address space for overlay: " + base.getName());
        }
        if (factory.getAddressSpace(name) != null) {
            throw new DuplicateNameException("Overlay space '" + name + "' duplicates name of another address space");
        }
        DBTraceOverlaySpaceEntry ent = (DBTraceOverlaySpaceEntry)this.overlayStore.create();
        ProgramOverlayAddressSpace space = factory.addOverlaySpace(ent.getKey(), name, base);
        ent.set(space.getName(), base.getName());
        this.trace.updateViewsAddSpaceBlock((AddressSpace)space);
        this.trace.setChanged(new TraceChangeRecord<DBTrace, ProgramOverlayAddressSpace>(TraceEvents.OVERLAY_ADDED, (AddressSpace)space, this.trace, null, space));
        return space;
    }

    public AddressSpace createOverlayAddressSpace(String name, AddressSpace base) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TraceAddressFactory factory = this.trace.getInternalAddressFactory();
            if (factory.getAddressSpace(name) != null) {
                throw new DuplicateNameException("Address space " + name + " already exists.");
            }
            AddressSpace addressSpace = this.doCreateOverlaySpace(name, base);
            return addressSpace;
        }
    }

    public AddressSpace getOrCreateOverlayAddressSpace(String name, AddressSpace base) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TraceAddressFactory factory = this.trace.getInternalAddressFactory();
            AddressSpace space = factory.getAddressSpace(name);
            if (space != null) {
                AddressSpace addressSpace = space.getPhysicalSpace() == base ? space : null;
                return addressSpace;
            }
            AddressSpace addressSpace = this.doCreateOverlaySpace(name, base);
            return addressSpace;
        }
    }

    public void deleteOverlayAddressSpace(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceOverlaySpaceEntry exists = (DBTraceOverlaySpaceEntry)this.overlaysByName.getOne((Object)name);
            if (exists == null) {
                throw new NoSuchElementException(name);
            }
            this.overlayStore.delete((DBAnnotatedObject)exists);
            TraceAddressFactory factory = this.trace.getInternalAddressFactory();
            AddressSpace space = factory.getAddressSpace(name);
            assert (space != null);
            factory.removeOverlaySpace(name);
            this.trace.updateViewsDeleteSpaceBlock(space);
            this.trace.setChanged(new TraceChangeRecord<DBTrace, Object>(TraceEvents.OVERLAY_DELETED, space, this.trace, space, null));
            this.invalidateCache(true);
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceOverlaySpaceEntry
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "AddressSpaces";
        static final String NAME_COLUMN_NAME = "Name";
        static final String BASE_COLUMN_NAME = "Base";
        @DBAnnotatedColumn(value="Name")
        static DBObjectColumn NAME_COLUMN;
        @DBAnnotatedColumn(value="Base")
        static DBObjectColumn BASE_COLUMN;
        @DBAnnotatedField(column="Name", indexed=true)
        String name;
        @DBAnnotatedField(column="Base")
        String baseSpace;

        public DBTraceOverlaySpaceEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        void set(String name, String baseSpace) {
            this.name = name;
            this.baseSpace = baseSpace;
            this.update(NAME_COLUMN, BASE_COLUMN);
        }
    }

    public static class AddressDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<Address, OT, FixedField10> {
        static final Charset UTF8 = Charset.forName("UTF-8");

        public static byte[] encode(Address address) {
            if (address == null) {
                return null;
            }
            AddressSpace as = address.getAddressSpace();
            ByteBuffer buf = ByteBuffer.allocate(10);
            buf.putShort((short)as.getSpaceID());
            buf.putLong(address.getOffset());
            return buf.array();
        }

        public static Address decode(byte[] enc, DBTraceOverlaySpaceAdapter osa) {
            if (enc == null) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(enc);
            short id = buf.getShort();
            AddressSpace as = osa.trace.getInternalAddressFactory().getAddressSpace(id);
            long offset = buf.getLong();
            return as.getAddress(offset);
        }

        public AddressDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Address.class, objectType, FixedField10.class, field, column);
        }

        public void store(Address value, FixedField10 f) {
            f.setBinaryData(AddressDBFieldCodec.encode(value));
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, AddressDBFieldCodec.encode((Address)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            byte[] data = record.getBinaryData(this.column);
            this.setValue((DBAnnotatedObject)obj, AddressDBFieldCodec.decode(data, ((DecodesAddresses)obj).getOverlaySpaceAdapter()));
        }
    }

    public static interface DecodesAddresses {
        public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter();
    }
}

