/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainObject;

public class DefaultDomainFileFilter
implements DomainFileFilter {
    private final Class<? extends DomainObject> domainObjectClass;
    private final boolean ignoreExternalLinks;

    public DefaultDomainFileFilter(Class<? extends DomainObject> domainObjectClass, boolean ignoreExternalLinks) {
        this.domainObjectClass = domainObjectClass;
        this.ignoreExternalLinks = ignoreExternalLinks;
    }

    @Override
    public boolean accept(DomainFile file) {
        return this.domainObjectClass != null && this.domainObjectClass.isAssignableFrom(file.getDomainObjectClass());
    }

    @Override
    public boolean ignoreExternalLinks() {
        return this.ignoreExternalLinks;
    }
}

