/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.datatable.ProjectTreeAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.store.FileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class ProjectDataSelectAction
extends ProjectTreeAction {
    public ProjectDataSelectAction(String owner, String group) {
        super("Select All", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Select Children"}, group));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        GTreeNode node = (GTreeNode)paths[0].getLastPathComponent();
        this.selectAllChildren(tree, node);
    }

    @Override
    public boolean isAddToPopup(FrontEndProjectTreeContext context) {
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        if (context.getFolderCount() == 1) {
            return true;
        }
        DomainFile folderLinkFile = context.getSelectedFiles().get(0);
        return ProjectDataSelectAction.canTraverseFolderLinkFile(folderLinkFile);
    }

    private static boolean canTraverseFolderLinkFile(DomainFile file) {
        if (file.isLink() && file.getLinkInfo().isFolderLink()) {
            String filePath = file.getPathname() + FileSystem.SEPARATOR;
            try {
                Object linkPath = LinkHandler.getAbsoluteLinkPath(file);
                if (!((String)linkPath).endsWith(FileSystem.SEPARATOR)) {
                    linkPath = (String)linkPath + FileSystem.SEPARATOR;
                }
                if (!filePath.startsWith((String)linkPath)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void selectAllChildren(DataTree tree, GTreeNode node) {
        ArrayList paths = new ArrayList();
        tree.runTask(monitor -> {
            GTreeExpandAllTask task = new GTreeExpandAllTask((GTree)tree, node);
            task.run(monitor);
            this.getAllTreePaths(node, paths);
            tree.setSelectionPaths(paths);
        });
    }

    private void getAllTreePaths(GTreeNode node, List<TreePath> paths) {
        List children = node.getChildren();
        for (GTreeNode child : children) {
            if (child instanceof DomainFileNode) {
                DomainFileNode fileNode = (DomainFileNode)child;
                if (fileNode.isLeaf()) {
                    paths.add(child.getTreePath());
                    continue;
                }
                if (!ProjectDataSelectAction.canTraverseFolderLinkFile(fileNode.getDomainFile())) continue;
            }
            paths.add(child.getTreePath());
            this.getAllTreePaths(child, paths);
        }
    }
}

