/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainFileProxy;
import ghidra.framework.data.DomainObjectChangeSupport;
import ghidra.framework.data.DomainObjectFileListener;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.UserData;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.LockException;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.ListenerSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DomainObjectAdapter
implements DomainObject {
    protected static final String DEFAULT_NAME = "untitled";
    private static HashMap<String, ContentHandler<?>> contentHandlerTypeMap;
    private static HashMap<Class<?>, ContentHandler<?>> contentHandlerClassMap;
    private static ChangeListener contentHandlerUpdateListener;
    protected String name;
    private DomainFile domainFile;
    private DomainObjectChangeSupport docs;
    protected Map<EventQueueID, DomainObjectChangeSupport> changeSupportMap = new ConcurrentHashMap<EventQueueID, DomainObjectChangeSupport>();
    private volatile boolean eventsEnabled = true;
    private ListenerSet<DomainObjectClosedListener> closeListeners = new ListenerSet(DomainObjectClosedListener.class, false);
    private ListenerSet<DomainObjectFileListener> fileChangeListeners = new ListenerSet(DomainObjectFileListener.class, false);
    private ArrayList<Object> consumers;
    protected Map<String, String> metadata = new LinkedHashMap<String, String>();
    protected boolean changed = false;
    protected boolean temporary = false;
    protected Lock lock = new Lock("Domain Object");
    private long modificationNumber = 1L;

    protected DomainObjectAdapter(String name, int timeInterval, Object consumer) {
        Objects.requireNonNull(consumer, "Consumer must not be null");
        this.name = name;
        this.docs = new DomainObjectChangeSupport(this, timeInterval, this.lock);
        this.consumers = new ArrayList();
        this.consumers.add(consumer);
        if (!UserData.class.isAssignableFrom(this.getClass())) {
            this.domainFile = new DomainFileProxy(name, this);
        }
    }

    public void invalidate() {
        this.fireEvent(new DomainObjectChangeRecord(DomainObjectEvent.RESTORED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Object consumer) {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            if (!this.consumers.remove(consumer)) {
                throw new IllegalArgumentException("Attempted to release domain object with unknown consumer: " + String.valueOf(consumer));
            }
            if (this.consumers.size() != 0) {
                return;
            }
        }
        this.close();
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    protected FileSystem getAssociatedUserFilesystem() {
        if (this.domainFile instanceof GhidraFile) {
            return ((GhidraFile)this.domainFile).getUserFileSystem();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        String classname = this.getClass().getName();
        classname = classname.substring(classname.lastIndexOf(46));
        return this.name + " - " + classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String newName) {
        DomainObjectAdapter domainObjectAdapter = this;
        synchronized (domainObjectAdapter) {
            if (this.name.equals(newName)) {
                return;
            }
            this.name = newName;
            this.changed = true;
        }
        this.fireEvent(new DomainObjectChangeRecord(DomainObjectEvent.RENAMED));
    }

    private void clearDomainObj() {
        if (this.domainFile instanceof GhidraFile) {
            GhidraFile file = (GhidraFile)this.domainFile;
            file.clearDomainObj();
        } else if (this.domainFile instanceof DomainFileProxy) {
            DomainFileProxy df = (DomainFileProxy)this.domainFile;
            df.clearDomainObj();
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed && !this.temporary;
    }

    @Override
    public void setTemporary(boolean state) {
        this.temporary = state;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    protected void setDomainFile(DomainFile df) throws DomainObjectException {
        if (df == null) {
            throw new IllegalArgumentException("DomainFile must not be null");
        }
        if (df == this.domainFile) {
            return;
        }
        this.clearDomainObj();
        DomainFile oldDf = this.domainFile;
        this.domainFile = df;
        this.fireEvent(new DomainObjectChangeRecord(DomainObjectEvent.FILE_CHANGED, oldDf, df));
        ((DomainObjectFileListener)this.fileChangeListeners.invoke()).domainFileChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        DomainObjectAdapter domainObjectAdapter = this;
        synchronized (domainObjectAdapter) {
            this.clearDomainObj();
        }
        this.docs.dispose();
        for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
            queue.dispose();
        }
        ((DomainObjectClosedListener)this.closeListeners.invoke()).domainObjectClosed(this);
        this.closeListeners.clear();
    }

    @Override
    public void flushEvents() {
        this.docs.flush();
        for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
            queue.flush();
        }
    }

    public boolean getChangeStatus() {
        return this.changed;
    }

    @Override
    public void addListener(DomainObjectListener l) {
        this.docs.addListener(l);
    }

    @Override
    public void removeListener(DomainObjectListener l) {
        this.docs.removeListener(l);
    }

    @Override
    public void addCloseListener(DomainObjectClosedListener listener) {
        this.closeListeners.add((Object)listener);
    }

    @Override
    public void removeCloseListener(DomainObjectClosedListener listener) {
        this.closeListeners.remove((Object)listener);
    }

    @Override
    public void addDomainFileListener(DomainObjectFileListener listener) {
        this.fileChangeListeners.add((Object)listener);
    }

    @Override
    public void removeDomainFileListener(DomainObjectFileListener listener) {
        this.fileChangeListeners.remove((Object)listener);
    }

    @Override
    public EventQueueID createPrivateEventQueue(DomainObjectListener listener, int maxDelay) {
        EventQueueID eventQueueID = new EventQueueID();
        DomainObjectChangeSupport queue = new DomainObjectChangeSupport(this, maxDelay, this.lock);
        queue.addListener(listener);
        this.changeSupportMap.put(eventQueueID, queue);
        return eventQueueID;
    }

    @Override
    public boolean removePrivateEventQueue(EventQueueID id) {
        DomainObjectChangeSupport queue = this.changeSupportMap.remove(id);
        if (queue == null) {
            return false;
        }
        queue.dispose();
        return true;
    }

    @Override
    public void flushPrivateEventQueue(EventQueueID id) {
        DomainObjectChangeSupport queue = this.changeSupportMap.get(id);
        if (queue != null) {
            queue.flush();
        }
    }

    @Override
    public abstract String getDescription();

    public void fireEvent(DomainObjectChangeRecord ev) {
        ++this.modificationNumber;
        if (this.eventsEnabled) {
            this.docs.fireEvent(ev);
            for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
                queue.fireEvent(ev);
            }
        }
    }

    @Override
    public void setEventsEnabled(boolean v) {
        if (this.eventsEnabled != v) {
            this.eventsEnabled = v;
            if (this.eventsEnabled) {
                DomainObjectChangeRecord docr = new DomainObjectChangeRecord(DomainObjectEvent.RESTORED);
                this.docs.fireEvent(docr);
                for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
                    queue.fireEvent(docr);
                }
            }
        }
    }

    @Override
    public boolean isSendingEvents() {
        return this.eventsEnabled;
    }

    @Override
    public boolean hasExclusiveAccess() {
        return this.domainFile == null || !this.domainFile.isCheckedOut() || this.domainFile.isCheckedOutExclusive();
    }

    public void checkExclusiveAccess() throws LockException {
        if (!this.hasExclusiveAccess()) {
            throw new LockException("Operation requires exclusive access to object.");
        }
    }

    protected void setChanged(boolean state) {
        this.changed = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConsumer(Object consumer) {
        Objects.requireNonNull(consumer, "Consumer must not be null");
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            if (this.isClosed()) {
                return false;
            }
            this.consumers.add(consumer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasConsumers() {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsedBy(Object consumer) {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.contains(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> getConsumerList() {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return new ArrayList<Object>(this.consumers);
        }
    }

    public static synchronized ContentHandler<?> getContentHandler(String contentType) throws IOException {
        DomainObjectAdapter.checkContentHandlerMaps();
        ContentHandler<?> ch = contentHandlerTypeMap.get(contentType);
        if (ch == null) {
            throw new IOException("Content handler not found for content-type: " + contentType);
        }
        return ch;
    }

    public static synchronized ContentHandler<?> getContentHandler(Class<? extends DomainObject> dobjClass) throws IOException {
        DomainObjectAdapter.checkContentHandlerMaps();
        ContentHandler<?> ch = contentHandlerClassMap.get(dobjClass);
        if (ch == null) {
            throw new IOException("Content handler not found for " + dobjClass.getName());
        }
        return ch;
    }

    public static ContentHandler<?> getContentHandler(DomainObject dobj) throws IOException {
        return DomainObjectAdapter.getContentHandler(dobj.getClass());
    }

    public static Set<ContentHandler<?>> getContentHandlers() {
        DomainObjectAdapter.checkContentHandlerMaps();
        return new HashSet(contentHandlerTypeMap.values());
    }

    private static void checkContentHandlerMaps() {
        if (contentHandlerTypeMap != null) {
            return;
        }
        DomainObjectAdapter.initContentHandlerMaps();
        ClassSearcher.addChangeListener((ChangeListener)contentHandlerUpdateListener);
    }

    private static synchronized void initContentHandlerMaps() {
        HashMap classMap = new HashMap();
        HashMap<String, ContentHandler> typeMap = new HashMap<String, ContentHandler>();
        List handlers = ClassSearcher.getInstances(ContentHandler.class);
        for (ContentHandler ch : handlers) {
            Class contentClass;
            String contentType = ch.getContentType();
            if (typeMap.put(contentType, ch) != null) {
                Msg.error(DomainObjectAdapter.class, (Object)("Multiple content handlers discovered for content type: " + contentType));
            }
            if (ch instanceof LinkHandler || classMap.put(contentClass = ch.getDomainObjectClass(), ch) == null) continue;
            Msg.error(DomainObjectAdapter.class, (Object)("Multiple content handlers discovered for content class: " + contentClass.getSimpleName()));
        }
        contentHandlerClassMap = classMap;
        contentHandlerTypeMap = typeMap;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public long getModificationNumber() {
        return this.modificationNumber;
    }

    protected void fatalErrorOccurred(Exception e) {
        this.docs.fatalErrorOccurred(e);
        for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
            queue.fatalErrorOccurred(e);
        }
        throw new DomainObjectException(e);
    }

    static {
        contentHandlerUpdateListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DomainObjectAdapter.initContentHandlerMaps();
            }
        };
    }
}

